#include <conio.h>
#include <alloc.h>
#include <string.h>
#include <dir.h>
#include <dos.h>

#include "../gui/head.h"
#include "../gui/texte.h"
#include "../gui/design.h"
#include "../gui/popwin.h"
#include "../gui/souris.h"
#include "../gui/gets18.h"
#include "../gui/lift.h"
#include "../gui/fileman.h"
#include "../gui/dirtools.h"
#include "../gui/winmenu.h"
#include "../gui/message.h"
#include "../gui/winmove.h"
#include "../gui/drive.h"
#include "../gui/alt.h"

#include "listgui.h"
#include "listini.h"
#include "listdir.h"
#include "listarbo.h"


/*
  Fonctions:
  - entrer une chaine
  - choisir un niveau
  - afficher l'arbre
  - amnager la mmoire
*/

#define max(a,b)        (((a) > (b)) ? (a) : (b))
#define min(a,b)        (((a) < (b)) ? (a) : (b))

int OP_DEST=0;
char B_DEST = 7;
char T_DEST = 2;
int X_DEST = 15;
int Y_DEST = 5;
int W_DEST = 50;
int H_DEST = 20;


char *ARBOBUF;
char *BUFPTR;
int ARBOTOP;
int TABMAX;
int NLINE;

int DISPH = 25;
#define DISPT 2

int DISPSTART;
char BLANK[41]="                                        ";
int PILE[16];
int COUNTER;

char treepath[128];

char *winarbotext[]=
    {
        "",
        " G_o here",
        " A_dd sub-dir",
        " M_ove",
        " S_ize",
        " C_lose",
        ""
    };

int winarbokeys[10]= {  'g', 'a','m',  's', 'c',
                        'g', 'a', 'm', 's', ALT_F4 };


/*-----------------
   LECTURE-ECRITURE
-------------------*/

struct tabl huge *TABL;

/* donne l'adresse d'un chainon */

struct tabl huge *getarbo(int no)
{
    return (TABL+no);
}

/* efface un chainon */

cleartabl(int no)
{
    struct tabl huge *adr;

    adr = TABL + no;
    adr->suivant = 0;
    adr->child = 0;
    adr->parent = 0;
    adr->strbuf = 0;
}

/* place une chaine dans un chainon */

int writebuf(char *str, int no)
{
    struct tabl huge *curtab;

    curtab = getarbo(no);
    curtab->strbuf = BUFPTR;
    strcpy(BUFPTR, str);
    BUFPTR += (strlen(str) + 1);
}

/* retourne une chaine dans un chainon */

char *readtabl(struct tabl huge *sttptr)
{
    char *adr;

    adr = sttptr->strbuf;
    return(adr);
}

/*------------------------------------------------
   LECTURE DE LIEN: adresse child, parent, suivant
--------------------------------------------------*/

int getchild(int no)
{
    struct tabl huge *adr;

    adr = TABL+no;
    return(adr->child);
}

int getparent(int no)
{
    struct tabl huge *adr;

    adr = TABL+no;
    return(adr->parent);
}

int getnext(int no)
{
    struct tabl huge *adr;

    adr = TABL+no;
    return(adr->suivant);
}

/*----------------------------------------------
   CREATION DE LIENS: lie child, suivant, parent
------------------------------------------------*/

int setnext(int no,int nouveau)
{
    struct tabl huge *curtab;
    int old;

    curtab = getarbo(no);
    old = curtab->suivant;
    curtab->suivant = nouveau;
    return(old);
}

int setchild(int no,int child)
{
    struct tabl huge *curtab;
    int old;

    curtab=getarbo(no);
    old=curtab->child;
    curtab->child=child;
    return(old);
}

void setparent(int no,int parent)
{
    struct tabl huge *curtab;

    curtab=getarbo(no);
    curtab->parent=parent;
}


/*---------------------------
  CREATION D'ENREGISTREMENTS
-----------------------------*/


/* ajoute sans lien un enregistrement */

int creatabl(char *str)
{
    if(ARBOTOP>=TABMAX)
        return(0);
    cleartabl(ARBOTOP);
    writebuf(str,ARBOTOP);
    ARBOTOP++;
    return(ARBOTOP-1);
}

/*
    Ajouter et lier en tant que child
    Exemple:
    En tant que sous-rpertoire  un rpertoire de numro donn
*/

int addchild(char *str,int no)
{
    int nouv;
    nouv = creatabl(str);
    setchild(no,nouv);
    return(nouv);
}

/*
   Ajouter et lie a un enregistrement donn de mme niveau
   Example:
   Autre fichier  un fichier ou sous-rpertoire  un s. r.
*/

int addnext(char *str,int no)
{
    int nouv=0;

    nouv=creatabl(str);
    setnext(no,nouv);

    return(nouv);
}


/*---------------------------
  AFFICHAGE D'ENREGISTREMENT
-----------------------------*/

/* retourne le numro de chainon qui contient
   le texte correspondant  une ligne donne
   en paramtre. L'ordre de chainage correspond
    l'ordre des lignes */

int COUNT;
int CTAB;

void getsub(int i,int ttab)
{
    struct tabl huge *linkadr;

loop:
    if(COUNT > 0)
    {
        CTAB = ttab;
        PILE[ttab]= i;
        linkadr = getarbo(i);

        if(linkadr)
        {
            COUNT--;
            i = linkadr->child;
            if(i)
                getsub(i,ttab+1);
            i = linkadr->suivant;
            if(i)
                goto loop;
        }
    }
    return;
}


int getchainon(int ligne)
{
    CTAB = 0;
    COUNT = ligne;
    getsub(getchild(0),1);
    return(PILE[CTAB]);
}

/* on veut le numro de ligne pour le chainon  d'une ligne */

int getno(int ref)
{
    int j;

    j = 0;
    while( getchainon(j) != ref)
        j++;
    return(j);
}



char PATH[81];
int DIRNO;
int ARBOMAX;
int DIRX;
int DIRY;
int CX;
int CY;
int DIREND;
#define STARTFILE 1
int MFLAG;


void maketree(int parent)
{
    struct ffblk repbloc;
    int NLINE;
    int suiv;
    struct tabl huge *curtab;
    int i,k;
    char *adr;


    k = strlen(treepath);
    strcpy(treepath + k, "\\*.*");

    suiv = parent;

    NLINE=0;
    if(findfirst(treepath, &repbloc, FA_DIREC))
        goto pass;

loop:
    strlwr(repbloc.ff_name);

    if( (repbloc.ff_attrib & FA_DIREC) && (repbloc.ff_name[0] != '.'))
    {
        if(NLINE == 0)
        {
            suiv = addchild(repbloc.ff_name,parent);
            setparent(suiv,parent);
        }
        else
        {
            suiv = addnext(repbloc.ff_name,suiv);
            setparent(suiv,parent);
        }
        ARBOMAX++;
        NLINE++;
    }
    if(!findnext(&repbloc))
        goto loop;

    suiv = getchild(parent);

    for(i = 0; i < NLINE;i++)
    {
        curtab = TABL + suiv;
        adr = curtab->strbuf;
        strcpy(treepath + k + 1, adr);

        maketree(suiv);
        suiv = getnext(suiv);
    }

pass:
    treepath[k] = 0;
}



/* Affiche l'arborescence
   no: numro du premier
   tab: niveau
   Le numro 32767 usage particulier avec dest.c
*/



void dispsub(int no,int tab)
{
    int nochild,old;
    int c;

    if(!no)
        goto pass;

loop:
    old = no;
    COUNTER++;
    nochild = getchild(no);
    no = getnext(no);
    PILE[tab] = no;

    if(NLINE < DISPH)
    {
        if(COUNTER >=  DISPSTART)
        {
            winwrite18(1, NLINE + DISPT, BLANK);
            c = 0;
            YLOC = WU + NLINE + DISPT + 1;
            XLOC = WL + 2;
            while(c < tab)
            {
                if(PILE[c])
                    printc(179);
                else
                    XLOC++;
                XLOC ++;
                c++;
            }
            XLOC = WL + tab * 2 + 2;
            if(tab)
            {
                if(no)
                    printc(195);
                else
                    printc(192);
                printc(196);
            }
            print( readtabl(getarbo(old)));
            NLINE++;
        }

        /* cette ligne adapte  dest.c */

        if(nochild)
        {
            if(nochild != 32767)
                dispsub(nochild,tab+1);
            else
                printc(26);
        }
        if(no)
            goto loop;
    }

pass:
    return;
}


/* Affiche l'arborescence */

void disptree()
{
    int i;

    COUNTER = 0;
    NLINE = 0;

    dispsub(getchild(0),0);

    i = NLINE + 1;
    while(i < DISPH)
    {
        winwritef18( 1, DISPT + i, "%40s","");
        i++;
    }
}



void selectdir(int code)
{
    int no;
    int tab;
    char *adr;

    no = getchainon(DIRNO);

    if(CTAB > 1)
        tab = CTAB * 2 + 1;
    else
        tab = 1;
    adr = (char *) readtabl(getarbo(no));

    if(code)
    {
        wintextcol( 0, B_DEST);
    }
    else
    {
        wintextcol( B_DEST, 0);
    }
    mhide();
    winwrite18(tab, CY, adr);

    strcpy((char *)PATH, readtabl(getarbo(PILE[1])));
    for(tab = 2; tab <= CTAB; tab++)
    {
        no = PILE[tab];
        pathcat((char *) PATH, readtabl(getarbo(no)));
    }
    /* dispbottom((char *)PATH);*/
}


int open_tree()
{
    int i;
    char ROOT[3]=" :";
    char search[67];
    char path[67];
    char oldir[67];
    int diskx,disky;

    TABMAX=1024;
    ARBOBUF =(char *) malloc(TABMAX*13);
    TABL = (struct tabl huge *)malloc(10*TABMAX);
    BUFPTR = ARBOBUF;

    if(FP_SEG(ARBOBUF))
        if(FP_SEG(TABL))
            if(FP_SEG(BOXBUF))
                goto okmalloc;

    return(0);

okmalloc:
    newcursor(0);
    getcwd(oldir, 81);

    *ROOT = getdisk() + 65;

    DIRX = 0;
    textcol(0,2);

    for(i = 0; i < TABMAX; i++)
        cleartabl(i);

    ARBOTOP = 0;
    creatabl("root");

    disky = 0;
    strcpy(search," :");
    i = 0;
    for(diskx = 0; diskx < DISKMAX; diskx++)
    {
        *search = 'A' + DISKS[diskx];
        if(disky == 0)
            i = addchild(search, 0);
        else
            i = addnext(search, i);
        setparent(i, 0);
        disky = 1;
    }

    copycat(search,ROOT,"\\");
    i = addnext(search,i);
    setparent(i, 0);

    DIRNO = i;
    DISPSTART = 1;
    ARBOMAX = i;

    strcpy( path, ROOT);
    strcpy( search, "\\");
    chdir("\\");

    BOXBACK = B_DEST;
    showbox("Reading disk tree...");

    maketree(DIRNO);
    clearkey();
    hidebox();
    cdd(oldir);
    return(1);
}

void close_tree()
{
    free(ARBOBUF);
    free((char *)TABL);
}


int disp_tree()
{
    int CYBOTTOM;
    char oldir[81];
    int  ml,mc,DIRNOLD;
    int ch;
    int a, i, j, b;
    int oldimage = MOUSIMAGE;
    int fnew = 0;
    int ret  = 0;

    OP_DEST = 0;

    getcwd(oldir, 81);

redisp:
    locate(1,2);
    mhide();
    if( B_DEST == 3)
        B_DEST++;
    if( B_DEST == 0)
        T_DEST = 15;
    WINMOVE_FLAG = 1;
    wincolor( B_DEST, T_DEST, 0);
    wincreate(X_DEST, Y_DEST, X_DEST + W_DEST - 1, Y_DEST + H_DEST - 1,  "Disk tree");
    BACKCOL = B_DEST;
    PENCOL = 0;

    LIFTTMARGIN = 24;
    LIFTRMARGIN = 4;
    LIFTBMARGIN = 4;
    B_LIFT = T_DEST;
    putlift(1);

    DISPH = WH - 3;

    redo
:
    disptree();

    DIRNO     = max( STARTFILE, DIRNO);
    DISPSTART  = min( DISPSTART, DIRNO);
    DISPSTART  = min( DISPSTART, ARBOMAX - DISPH + 1);
    DISPSTART  = max( 1, DISPSTART);
    DIREND    = min( DISPSTART + DISPH - 1, ARBOMAX);
    DIRNO     = min( DIRNO, DIREND);
    CYBOTTOM =  min( DISPT + DISPH - 1, DISPT + (ARBOMAX - DISPSTART ));


dirloopCY:
    CY = DIRNO - DISPSTART + DISPT;

dirloop:
    numberlift(DIRNO-1, ARBOMAX);
    selectdir(4);
    DIRNOLD = DIRNO;

oloop2:
    if(MOUSE)
    {
        mshow();
        while(!kbhit())
        {
oloop1:
            click = mclick();
            mc = mx >> 3;
            ml = my >> 4;
            ch = '\0';
            if(click)
            {
                WITH_MOUSE = MOUSE;
                if(fnew)
                {
                    ch = 23;
                    goto parse;
                }

                if(titleinside())
                {
                    ch = 'm';
                    goto parse;
                }
                mrelease(1);
                if(wininside())
                {
                    if(sysinside())
                    {
                        ch = -17;
                        goto skipget;
                    }
                    i = DIRNO;
                    ch = wmouselift(&i, ARBOMAX);

                    if(ch > 1000)
                        goto skiprel;
                    if(ch != -1)
                    {
                        ch = 0;
                        selectdir(0);
                        DIRNO = i + 1;
                        if( DIRNO < DISPSTART)
                        {
                            DISPSTART = DIRNO;
                            goto redo
                            ;
                        }
                        if( DIRNO > DIREND)
                        {
                            DISPSTART = min( ARBOMAX - DISPH + 1, DISPSTART + (DIRNO - DIREND));
                            DISPSTART = max(0, DISPSTART);
                            goto redo
                            ;
                        }
                        goto dirloopCY;
                    }

                    a = mc - WL;
                    b = ml - (WU + DISPT);

                    if(a >= 1)
                        if(a < (WW - 3))
                            if(b >= 0)
                                if(b < (DISPH))
                                {
                                    selectdir(0);
                                    DIRNO = min( DISPSTART + b, ARBOMAX);
                                    if(DIRNO == DIRNOLD)
                                    {
                                        if(OLDIMAGE == MOUSE_HAND)
                                            ch = 'y';
                                        else
                                            ch = ENTER;
                                        goto skipget;
                                    }
                                    goto dirloopCY;
                                }
                    goto oloop1;
                } /* fin testwin */
                ch = ESCAPE;
                goto skipget;
            } /* fin click */

            fnew = testcorner(testborder(0));
            newcursor(fnew);
        } /* fin kbhit */
    }  /* fin mouse */


rech:
    ch = get1000();

skipget:
    mrelease(2);

skiprel:
    mhide();
    selectdir(0);

parse:
    switch(ch)
    {
    case 1073:
        if(DIRNO == STARTFILE)
            break;
        if(DIRNO == DISPSTART)
        {
            DISPSTART = max(1, DISPSTART - DISPH);
            DIRNO     = DISPSTART;
            goto redo
            ;
        }
        DIRNO = max(DISPSTART, STARTFILE);
        CY = DISPT;
        break;
    case 1081:
        if(CY == CYBOTTOM)
        {
            DISPSTART = min(DIRNO, ARBOMAX - DISPH + 1);
            goto redo
            ;
        }
        DIRNO = DIREND;
        CY    = CYBOTTOM;
        break;
    case 1116:
        i = getchainon(DIRNO);
        j = getnext(i);
        a = 0;

        if(j)
        {
            while( i < j)
            {
                DIRNO++;
                a++;
                i = getchainon(DIRNO);
            }

            if(DIRNO > DIREND)
            {
                DISPSTART = min(ARBOMAX-DISPH+1,DIRNO);
                goto redo
                ;
            }
            CY += a;
        }
        break;

    case 1072:
        if( DIRNO > DISPSTART)
        {
            DIRNO--;
            CY--;
            break;
        }
        if( DISPSTART > 1)
        {
            DISPSTART--;
            DIRNO--;
            goto redo
            ;
        }
        break;
    case 1080:
        i = getnext(getchainon(DIRNO));
        if(i )
        {
            DIRNO = getno( i );
            if(DIRNO <= DIREND)
                goto dirloopCY;
            DISPSTART = min(DIRNO, ARBOMAX - DISPH + 1);
            goto redo
            ;
        }

    case 1077:
        if(CY < CYBOTTOM)
        {
            CY++;
            DIRNO++;
            break;
        }
        if(DIRNO < ARBOMAX)
        {
            DISPSTART++;
            DIRNO++;
            goto redo
            ;
        }
        break;
    case 1075:
        i = getparent(getchainon(DIRNO));
        if(i < 1)
            break;
        DIRNO = getno(i);
        if(DIRNO >= DISPSTART)
            goto dirloopCY;
        DISPSTART = DIRNO;
        goto redo
        ;

    case 1071:
        DISPSTART = STARTFILE;
        DIRNO = DISPSTART;
        CY = DISPT;
        goto redo
        ;
    case 1079:
        DISPSTART = max(0, ARBOMAX - DISPH + 1);
        CY = CYBOTTOM;
        DIREND = min( ARBOMAX, DISPSTART + DISPH - 1);
        DIRNO  = DIREND;
        goto redo
        ;

    case F1:
    case -17:
        ch =  wmenu(winarbotext, winarbokeys, 5);
        goto parse;

    case 'm':
        newcursor(MOUSE_MOVE);
        ch = 23;
        goto parse;
    case 's':
        newcursor(MOUSE_SE);
    case 23:
        TOP_MOVE = 4 * 16;
        move(&X_DEST, &Y_DEST, &W_DEST, &H_DEST, 32, 7, 80, 22);
        OP_DEST = 1;
        ret = -1;
        goto retdir;

    case ENTER:
        if(DIRNO < (DISKMAX + 1))
        {
            ch = (int) *PATH;
            goto parse;
        }
        if(DIRNO == (DISKMAX + 1))
            break;

    case 'g':
        cdd(PATH);
        ret = 'g';
        goto exit;
    case 'a':
    case 'k':
        if(!make_directory(PATH))
            goto redisp;
        close_tree();
        open_tree();
        goto redisp;
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
        setdisk( ch - 'A');
        ret = 't';
        goto exit;

    case ALT_F4:
    case 'q':
    case 27:
        ret = 27;
        goto retdir;
    default:
        break;
    }
    goto dirloop;


retdir:
    cdd(oldir);

exit:
    newcursor(oldimage);
    return(ret);
}



