
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>
#include <io.h>
#include <time.h>
#include <dos.h>
#include <process.h>
#include <dir.h>
#include <alloc.h>

#include "../gui/head.h"
#include "../gui/vgalib.h"
#include "../gui/texte.h"
#include "../gui/design.h"
#include "../gui/popwin.h"
#include "../gui/drive.h"
#include "../gui/print.h"
#include "../gui/dirtools.h"
#include "../gui/zip.h"
#include "../gui/super.h"
#include "../gui/souris.h"
#include "../gui/fileman.h"
#include "../gui/dosman.h"
#include "../gui/scroll.h"
#include "../gui/gets18.h"
#include "../gui/windos.h"
#include "../gui/message.h"
#include "../gui/lift.h"
#include "../gui/winmenu.h"
#include "../gui/beeper.h"
#include "../gui/winzip.h"
#include "../gui/gostop.h"
#include "../gui/winfrmt.h"
#include "../gui/menu.h"
#include "../gui/keys.h"
#include "../gui/bulle.h"
#include "../gui/alt.h"

#include "listgui.h"
#include "../gui/vga.h"
#include "listico.h"
#include "listini.h"
#include "listsort.h"
#include "listit.h"
#include "listdir.h"
#include "listkeys.h"
#include "search.h"
#include "winview.h"
#include "view.h"
#include "listarbo.h"
#include "cddest.h"
#include "cdicon.h"


#define FROM_DIR 0
#define FROM_TEXT 1

#define MASKMAX 8
#define MASKSIZE 13

#define ZIPAGAIN 2000
#define KEY_REGISTER 2001
#define VIEW_ZIP 2002
#define NORMALSIZE 2003

#define RETOUR 1
#define RESTE 0

#define OK 1
#define CANCEL 0

#define EXISTE(fichier)  (access(fichier, 0) == 0)


void MessDisk()
{
    BOXBACK = 4;
    box("Disk error");
}


char *TAG_STRING = "TAGGED LIST";

char masktext[MASKMAX][MASKSIZE];

char CLEARED_RIGHT;
char MASKIDX;
char ZIPFLAG;
char MASK[13] = "*.*";
char ZIPTEMP[13];

char ORIGDRIVE[3];
char ORIGDIR[67];

#define TYPE_FILE 0
#define TYPE_DISK 8
#define TYPE_DIR 1
#define TYPE_ROOT 3


char CURPATH[81];
unsigned char DISKS[MAXDISKS];
int DISKMAX;
int DIRMAX;
int FILEMAX;
char LOCATEFLAG;
char ZIP[81];
char BATFIC[81];
char CDLISTDRIVE[3] = "c:";
char CDLISTDIR[81];

char DISPBACK;
char DISPTEXT;

int SNUM;
int NUM;

unsigned char D[DIRSIZE];
unsigned char M[DIRSIZE];
unsigned char Y[DIRSIZE];
unsigned char filetype[DIRSIZE];

int  START;


int dirkey[]={
                 'p',
                 CTRL_HOME,  PAGE_UP,  PAGE_DOWN,  CTRL_END,  CTRL_T,
                 'l', 'c', 'e',  'z', ALT_U,
                 'o', 'b',  '<', F2,  '>'
             };

int HELPY;


char *menutxt[6][12]={
                         " Read        ENTER", " Launch",
                         " E_dit",
                         " Tag             x", " Tag all         X",
                         " Clear tags  CTL+x", " Invert tags ALT+v",
                         " Q_uit here",   " Exit        ALT+x",
                         "","","",

                         " L_ocate file",        " Ren_ame/move file",
                         " Lock file         v", " Unlock file   CTL+v",
                         " C_opy file/dir",      " D_E_L_ete file/dir",
                         " Compare dir       =","","","","","",

                         " D_isk copy",          " F_ormat",
                         " Mak_e directory",     " Make & go dir  ALT+k",
                         " Disk tree     CTRL+t"," Type path      ALT+p",
                         "","","","", "","",

                         " U_nzip archive"," Make Z_IP archive",
                         " ZIP in EXE",    " Normal size"," View FILE-I_D.DIZ","","","","","","","",

                         " Start of list   HOME"," End of list      END",
                         " Previous page  PG UP"," Next page      PG DN",
                         " Sort_"," M_ask",
                         " Enter target   R ARR",
                         " Swap dir           >","","","","",

                         " MS-DO_S command",
                         " P_rint file",
                         " Double directory   F2",
                         " B_BS/Description",

                     };


int menupar[3][6] = {
                        19, 21, 22, 19, 22, 23,
                        9, 7,   6,  5,  8,  4,
                        4,  16, 28, 40, 52, 57,
                    };

int menukey[6][12] = {
                         ENTER, 'r', 'e', 'x', 'X', CTRL_X, ALT_V, 'q', ALT_X, 0, 0, 0,
                         'l', 'n', 'v', CTRL_V, 'c', DELETE, '=', 0, 0, 0, 0, 0,
                         'd', 'f', 'k', CTRL_K, CTRL_T, ALT_P, 0, 0, 0, 0, 0, 0,
                         'u', 'z', VIEW_ZIP, NORMALSIZE, 'i', 0, 0, 0, 0, 0, 0, 0,
                         HOME, END, PAGE_UP, PAGE_DOWN, 't', 'm', KEY_RIGHT, '>', 0, 0, 0, 0,
                         'o', 'p', F2, 'b',
                     };


char *menuroot = "  A_ccess      F_iles       Disk_       Z_ip         S_elect      Mi_sc.";

int rootkeys[] = { ALT_A, ALT_F, ALT_K, ALT_Z, ALT_S, ALT_I };


void dir_lift();


char *DISKID[] = {
                     "Floppy",
                     "Hard drive",
                     "RAM drive",
                     "Subst",
                     "CD-ROM",
                 };

void putdisk(int x, int y, int c)
{
    int type;
    char *icon;
    char *txt;
    type = DriveType[c][3];

    if( (DISKS[c] > 1) && (DriveType[c][1] == 0))
        type = 5;



    switch(type)
    {
    case 1:
        icon = (char *) HardDrive;
        break;
    case 2:
        icon = (char *) RamDrive;
        break;
    case 3:
        icon = (char *) Subst;
        break;
    case 4:
        icon = (char *) CDRom;
        break;
    case 5:
        icon = (char *) Zip100;
        break;
    case 0:
    default:
        type = 0;
        icon = (char *) Floppy;
        break;
    }

    txt = (char *) DISKID[type];
    if(type == 5)
        txt = (char *) REMOVABLEID;

    icon9( x, 465 - y, icon);
    PENCOL = DISPTEXT;
    writeoncxy(x + 39, y, DISKS[c] + 'a');
    writeonxy(x + 39 + 24, y, txt);
}


void menubar()
{
    PENCOL = 0;
    MENUBAR = MENU_BACK;
    MENUROW = 0;
    MENUROOT = menuroot;
    MENU_NUMBER = 6;
    MENU_ROW_MAX = 12;
    MENUROOT_STEP = 13;
    MENUROOT_WIDTH = 12;
    MENUROOT_SIZE = 11;

    fastbar(0, 0, 79, 17, MENU_BACK);
    COLOR16 = 0;
    hline18(0, 18, 639);
    writeonxy(24, 1, menuroot);
    key_title(622, 1, 0);

}


void MessFutur()
{
    box("Not available (for now)");
}


int makedisk(int c)
{
    if(!testdisk(c))
        return(0);

    DISKS[DISKMAX] = (unsigned char) c;
    DISKMAX++;
    return(1);
}


unsigned char buttondisk(int no)
{
    if(no >= DISKMAX)
        return(0);
    return(DISKS[no] + 'A');
}


void getcurpath()
{
    getcwd(CURPATH, 81);
}

void setcurpath()
{
    cdd(CURPATH);
}


int copydir(int no)
{
    int i;
    int j;
    char var[81];
    char STRBUF[256];
    char txt[81];
    char oldest[81];

    DOSWINFLAG = 1;
    strcpy(oldest, DESTINATION);
    strcpy(var, DESTINATION);
    pathcat(var, REPBUF[no]);

    strcpy(txt,"Copy dir ");
    strcatupr(txt, REPBUF[no]);
    strcat(txt," to:");

    i = boxinput(txt, var, 60);
    if(i == 13)
        strcpy(DESTINATION, var);
    else
        return(27);

    i = 0;

    j = getdisk();
    /* if(!available(REPSIZE[no])) goto bye; */

    open_dos("COPY DIR & SUB");

    if(updestination())
        if(isdir() != 13)
            goto fini;

    sprintf(STRBUF,"XCOPY /E %s %s ", REPBUF[no], DESTINATION);
    if(mkdir(DESTINATION))   /* si != 0 non cr */
    { puts(messnomake);
        goto fini;
    }
    puts(STRBUF);
    system(STRBUF);
    puts("");

    i = 1;

fini:
    freedisk(j);
    close_dos();

bye:
    strcpy(DESTINATION, oldest);
    return(i);
}


int deltree(char *FNAME)
{
    int i;
    int j;
    char STRBUF[256];
    char txt[81];

    DOSWINFLAG = 0;
    BOXBACK = 13;
    BOXYES  = 1;
    strcpy(txt,"Delete dir ");
    strcatupr(txt, FNAME);
    strcat(txt," and content?");

    i = box(txt);
    if(i == 13)
    {
        j = getdisk();
        sprintf(STRBUF,"DELTREE /Y %s > NUL", FNAME);
        system(STRBUF);
        freedisk(j);
    }
    return(i);
}




void makezip()
{
    getcwd( ZIP, 81);
    pathcat(ZIP, ZIPNAME);
}


/* Efface un fichier dans un chemin */
/* 0 = impossible
   1 = ok
   2 = pas de nom donn
*/

int delpath(char *path, char *fic)
{
    char curpath[81];
    int ret;

    if(*path == 0)
        return(0);
    if(*fic == 0)
        return(2);

    ret = 0;    /* Pour affirmatif, si fichier non existant */
    getcwd(curpath, 80);
    cdd(path);
    if(EXISTE(fic))
        ret = unlink(fic);
    cdd(curpath);

    return(ret == 0);
}


void deltemp()
{
    if(*CDTEMP)
    {
        delpath(CDTEMP, ZIPTEMP);
        rmdir(CDTEMP);
    }
}

int deltempfile()
{
    if(*ZIPTEMP)
        return(delpath(CDTEMP, ZIPTEMP));

}



/* Place un fichier archiv en rp. temp. */

int temp_exist()
{
    if(!*CDTEMP)
    {
        BOXBACK = 4;
        box("Unable to make temporary file");
        return(0);
    }
    return(1);
}


/* Extraie un fichier d'une archive dans le rp. temporaire
   - Si fichier dja prsent et non dans ZIPTEMP, demande
     avant effacement, sinon efface directement
 
*/


int make_temp()
{
    char sep[2];
    char STRBUF[160];
    char filetarget[81];
    int i;

    if(!temp_exist())
        return(0);

    sep[1] = '\0';
    if(PATH_LEN)
        sep[0] = '\/';
    else
        sep[0] = 0;

    makezip();                      /* Chemin archive */

    if(!*ZIPTEMP)
    {
        strcpy(filetarget, CDTEMP);
        pathcat(filetarget, REPBUF[NUM]);
        if(EXISTE(filetarget))
        {
            i = answer(box("'%s' already in '%s', delete? (y/n)", REPBUF[NUM], CDTEMP));
            if(i != 13)
                return(0);
        }
    }

    strcpy(ZIPTEMP, REPBUF[NUM]);
    i = delpath(CDTEMP, ZIPTEMP);   /* Ancien fichier en archive */
    if(i == 0)
    {
        BOXBACK = 4;
        box("Enable to extract \'%s\' in \'%s\' path", ZIPTEMP, CDTEMP);
        return(0);
    }

    sprintf((char *) STRBUF,"%s %s %s%s%s %s > NUL",
            UNARCHIVERname,
            ZIP,
            PATH_IN_ZIP,
            sep,
            REPBUF[NUM],
            CDTEMP
           );

    system((char *) STRBUF);
    strcpy(FILEPATH,  CDTEMP);       /* Nouveau fichier en archive */
    pathcat(FILEPATH, ZIPTEMP);
    strcpy(NOMCHE,  ZIPTEMP);
    return(1);
}


int make_DIZ()
{
    char STRBUF[160];

    if(!temp_exist())
        return(0);

    if(*ZIPTEMP)
        delpath(CDTEMP, ZIPTEMP);      /* Ancien fichier en archive */

    makezip();                     /* Chemin archive */
    strcpy(ZIPTEMP, "FILE_ID.DIZ");

    sprintf((char *) STRBUF,"%s %s %s %s > NUL",
            UNARCHIVERname,
            REPBUF[NUM],
            ZIPTEMP,
            CDTEMP
           );

    system((char *) STRBUF);
    return(1);
}


static FILE *SF;

void fmet(char *t)
{
    if(strlen(t))
    {
        fputs(t, SF);
        fputc(13, SF);
        fputc(10, SF);
    }
}


/* Lancer un programme */

int make_bat(char *prog)
{
    char REPERTOIRE[81];
    char DISQUE[3];

    DISQUE[0] = 'C';
    DISQUE[1] = ':';
    DISQUE[2] = '\0';

    *DISQUE = getdisk()+65;
    getcwd(REPERTOIRE, 81);

    deltemp();

    SF = fopen(BATFIC, "wb");
    if(SF == 0L)
        return(0);

    fmet("@echo off");

    fmet(DISQUE);
    fputs("CD ",SF);
    fmet(REPERTOIRE);
    fmet(prog);

    fmet(ORIGDRIVE);
    fputs("CD ",SF);
    fmet(ORIGDIR);

    fputs("list.bat ", SF);
    fputs(" ", SF);
    fputs(REPERTOIRE, SF);
    fmet("\\");

    fclose(SF);
    BIOSscreen(3);
    restaure();
    cddlist();
    exit(0);
}

int make_zip_bat()
{
    char REPERTOIRE[81];
    char DISQUE[3];
    char nom[9];
    char ext[5];

    DISQUE[0] = 'C';
    DISQUE[1] = ':';
    DISQUE[2] = '\0';

    fnsplit(FILEPATH, DISQUE, REPERTOIRE, nom, ext);
    remslash(REPERTOIRE);

    SF = fopen(BATFIC, "wb");
    if(SF == 0L)
        return(0);

    fmet("@echo off");

    fmet(DISQUE);
    fputs("CD ",SF);
    fmet(REPERTOIRE);
    fmet(ZIPTEMP);

    fmet(ORIGDRIVE);
    fputs("CD ",SF);
    fmet(ORIGDIR);

    fputs("list.bat ", SF);

    fclose(SF);
    BIOSscreen(3);
    restaure();
    cddlist();
    exit(0);
}



int make_directory(char *var)
{
    int i;

    *var = 0;
    if(boxinput("Make directory:",var, 67) != 13)
        return(0);
    i = (mkdir(var) != -1);
    if(!i)
        box("Not created");
    return(i);
}


void clear_DTAG()
{
    memset((char *) DTAG, 0, DIRSIZE);
}
void set_DTAG()
{
    memset((char *) DTAG, TAGCOL, DIRSIZE);
}

int compare()
{
    int i;
    int j;
    int num;
    int stt;


    if(DST_MOREFLAG == '+')
    {
        box("Not allowed, shortened directory");
        return(0);
    }

    set_DTAG();
    stt = FILEMAX - DIRMAX;
    num = stt;

    for(i = DIRMAX; i < FILEMAX; i++)
    {
        j = DST_DIRMAX;

nextcmp:
        kbhit();
        if(!stricmp((char *) REPBUF[i], (char *) DST_BUF[j]))
        {
            DTAG[i] = 0;
            num--;
        }
        else
            if(++j < DST_FILEMAX)
                goto nextcmp;
    }

    if(num)
    {
        box("%d files no found, they are tagged", num);
    }
    else
    {
        box("All files found");
    }

    return(num);
}


void rename_entry
(int NUM, char BUF[][13])
{
    char var[81];
    char name[81];

    copycat(name, "Rename/Move ", BUF[NUM]);
    strcat(name," to:");
    *var = 0;
    if(boxinput(name, var, 60) != 13)
        return;
    rename(BUF[NUM], var);
}

int lockfile(int ch)
{
    int i;

    i = (ch == 'v');
    if(testag())
        i = lockunlocktag(i);
    else
        i = lockunlock(i, REPBUF[NUM]);
    return(i);
}


int ask_to_delete(char *adr)
{
    BOXYES = 1;
    return(answer( box("Delete %s", adr)) == 13);
}

void message_locked(char *fname)
{
    BOXBACK = 4;
    box("%s is locked", fname);
}

int delete_entry
()
{
    int i;
    char *adr;
    int ok;

    i = disk_verify(getdisk(), VERIFY_WRITE);
    if(i != OK)
    {
        box("Not deleted...");
        return(0);
    }

    if(filetype[NUM] == TYPE_DIR)
    {
        deltree(REPBUF[NUM]);
        return(1);
    }


    if(MESS_DEL)
    {
        if(testag())
            adr = TAG_STRING;
        else
            adr = (char *) REPBUF[NUM];   /* &REPBUF[NUM];*/
        if(!ask_to_delete(adr))
            goto nulcancel;
    }

    if(testag())
    {
        ok = 1;
        for(i = DIRMAX; i < FILEMAX; i++)
        {
            if(DTAG[i])
            {
                if(unlink(REPBUF[i]) == -1)
                    ok = 0;
            }
        }

        if(ok == 0)
        {
            BOXBACK = 4;
            box("Some files are locked");
            return(27);
        }

        return(1);
    }

    if(!unlink(REPBUF[NUM]))
        return(1);
    message_locked(REPBUF[NUM]);

nulcancel:
    return(0);
}


int diskcopy()
{
    int lx,ly;
    int option;
    int x,x2,y;
    char var[160];

    mhide();
    wincolor(WINDOWBACK, WINDOWHEAD, WINDOWPEN);
    wincreate(18, 10, 61, 18, "Diskcopy");

    lx = WL + 4;
    ly = WU + 6;
    x = (WL + 7) << 3;
    y = ((WU + 3) << 4) - 2;
    x2 = x + 88 + 24;

    longkey(lx, ly, 7);
    longkey(lx + 14, ly, 8);
    go_key(33, 6);
    stop_key(33, 3);

redisp:
    mhide();

    WCOL = 1;
    PENCOL = 0;

    bar18(x, y, x + 31, y + 31, 9);
    rectangle18(x - 1, y - 1, x + 32, y + 32, 0);
    PENCOL = 1;
    bigc(WL + 8, WU + 3, SOURCE + 65);
    PENCOL = 8;
    bigc(WL + 14, WU + 3, 26);

    bar18(x2, y, x2 + 31, y + 31, 12);
    rectangle18(x2 - 1, y - 1,x2 + 32,y + 32, 0);
    PENCOL = 4;
    bigc(WL + 22, WU + 3, TARGET + 65);

    if(MOUSE)
    {
sloop:
        mshow();
        while(!kbhit())
        {
            if(mclick())
            {
                release();
                if(wininside())
                {
                    if(sysinside() )
                    {
                        option = -17;
                        goto cdrskp;
                    }
                    if(testlong(7))
                    {
                        option = 's';
                        goto cdrskp;
                    }
                    if(testlong(8))
                    {
                        option = 't';
                        goto cdrskp;
                    }
                    if(test_stop())
                        goto no;
                    if(test_go())
                        goto yes;
                    goto sloop;
                }
                goto no;
            }
        }
    }

    option = get1000();

cdrskp:
    switch(option)
    {
    case 's':
        SOURCE = 1 - SOURCE;
        break;
    case 'c':
    case 't':
        TARGET = 1 - TARGET;
        break;
    case F1:
    case -17:
        option = winmenumini();
        goto cdrskp;
    case 'q':
    case ALT_F4:
    case 27 :
        goto no;
    case 'o':
    case ENTER:
        goto yes;
    default:
        break;
    }

    goto redisp;

no:
    mhide();
    return(0);
yes:
    mhide();
    strcpy(var, "diskcopy ?: ?: ");
    var[9]  = SOURCE + 65;
    var[12] = TARGET + 65;
    strcat(var, DISK_OPTIONS);
    controlc();
    fatal();
    doswindow("DISK COPY", var);
    nocontrolc();
    nofatal();
    return(1);
}



void addmask()
{
    int i;
    int j;

    for(i = 0; i < MASKIDX; i++)
        if(!stricmp((char *) masktext[i], MASK))
            return;

    if(MASKIDX == MASKMAX)
    {
        i = 0;
        j = 1;
        while(j < MASKMAX)
        {
            strcpy( (char *) masktext[i], (char *) masktext[j]);
            i++;
            j++;
        }
        MASKIDX--;
    }

    strcpy((char *) masktext[MASKIDX], (char *) MASK);
    MASKIDX++;
}



int winmask()
{
    int col;
    int colr;
    int c;
    int wbox;
    char oldmask[13];

    LIFTRMARGIN = 0;
    strcpy(oldmask, MASK);

    wbox = 35;
    col  = max(0, 39 - (wbox >> 1));
    colr = col + wbox - 1;

restart:
    mhide();
    PENCOL = 0;
    DIALOG_KEYS = 0;
    SCROLLBACK = 15;
    SCROLLPEN = 0;
    winboard(col, 12, colr, 17, 7);

    wintextcol(15, 0);
    get_frame(2, 4, 15, 6, "Type a file mask:");

    stop_key(22, 3);
    go_key(28, 3);

dgloop:
    LIFTFLAG = 1;
    mhide();
    winlocate(2, 4);
    wintextcol(15, 0);
    BOX_TITLE = 0;
    c = getsg(MASK, 12);
    release();

parse:
    switch(c)
    {
    case 1080:
    case -2:
    case -11:
        winsave(0);
        winset(WL + 1, WU + 5, WL + 17, WU + 11);
        winbackhold();
        SCROLL_TXT_WIDTH = MASKSIZE;
        c = scrollmenu((char *) masktext, MASKMAX, 6);
        winbackput();
        winopen(0);
        if(c >= 0)
            strcpy((char *) MASK, (char *) masktext[c]);
        goto restart;
    case -3:
        c = 1;
        if(test_stop())
        {
            c = 27;
            goto parse;
        }
        if(test_go())
        {
            c = 13;
            goto parse;
        }
        if(wininside())
            goto dgloop;
        break;
    case 13:
        if(!strlen(MASK))
            strcpy(MASK, "*.*");
        addmask();
        break;
    case 27:
        strcpy(MASK, oldmask);
        break;   /* reaffiche toujours */
    default:
        beep();
        break;
    }

    return(c);
}




int testext()
{
    char *ext;
    char *name = REPBUF[NUM];

    ext = name + strcspn(name,".");

    if(!stricmp(ext,".EXE"))
        return(1);
    if(!stricmp(ext,".COM"))
        return(2);
    if(!stricmp(ext,".BAT"))
        return(3);
    if(!stricmp(ext,".ZIP"))
        return(4);
    if(!stricmp(ext,".LZH"))
        return(5);
    return(0);
}


void locate_in_dir()
{
    struct ffblk repbloc;

    SNUM = 0;
    if(!findfirst("*.*",&repbloc,243))
    {
loop:
        if(strcmp(repbloc.ff_name,"."))
            if(repbloc.ff_attrib & 227)
            {
                if(!stricmp(repbloc.ff_name, NOMCHE))
                    goto exit;
                SNUM++;
            }
        if(!findnext(&repbloc))
            goto loop;
    }
exit:
    return;
}


char NOMCHE[13];
char SMODE;
char found[81];
int  sortie;


int searchdir()
{
    struct ffblk repbloc;
    int k;
    int rtn;
    int ch;

    if(sortie)
        return(sortie);

    k = strlen(treepath);
    treepath[k] = '\\';
    strcpy(treepath + k + 1, NOMCHE);

    rtn = findfirst(treepath, &repbloc, 227);

    while(!rtn)
    {
        strcpy(found, treepath);
        strcpy(found + k + 1, repbloc.ff_name);

        strcat(found," This text? y/n");

        if(SMODE)
        {
            BOXPLUS = 1;
            BOXBACK = 2;
            ch = answer(box(found));
        }
        else
        {
            puts(found);
            ch = answer(get1000());
        }

        if(ch == ENTER)
        {
            sortie = 1;
            treepath[k] = 0;
            cdd(treepath);

            strcpy(NOMCHE, repbloc.ff_name);
            strcpy(FILEPATH, treepath);
            pushname(FILEPATH, NOMCHE);
            goto exit;
        }

        if(ch == ESCAPE || ch == 'c')
        {
            sortie = 1;
            goto exit;
        }

        rtn = findnext(&repbloc);
    }

    if(kbhit())
        if(get1000() == ESCAPE)
        {
            sortie = ESCAPE;
            goto exit;
        }

    strcpy(treepath + k + 1, "*.*");

    rtn = findfirst(treepath, &repbloc, FA_DIREC);
    while((!rtn) && (!sortie) )
    {
        if((repbloc.ff_attrib & FA_DIREC) && (repbloc.ff_name[0] != '.'))
        {
            strcpy(treepath + k + 1, repbloc.ff_name);
            searchdir();
        }
        rtn = findnext(&repbloc);
    }

    treepath[k] = 0;

exit:
    return(sortie);
}


int search_file(int mode)
{
    char DRV[3];

    DRV[0] = (char) getdisk() + 'a';
    DRV[1] = ':';
    DRV[2] = '\0';

    SMODE = mode;
    sortie = 0;

    strcpy(treepath, DRV);
    return(searchdir());
}


int locatefile(int flag)
{
    char SAVPATH[81];
    int i;

    i = boxinput("Filename to search:", NOMCHE, 12);
    if(i == 13)
    {
        getcwd(SAVPATH,80);
        if(flag == FROM_TEXT)
            i = existe(NOMCHE);
        else
            i = 0;
        if(i == 0)
        {
            cdd("\\");
            i = search_file(1);
        }

        if(i == ESCAPE)
            goto bye;
        if(i)
        {
            if(flag == FROM_TEXT)
            {
                strcpy(FILEPATH, NOMCHE);
                get_new_view();
                goto ok;
            }
            else     /* from dir */
            {
                locate_in_dir();
                goto ok;
            }
        }
        else
        {
            BOXBACK = 4;
            box("Sorry, definitively not on this disk...");
        }
    }

bye:
    cdd(SAVPATH);
ok:
    return(i);
}


void locate_in_order()
{
    int i;
    char DISPFIC[13];

    pullname(FILEPATH, DISPFIC);

    for(i = DIRMAX; i < FILEMAX; i++)
    {
        if(!stricmp(DISPFIC, REPBUF[i]))
        {
            SNUM = i - DIRMAX;
            return;
        }
    }
    return;
}

int extract(char *archive, char *fichier)
{
    int i;
    char var[81];
    char txt[40];
    char STRBUF[256];

    getcurpath();
    if(DOUBLE)
        goto direct;

    strcpy(var, DESTINATION);
    strcpy(txt,"Unarchive ");
    strcatupr(txt, archive);
    strcat(txt," into:");

    i = boxinput(txt, var, 60);
    if(i == 13)
    {
        strcpy(DESTINATION, var);
        if(cdd(var) == -1)
        {
            if(createdir())
                cdd(var);
            else
                return(0);
        }

        setcurpath();

direct:
        strcpy(ORIGINE, CURPATH);
        pathcat(ORIGINE, archive);
        sprintf(STRBUF, "%s %s %s %s", UNARCHIVER, ORIGINE, fichier, DESTINATION);

        /*  box(STRBUF);*/

        if(DOSWINFLAG)
        {
            controlc();
            fatal();
            doswindow("UNARCHIVE", STRBUF);
            nofatal();
            nocontrolc();
        }
        else
        {
            strcat(STRBUF, " > NUL");
            system(STRBUF);
        }
    }

bye:
    return(i);
}

#define extractxt "Unarchive [TAGGED LIST] to "


int extractagrtn(long size)
{
    int i;
    int j;
    char STRBUF[256];

    i = 0;
    j = getdisk();
    if(!available(size))
        goto bye;

    open_dos("UNARCHIVE");

    if(isdir() != 13)
        goto fini;

    for(i = 0; i < FILEMAX; i++)
    {
        if(DTAG[i])
        {
            sprintf(STRBUF, "%s %s %s %s", UNARCHIVER, ZIPNAME, REPBUF[i],DESTINATION);
            cputs(STRBUF);
            strcat(STRBUF, " > NUL");
            system(STRBUF);
            puts("");
        }
    }

fini:
    freedisk(j);
    close_dos();

bye:
    return(i);
}

int extract_tag(long size)
{
    int i;
    char var[81];

    if(DOUBLE)
        goto direct;

    strcpy(var, DESTINATION);
    i = boxinput(extractxt, var, 60);
    if(i != 13)
        goto bye;

    strcpy(DESTINATION, var);

direct:
    updestination();
    i = extractagrtn(size);

bye:
    NO_INPUT = 0;
    return(i);
}


#define TREEL 1
#define TREEL2 8
#define TREER 111

#define TOP 6
#define DIRH 23



void helprint(char *usage)
{
    write18(41, HELPY++, usage);
}

void disp_help()
{
    textcol(DISPBACK, DISPTEXT);
    set8x14();
    HELPY = 8;
    fastbar(RIGHT_SIDE, DIRTOP + 1, 79, 457, DISPBACK);

    write18(41, 7, "Directory commands:");
    helprint("PAGE keys  Previous/next page");
    helprint("Arrows     Previous/next file");
    helprint("Left       Go to parent directory");
    helprint("Right      Enter target directory");
    helprint("ENTER      Change to a directory");
    helprint("           Read a text file");
    helprint("           Content of archive");
    helprint("           Read text in archive");
    helprint("A..W       Change drive");
    helprint("Tag        x  X  Ctl-x");
    helprint("q          Quit in this path");
    helprint("Alt x      Quit in starting directory");
    helprint("TAB        Change window");
    helprint(">          Exchange windows");
    HELPY++;
    helprint("Commands in target:");
    helprint("Navigate, tag, delete...");
    HELPY++;
    helprint("Icons:");
    helprint("Press the right mouse button for help.");



    setfont16();
    CLEARED_RIGHT = 1;
    mousegetch();
}




int compext(char *name)
{
    int i = 0;
    int j;
    char k;
    char c;
    char ext[4];

    j = 0;

next:
    c = *(name + j);
    if(c == 0)
        goto sortie;

    if(c != '.')
    {
        j++;
        goto next;
    }

    j++;
    name += j;

    k = 0;
    for(j = 0; j < 3; j++)
    {
        c = name[k];
        if(c)
        {
            ext[j] = c;
            k++;
        }
        else
            ext[j] = ' ';
    }

    while(i < EXTMAX)
    {
        if(!strncmp(typetext[i], ext, 3))
        {
            if( typetext[i][3]== '=')
                goto sortie;
        }
        i++;
    }
    i = 0;
sortie:
    return(i);
}


void clrline(int line)
{
    int r;

    line = (line - 1) << 4;
    if(DOUBLE)
        r = 35;
    else
    {
        if(BBS)
            r = 79;
        else
            r = 75;
    }
    fastbar(0, line, r, line + 15, DISPBACK);
}

char mousenum[] = { 0, MOUSE_TAG };

char OLDIMAGE;

void indirmouse()
{
    int image;

    if(my < BMOUSE)
        if(my > TMOUSE)
            if(mx < 631)
                if(mx > LMOUSE)
                {
                    image = (mx - LMOUSE) >> 5;
                    if(mx < (LMOUSE + (image << 5) + 16))
                    {
                        OLDIMAGE = mousenum[image];
                    }
                }
}



void clear_left()
{
    fastbar(0, DIRTOP + 1, 39, 457, DISPBACK);
}

void clear_right()
{
    int rcolor;

    if(DOUBLE)
        rcolor = DIRBACK;
    else
        rcolor = DISPBACK;
    fastbar(40, DIRTOP + 1, 79, 457, rcolor);
    if(!DOUBLE)
        dir_lift();
}


void clear_dir()
{
    clear_left();
    if(!DOUBLE)
        clear_right();
    else
        dir_lift();
}



void presentation()
{
    int i;

    menubar();
    for(i = 0; i < 16; i++)
        bigkey(i);
    gray_bar();
    icon9(2, 463, cdlico);
    dispmouse();

    clear_dir();
}


void put_dir_disk(int x, int y, int i, char *name, char type, char BACK)
{
    int yt;
    int yb;
    int xl;
    int xr;

    yt = (y - 1) << 4;
    yb = yt + 15;
    xl = x << 3;
    xr = xl + 103;

    if(i < DISKMAX)
    {
        fastbar(x, yt, x + 34, yb, BACK);
        putdisk(xl, (y - 1) << 4, i);
        return;
    }

    fastbar(x, yt, x + 12, yb, 7);
    fastbar(x + 13, yt, x + 34, yb, BACK);
    COLOR16 = 15;
    hline18(xl, yt, xr);
    vline18(xl, yt, yb);
    COLOR16 = 8;
    hline18(xl, yb, xr);
    vline18(xr, yt, yb);

    if(type == TYPE_ROOT)
        icon9(xl + 32, 479 - yb, retico);
    else
        writedir(xl, yt, name);

    return;
}


void DIR_print(int y, int num)
{
    char STRBUF[80];
    int year;

    if(num < FILEMAX)
    {
        if(filetype[num])
        {
            put_dir_disk(1, y, num, REPBUF[num], filetype[num], DISPBACK);
            goto rightscreen;
        }
        year = Y[num] + 80;
        if(year > 99)
            year -= 100;

        sprintf((char *) STRBUF, "%-12s%10lu%c %2d %3s %02d",
                REPBUF[num],
                REPSIZE[num],
                lockit[num],
                (int) D[num], month[M[num]], year
               );

        if(DTAG[num])
        {
            BACKCOL = TAGCOL;
            PENCOL = 0;
        }
        else
        {
            BACKCOL = DISPBACK;
            PENCOL = DISPTEXT;
        }
        write18(2, y, STRBUF);
        goto rightscreen;
    }

    /* Fin d'cran */

    clrline(y);

rightscreen:
    if(!DOUBLE)
        if(num < FILEMAX)
        {
            BACKCOL = DISPBACK;
            PENCOL = DISPTEXT;
            if(BBS && !ZIPFLAG)
                writef18(36, y,"%-45s", (char *) DESCadr[num]);
            else
                writef18(36, y, " %-40s", typetext[compext(REPBUF[num]) ] + 4);
        }
}


#define DIR_INV  1
#define DIR_NORM 0

void dirinv(int i, char mode)
{
    int y;
    int blocsize;
    int year;

    if(!FILEMAX)
        return;

    y = i - START + TOP;
    if(DTAG[i])
        if(mode == DIR_INV)
        {
            BACKCOL = 14;
            PENCOL = 0;
        }
        else
        {
            BACKCOL = TAGCOL;
            PENCOL = 0;
        }
    else
        if(mode == DIR_INV)
        {
            BACKCOL = DISPTEXT;
            PENCOL = DISPBACK;
        }
        else
        {
            BACKCOL = DISPBACK;
            PENCOL = DISPTEXT;
        }

    mhide();
    if(filetype[i] == TYPE_FILE)
    {
        year = (int) Y[i] + 80;
        if(year > 99)
            year -= 100;
        writef18(2, y, "%-12s %9lu%c %2d %3s %02d",REPBUF[i],REPSIZE[i],lockit[i],(int) D[i],month[M[i]], year );
    }
    else
    {
        if(i < DISKMAX)
            blocsize = 22;
        else
            blocsize = 13;
        xbloc(TREEL, 480 - (y << 4), blocsize, 16);
    }
}

void dir_window()
{
    int r;

    if(DOUBLE)
        r = 39;
    else
        r = 79;

    winset(0, 5, r, 27);
}

void dir_lift()
{
    if(!BBS || DOUBLE)
    {
        dir_window();
        LIFTTMARGIN = 2;
        LIFTRMARGIN = 8;
        LIFTBMARGIN = 4;
        B_LIFT = DISPBACK;
        putlift(1);
    }
    return;
}

void bottom_bar()
{
    mhide();
    textcol(7, 0);
    fastbar(0, 459, 79, 479, 7);
    COLOR16 = 8;
    hline18(2, 460, 637);
    vline18(2, 460, 478);
    COLOR16 = 15;
    vline18(637, 460, 478);
    hline18(2, 478, 637);
    COLOR16 = 0;
    hline18(0, 458, 639);
}

int retour;
int level;
int LEVNUM[64];
int LEVSTART[64];


int directory()
{
    char search[81];
    char var[81];
    int ml, mc;
    int bouton;
    int ch;
    char c;
    int  maxr;
    unsigned int a, i, b;
    int y;
    int numold;
    int FMAX;
    struct ffblk repbloc;
    struct ftime *ft;
    int fnew;
    char diskvar[3] = "c:";
    char TAGFLAG;
    int savmax, savnum, savstart, ret;
    long SOMME;

    char DIR_MOREFLAG[2];
    char huge *adr;
    int menux;

reset:
    clearkey();
    mhide();
    release();
    newcursor(0);
    fnew = 0;
    OLDIMAGE = 0;
    CLEARED_RIGHT = 1;

    PENCOL = DISPTEXT;
    KEYHAUT = 22+19;
    KEYBAS =  52+19;
    KEYBOT = 427-19;
    TOPBAR = 19;

    DISPBACK = DIRBACK;
    presentation();
    clear_right();
    bottom_bar();

    BIOSborder(DIR_BORDER);

    if(retour)
        goto dirloop;
    retour = 1;

diskloop:
    savmax = 0;
    savnum = 0;
    savstart = 0;
    memset((char *) LEVNUM, 0, 64);
    memset((char *) LEVSTART, 0, 64);

dirloop:             /* nouveau rpertoire */
    textcol(0, 7);
    freedisk(getdisk());
    NUM = LEVNUM[level];
    START = LEVSTART[level];

    redo
:
    clear_DTAG();
    gotoxy(1,7);
    FILEMAX = 0;
    DISKMAX = 0;
    ZIPFLAG = 0;
    TAGFLAG = 0;
    OLDIMAGE = 0;
    newcursor(0);
    DISPBACK = DIRBACK;
    DISPTEXT = DIRPEN;
    DIR_MOREFLAG[0] = 0;
    DIR_MOREFLAG[1] = '\0';

    for(i = 0; i < MAXDISKS; i++)
        if(makedisk(i))
        {
            *diskvar = i + 'a';
            filetype[FILEMAX] = TYPE_DISK;
            strcpy(REPBUF[FILEMAX++], diskvar);
        }

    getcwd(search, 67);
    i = strlen(search);
    level = 0;
    if(i > 3)
        while(i--)
        {
            if(search[i] =='\\')
                level++;
        }

    mhide();
    search[63] = 0;
    if(strcmp(MASK, "*.*" ))
        pathcat(search, MASK);

    if(findfirst("*.*", &repbloc, 255))
        goto dexit0;

rloop0:
    if(repbloc.ff_attrib & FA_DIREC)
    {
        if(repbloc.ff_name[0] == '.')
        {
            if(repbloc.ff_name[1] != '.')
                goto skip0;
            filetype[FILEMAX] = TYPE_ROOT;
        }
        else
            filetype[FILEMAX] = TYPE_DIR;
        strcpy(REPBUF[FILEMAX++], strlwr(repbloc.ff_name));
    }
skip0:
    if(findnext(&repbloc) == 0)
    {
        if(FILEMAX < DIRSIZE)
            goto rloop0;
        DIR_MOREFLAG[0] = '+';
    }

dexit0:
    DIRMAX = FILEMAX;
    TOTAL = 0;

    if(findfirst(MASK, &repbloc, 255))
        goto dexit;
rloop:
    if(repbloc.ff_attrib & 28)
        goto skip;  /* system 8 label  4 dir 0x10 */
    REPSIZE[FILEMAX] = repbloc.ff_fsize;
    TOTAL += REPSIZE[FILEMAX];
    ft = (struct ftime *) &repbloc.ff_ftime;
    D[FILEMAX] = (unsigned char) ft->ft_day;
    M[FILEMAX] = (unsigned char) (ft->ft_month)-1;
    Y[FILEMAX] = (unsigned char) ft->ft_year;
    filetype[FILEMAX] = TYPE_FILE;
    lockit[FILEMAX] = ' ' + 10 * (repbloc.ff_attrib & 1);
    strcpy(REPBUF[FILEMAX++], strlwr(repbloc.ff_name));

skip:
    if(findnext(&repbloc) == 0)
    {
        if(FILEMAX < DIRSIZE)
            goto rloop;
        DIR_MOREFLAG[0] = '+';
    }

dexit:
    for(i = 0; i < DIRSIZE; i++)
    {
        adr = hugepint(DESCbuf, (unsigned) i * 46);
        *adr = 0;
        DESCadr[i] = adr;
    }

    if(BBS)
        if(getdesc())
            getBBS(DIRMAX);


    /*----------------------------------------
       Affiche le rpertoire sans le recharger
      ----------------------------------------*/

redispdir:
    bottom_bar();
    if((FILEMAX - DIRMAX) > 1)
        c = 's';
    else
        c = ' ';


    /* display files */

redisp:
    SOMME = 0;
    for(i = DIRMAX; i < FILEMAX; i++)
        if(DTAG[i])
            SOMME += REPSIZE[i];

    if(CLEARED_RIGHT)
    {
        clear_right();
        if(DOUBLE)
        {
            DST_directory(0);
            dir_lift();
        }
        CLEARED_RIGHT = 0;
    }

    if(SORT)
    {
        SORT_DESC_FLAG = 0;
        dirsort(REPBUF[DISKMAX], DIRMAX - DISKMAX, DISKMAX);
        SORT_DESC_FLAG = BBS;
        dirsort(REPBUF[DIRMAX], FILEMAX - DIRMAX, DIRMAX);
    }

RedispScroll:
    if(LOCATEFLAG)
    {
        if(SORT)
            locate_in_order();
        START = SNUM + DIRMAX;
        NUM = START;
        LOCATEFLAG = 0;
    }

    START = min(START, FILEMAX - DIRH);
    START = max(0, START);

    /*  refresh */
    i = START;
    textcol(0, DISPTEXT);
    maxr = FILEMAX - 1;

    mhide();

    /* loop colonne */

    y = TOP;
    b = y + DIRH;
    PENCOL = DISPTEXT;

ploop:
    DIR_print(y, i);
    i++;
    y++;
    if(y < b)
        goto ploop;

    BACKCOL = DISPBACK;

    if(FILEMAX == 0)
    {
        write18(2, TOP,"  <No file>");
    }

    FMAX = min(maxr, START + DIRH - 1);

    /* Si le mme  droite, rafraichir aussi */

    if(DOUBLE)
        if(!ZIPFLAG)
            if(!stricmp(search, DESTINATION))
            {
                DST_directory(0);
            }

    /* Gestion de fichier sans changement de rpertoire */


freeloop:     /* restore free space */

fileloop:
    mhide();
    NUM = min(NUM, maxr);
    dir_window();
    freedisk(getdisk());
    textcol(7, 0);
    writefxy(16, 462, "%4d%s file%c    %10lu used   %10lu free bytes", FILEMAX-DIRMAX, DIR_MOREFLAG, c, TOTAL, DISKFREE);
    if(ZIPFLAG)
        writebar(0, 4,"%-13s %-49s", ZIPNAME, PATH_IN_ZIP);
    else
        writebar(0, 4,"%-63s", search);

    writefxy(496, 462, "%10lu tagged", SOMME);

    if(OP_DOS)
    {
        ch = 'o';
        goto parse;
    }
    if(OP_ZIP)
    {
        ch = ZIPAGAIN;
        goto parse;
    }

    if(!BBS || DOUBLE)
        numberlift(NUM, FILEMAX);
    dirinv(NUM, DIR_INV);
    numold = NUM;

    if(MOUSE)
    {
mouseloop:
        mshow();
        ch ='\0';

odirloop:
        if(kbhit())
            goto rech;
        bouton = mclick();
        if(my > DIRTOP)
        {
            if(mx < 5)
            {
                fnew = MOUSE_LEFT;
                goto tochg;
            }
            if(OLDIMAGE != MOUSE_TAG)
                OLDIMAGE = 0;
        }
        else
        {
            indirmouse();
            TAGFLAG = (OLDIMAGE == MOUSE_TAG);
        }

        fnew = OLDIMAGE;

tochg:
        newcursor(fnew);

        if(bouton)
        {
            mrelease(1);

            mc =  mx >> 3;
            ml = (my >> 4) - TOP + 1;

            if( fnew == MOUSE_UP)
            {
                ch = 1072;
                goto orsk;
            }
            if( fnew == MOUSE_DOWN)
            {
                ch = 1080;
                goto orsk;
            }
            if( fnew == MOUSE_LEFT)
            {
                ch = 1075;
                goto orsk;
            }
            if( fnew == MOUSE_TAG)
                if( bouton == 2 )
                {
                    ch = '*';
                    goto orskr;
                }

            if(my < 18)
            {
                if(mx < 18)
                {
                    ch = -17;
                    goto orskr;
                }
                menux = testroot();
                if(menux >= 0)
                {
                    ch = rootkeys[menux];
                    goto orskr;
                }
            }

            if(my > KEYHAUT)
                if(my < KEYBAS)
                {
                    a = mx / 40;
                    pressbig(a);
                    if(bouton == 2)
                    {
                        bouton = 4;
                    }
                    ch = dirkey[a];
                    goto orsk;
                }

            if(test_bar())
            {
                ch = ALT_P;
                goto orsk;
            }

            if(my < 20)
            {
                if(mx < 20)
                {
                    ch = 'a';
                    goto orskr;
                }
                if(test_title(0))
                {
                    if(bouton == 1)
                    {
                        ch = ALT_X;
                        goto orskr;
                    }
                    bouton = 4;
                    a = 31;
                    goto orskr;
                }
            }


            if(DOUBLE)
                if(test_line(DST_LEFT, DST_TOP - 2, 79, 27))
                {
                    ch = KEY_RIGHT;
                    goto orsk;
                }

            mrelease(2);

            if(!BBS || DOUBLE)
            {
                ch = wmouselift(&NUM, FILEMAX);
                if(ch > 256)
                    goto orskr;
                if(ch != -1)
                {
                    if(NUM < START)
                    {
                        START = NUM;
                        goto RedispScroll;
                    }
                    if(NUM > FMAX)
                    {
                        START = min(FILEMAX - (FMAX - START), START + (NUM - FMAX));
                        goto RedispScroll;
                    }
                    if(NUM == numold)
                        goto mouseloop;
                    dirinv(numold, DIR_NORM);
                }
            }

            if(mc < 39)
            {
                b = ml + START;
                if(b <= FMAX)
                {
                    NUM = b;

                    if((NUM == numold) && (fnew != MOUSE_TAG))
                    {
                        ch = ENTER;
                        goto orsk;
                    }
                    dirinv(numold, DIR_NORM);

                    if(fnew == MOUSE_TAG)
                    {
                        i = DTAG[NUM];
                        i = TAGCOL - i;
                        DTAG[NUM] = i;
                        if(i)
                            SOMME -= REPSIZE[NUM];
                        else
                            SOMME += REPSIZE[NUM];
                    }
                    goto fileloop;
                }
            }

        } /* fin if bouton */
        goto odirloop;
    }   /* fin MOUSE */

rech:
    ch = get1000();

orskr:
orsk:
    if(bouton == 4)
    {
        phylactere(maintext[a]);
        goto mouseloop;
    }

    mrelease(2);
    dirinv(numold, DIR_NORM);

parse:
    if(ZIPFLAG)
        switch(ch)
        {
        case ALT_V:
        case CTRL_X:
        case 'X':
        case ' ':
        case 'x':
            break;
        case 'u':
            DOSWINFLAG = 1 - DOUBLE;
            if(testag())
                i = extract_tag(SOMME);
            else
            {
                if(filetype[NUM])
                    goto fileloop;
                i = extract(ZIPNAME, REPBUF[NUM]);
                DST_directory(0);
            }
            if(i == 27)
                goto fileloop;

            if(DOSWINFLAG)
            {
                screen18();
                presentation();
            }
            goto exit_zip;

        case KEY_DOWN:
        case KEY_UP:
        case PAGE_UP:
        case HOME:
        case CTRL_HOME:
        case PAGE_DOWN:
        case END:
        case CTRL_END:
            break;

        case 'l':
        case 'p':
        case DELETE:
        case ALT_P:
        case 'e':  /*    MessFutur();*/
            goto fileloop;
        case 'f':
            break;

        case 'm':
            goto fileloop;
        case '*':
            goto fileloop;
        case 't':
        case '<':
            goto fileloop;
        case F1:
            break;
        case -17:
        case 'a':
            break;
        case 'b':
            break;
        case ALT_A:
        case ALT_F:
        case ALT_K:
        case ALT_Z:
        case ALT_S:
        case ALT_I:
            break;

        case ENTER:
            if(!FILEMAX)
                goto fileloop;
            if(TAGFLAG)
            {
                ch = ' ';
                goto parse;
            }
            if(filetype[NUM] == TYPE_DIR)
            {
                if(ZIPlevel < (ZIP_MAX_LEVEL-1))
                {
                    ZIP_LEVEL_NUM[ZIPlevel] = NUM;
                    ZIP_LEVEL_START[ZIPlevel] = START;
                    push_dir();
                    ZIPlevel++;
                    DIRMAX = 0;
                    DISKMAX = 0;
                    FILEMAX = zipit(filetype);
                    NUM = 0;
                    START = 0;
                    goto redispdir;
                }
                goto fileloop;
            }

            i = testext();
            if(i == 4)
            {
                /* MessFutur();*/
                goto fileloop;
            }

            /* On n'affiche pas les types reconnus sauf BAT */

            if(i)
                if(i != 3)
                    goto fileloop;
            if(!make_temp())
                goto redisp;
            FILEMAX  = savmax;
            NUM      = savnum;
            START    = savstart;
            return(13);

        case 'r':
            i = testext();

            /* On ne lance que les EXE et COM */

            if((i < 1) || (i > 3))
                goto fileloop;
            if(!make_temp())
                goto redisp;
            make_zip_bat();

            FILEMAX  = savmax;
            NUM      = savnum;
            START    = savstart;
            return(13);

        case KEY_LEFT:
            if(ZIPlevel)
            {
                pull_dir();
                FILEMAX = zipit(filetype);
                ZIPlevel--;
                NUM = ZIP_LEVEL_NUM[ZIPlevel];
                START = ZIP_LEVEL_START[ZIPlevel];
                goto redispdir;
            }
        case 'd':
        case ESCAPE:
        case 'q':
        case ALT_X:
        case ALT_F4:
exit_zip:
            FILEMAX = savmax;
            NUM   = savnum;
            START = savstart;
            DISPBACK = DIRBACK;
            DISPTEXT = DIRPEN;
            clear_dir();
            BIOSborder(DIR_BORDER);
            goto redo
            ;

        default:
            beep();
            goto fileloop;
        }

    switch(ch)
    {
    case ALT_V:
        for(i = DIRMAX; i < FILEMAX; i++)
            DTAG[i] = TAGCOL - DTAG[i];
        goto redisp;
    case CTRL_X:
        i = 0;
        goto direct_tag;
    case 'X':
        i = TAGCOL;
direct_tag:
        memset((char *) DTAG + DIRMAX, (char) i, FILEMAX - DIRMAX);
        goto redisp;
    case ' ':
    case 'x':
        if(NUM < DIRMAX)
            break;
        DTAG[NUM] = TAGCOL - DTAG[NUM];
        i = (DTAG[NUM] == 0);
        dirinv(numold, DIR_NORM);
        if(i)
            SOMME -= REPSIZE[NUM];
        else
            SOMME += REPSIZE[NUM];

        /* on descend ensuite */

    case KEY_DOWN:
        if(NUM < maxr)
        {
            NUM++;
            if(NUM > FMAX)
            {
                START++;
                goto RedispScroll;
            }
        }
        goto fileloop;

    case KEY_UP:
        if(NUM > 0)
        {
            NUM--;
            if(NUM >= START)
                goto fileloop;
            else if( START > 0 )
            {
                START--;
                goto RedispScroll;
            }
        }
        goto fileloop;


    case PAGE_UP:
        if(NUM > START)
            NUM = START;
        else
            if(NUM > 0)
            {
                START = max( START - DIRH, 0);
                NUM = START;
                goto RedispScroll;
            }
        goto fileloop;
    case HOME:
    case CTRL_HOME:
        if(NUM > DISKMAX)
        {
            NUM = DISKMAX;
            START = 0;
            goto RedispScroll;
        }
        goto fileloop;
    case PAGE_DOWN:
        if(NUM == FMAX)
            if(FMAX < FILEMAX)
            {
                START += DIRH;
                FMAX = min(maxr, START + DIRH - 1);
                NUM = FMAX;
                goto RedispScroll;
            }
        NUM = FMAX;
        break;

    case END:
    case CTRL_END:
        if(FMAX < maxr)
        {
            START = FILEMAX - DIRH;
            NUM = maxr;
            goto RedispScroll;
        }
        NUM = maxr;
        break;
    case KEY_LEFT:
        chdir("..");
        level = max(0, level--);
        goto dirloop;
    case 'f':
        if(!format())
            goto displayloop;
        screen18();
        presentation();
        goto redo
        ;

    case 'r':
        i = testext();
        if(i)
            if(i < 4)
            {
                make_bat(REPBUF[NUM]);
            }
        break;
    case ENTER:
        if(TAGFLAG)
        {
            ch = ' ';
            goto parse;
        }

        LEVNUM[level] = NUM;
        LEVSTART[level] = START;

        if(filetype[NUM] & 1)
        {
            if(REPBUF[NUM][0] == '.')
            {
                ch = KEY_LEFT;
                goto parse;
            }
            else
            {
                if(chdir(REPBUF[NUM]) == -1)
                {
                    MessDisk();
                    goto reset;
                }
                level++;
                NUM = DISKMAX;
                START = 0;
            }
            goto redo
            ;
        }

        if(filetype[NUM] == TYPE_DISK)
        {
            ch = buttondisk(NUM);
            goto parse;
        }

        ret = testext();
        if(ret == 4)
        {
        case VIEW_ZIP:
            clear_DTAG();
            strcpy(ZIPNAME, REPBUF[NUM]);
            savmax = FILEMAX;
            *PATH_IN_ZIP = 0;
            PATH_LEN = 0;
            FILEMAX = zipit(filetype);
            if(FILEMAX < 1)
            {
                FILEMAX = savmax;
                goto redisp;
            }
            ZIPFLAG = 1;
            DISKMAX = 0;
            DIRMAX = 0;
            savnum = NUM;
            savstart = START;
            DISPBACK = ZIPBACK;
            DISPTEXT = ZIPTEXT;
            START  = DISKMAX;
            NUM = START;
            ZIPlevel = 0;
            ZIP_LEVEL_START[0] = 0;
            ZIP_LEVEL_NUM[0] = 0;
            memset((char *) ZIP_LEVEL_NUM, 0, ZIP_MAX_LEVEL);
            memset((char *) ZIP_LEVEL_START, 0, ZIP_MAX_LEVEL);

            clear_dir();
            BIOSborder(ZIP_BORDER);
            goto redispdir;
        }

        strcpy(NOMCHE, REPBUF[NUM]);
        strcpy(FILEPATH, NOMCHE);
        return(13);

    case NORMALSIZE:
        if(testext() != 4)
            break;
        strcpy(ZIPNAME, REPBUF[NUM]);
        i = zip_size();
        if(i < 1)
            break;
        BOXBACK = 2;
        box("%d files, uncompressed size: %-lu", i, TOTAL);
        break;

    case 'l':
        if(locatefile(FROM_DIR) > 0)
        {
            LOCATEFLAG = 1;
            goto redo
            ;
        }
        goto redisp;
    case ALT_C:
    case 'c':
        if(NUM < DIRMAX)
        {
            if(NUM < DISKMAX)
                break;
            if(REPBUF[NUM][0] == '.')
            {
                beep();
                break;
            }
            i = copydir(NUM);
        }
        else
        {

            /*DOSWINFLAG = 1 - DOUBLE; */
            DOSWINFLAG = 1;
            NO_INPUT = DOUBLE;
            if(testag())
                i = copytag(SOMME);
            else
                i = copyrtn(NUM);
        }
        if(i == 27)
            break;
        if(DOSWINFLAG)
        {
            screen18();
            DOSWINFLAG = 0;
            presentation();
            goto redo
            ;
        }
        goto displayloop;
    case 'm':
        winmask();
        goto displayredo
        ;
        /* goto displayloop;*/
    case 'o':
        DOSWINFLAG = 1;
        OP_DOS = 0;
        *DOS_TARGET = '\0';
        i = dosrtn(REPBUF[NUM]);
        if(i == 13)
        {
            screen18();
            goto reset;
        }
        goto displayloop;

    case 'u':
        if(NUM < DIRMAX)
            break;
        DOSWINFLAG = 1 - DOUBLE;
        if(extract(REPBUF[NUM], "") == 27)
            break;
        if(DOSWINFLAG)
        {
            screen18();
            presentation();
            goto redo
            ;
        }
        goto displayredo
        ;

    case 'i':
        if(NUM < DIRMAX)
            break;
        DOSWINFLAG = 0;
        if(make_DIZ())
            dispDIZ(REPBUF[NUM]);
        goto displayredo
        ;

    case 'z':
        if(make_list() != 13)
            break;
    case ZIPAGAIN:
        OP_ZIP = 0;
        DOSWINFLAG = 1;
        i = zipwin();  /* si move, goto redispdir */
        if(i == 13)
        {
            screen18();
            presentation();
            goto redo
            ;
        }
        goto displayloop;

    case '*':
        TAGFLAG = 1 - TAGFLAG;
        if(TAGFLAG)
        {
            newcursor(MOUSE_TAG);
            OLDIMAGE = MOUSE_TAG;
        }
        else
        {
            newcursor(0);
            OLDIMAGE=0;
        }
        break;
    case 't':
    case '<':
        SORT = 1 - SORT & 1;
        setbig(13, SORT);
        if(SORT)
        {
            clear_DTAG();
            goto redisp;
        }
        else
            goto diskloop;
    case 'p':
        if(NUM < DIRMAX)
            break;
        print_file(REPBUF[NUM]);
        goto redo
        ;
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
        setdisk(ch - 'A');
        goto diskloop;
    case -17:
    case F10:
    case 'a':
        about();
        CLEARED_RIGHT = 1;
        goto displayloop;

    case 'b':
        BBS = 1 - BBS & 1;
        setbig(12, BBS);
        if(BBS)
            clear_left();
        if(!DOUBLE)
            clear_right();
        else
            dir_lift();
        goto dexit;

    case F1:
        disp_help();
        goto displayloop;
    case F2:
        switch_DOUBLE();
        goto displayloop;

    case TAB:
    case KEY_RIGHT:
        if(DOUBLE)
        {
            if(DST_directory(1))
                goto redo
                ;
            freedisk(getdisk());
            break;
        }
        beep();
        break;

    case '>':
    case SHIFT_TAB:
        swap_in_dir();
        DST_directory(0);
        goto diskloop;

    case ESCAPE:
        if(*FILEPATH)
            goto exit;
        goto redo
        ;

    case ALT_A:
        menux = 0;
        goto tomenu;
    case ALT_F:
        menux = 1;
        goto tomenu;
    case ALT_K:
        menux = 2;
        goto tomenu;
    case ALT_Z:
        menux = 3;
        goto tomenu;
    case ALT_S:
        menux = 4;
        goto tomenu;
    case ALT_I:
        menux = 5;
        goto tomenu;

    case 'k':
        make_directory(var);
        goto redo
        ;
    case CTRL_K:
        if(make_directory(var))
        {
            cdd(var);
            goto redo
            ;
        }
        break;
    case ALT_P:
        if(input_bar(search))
        {
            cdd(search);
            goto diskloop;
        }
        break;
    case 'v':
    case CTRL_V:
        if(lockfile(ch))
            goto redo
            ;
        break;
    case 'n':
        if(NUM < DISKMAX)
            break;
        rename_entry
        (NUM, &REPBUF[0]);
        goto redo
        ;
    case 'd':
        if(!diskcopy())
            goto displayloop;
        screen18();
        presentation();
        goto redo
        ;

    case DELETE:
        if(NUM < DISKMAX)
            break;
        if(delete_entry
                ())
        {
            freedisk(getdisk());
            goto redo
            ;
        }
        break;

    case 'e':
        if(file_in_zip())
            break;
        if(NUM < DIRMAX)
            break;
        strcpy(FILEPATH, REPBUF[NUM]);
        return('e');


    case '=':
        sablier();
        if(compare())
            goto redisp;
        SOMME = 0;
        break;

    case CTRL_T:
        a = getdisk();
retree:
        if(!open_tree())
            goto displayloop;
redest:
        y = disp_tree();
        if(y == -1)
            goto redest;
        close_tree();
        if(y == 't')
            goto retree;

        setdisk(a);
        dir_lift();
        goto displayredo
        ;

    case 'q':
        adios(RESTE);
    case F3:
    case ALT_X:
    case ALT_F4:
        adios(RETOUR);
    default:
        beep();
        break;
    }
    goto fileloop;

displayloop:      /* Raffiche seulement */
    clear_dir();
    CLEARED_RIGHT = 1;
    goto redispdir;

    displayredo
:     /* Relit et raffiche */
    clear_dir();
    if(DOUBLE)
    {
        clear_right();
        DST_directory(0);
    }
    dir_lift();
    goto redo
    ;

tomenu:
    ch = 1080;
    ch = menusel(&menux, &ch,(int *)  menupar, (int *) menukey, (char **) menutxt);
    goto parse;

exit:
    strcpy(NOMCHE, FILEPATH);
    return(13);
}
