#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <dir.h>

#include "../gui/head.h"
#include "../gui/drive.h"
#include "../gui/texte.h"
#include "../gui/design.h"
#include "../gui/popwin.h"
#include "../gui/souris.h"
#include "../gui/gets18.h"
#include "../gui/message.h"
#include "../gui/lift.h"
#include "../gui/scroll.h"
#include "../gui/winmove.h"
#include "../gui/gostop.h"
#include "../gui/speech2.h"
#include "../gui/thick.h"
#include "../gui/alt.h"

#include "listini.h"
#include "../gui/vga.h"
#include "listgui.h"
#include "view.h"
#include "search.h"

#define EOP 0xd


char SEARCHTEXT[81];
char NOMDIC[81];
int SEARCH_SIZE;
int SEARCHPOS;
unsigned SEARCH_LINE;



/* EXISTE code 4 pour lecture, 0 pour fichier/dir */

int existe(char *fichier)
{
    int i;
    char temp[81];

    if(access(fichier, 0) != 0)
        return(0);
    getcwd(temp, 80);
    i = chdir(fichier);
    chdir(temp);

    return(i == -1);
}




int searchinput()
{
    int col;
    int colr;
    int lin;
    int linb;
    int cl;
    int w;
    int boxh = 8;

    WBACK = 7;
    WCOL = 0;

redisp:
    col  = X_SBOX;
    colr = col + W_SBOX - 1;
    lin  = Y_SBOX;
    linb = lin + boxh - 1;
    w    = colr - col - 6;

    mhide();
    DIALOG_KEYS = 0;
    winbacksave(col, lin, colr, linb);
    winboard(col, lin, colr, linb, 7);

    P_WIN = 0;

    get_frame(2, 3, w, 0,"String to search:");
    wintextcol(7, 0);
    winwrite18(3, 5, "Case sensitive");
    winwrite18(3, 6, "All document");
    winwrite18(28, 5, "F2");
    winwrite18(28, 6, "F3");
    go_key(WW - 7, 5);
    stop_key(WW - 13, 5);

    redo
:
    mhide();
    cocheit(24, 5, CASEFLAG);
    cocheit(24, 6, DOCFLAG);
    winlocate(2, 3);
    wintextcol(15,0);
    cl = getsg(SEARCHTEXT, w);
    gotoxy(1,1);

    /*
    if(MOUSIMAGE)
     if(MOUSIMAGE != MOUSE_RIGHT)
       cl = MOUSE_MOVE;
    */

parse:
    switch(cl)
    {
    case -3:
        if(testcoche(24, 5))
        {
            cl = F2;
            goto parse;
        }
        if(testcoche(24, 6))
        {
            cl = F3;
            goto parse;
        }
        if(test_go())
        {
            cl = 13;
            goto parse;
        }
        if(test_stop())
        {
            cl = 27;
            goto parse;
        }
        if(test16(13))
        {
            *SEARCHTEXT = 0;
            goto redo
            ;
        }
        if(wininside())
            goto redo
            ;
        cl = 0;
        break;
    case ALT_M:
    case ALT_R:
    case ALT_S:
    case ALT_L:
        move(&X_SBOX, &Y_SBOX, &W_SBOX, &boxh, 41, 8, 80, 8);
        winbackput();
        goto redisp;

    case 13:
        cl = strlen(SEARCHTEXT);
        break;
    case F2:
        CASEFLAG = 1 - CASEFLAG;
        goto redo
        ;
    case F3:
        DOCFLAG  = 1 - DOCFLAG;
        goto redo
        ;
    default:
        cl = 0;
        break;
    }

    winbackput();
    return(cl);
}


void NotInFile(char *src, char *file)
{
    char message[81];

    sprintf((char *) message, "\"%s\" not in %s", src, file);

    Red_Balloon((char *) message);
}


int getdic(char *src, char code)
{
    char txt[1028];
    char *dst = (char *) txt;
    char *dstorg;
    FILE *fsptr;
    int ls, ld, si, line;
    char BUF[2064];
    int ret;
    char c;
    char *adr;

    clearkey();
    ret = 0;
    if(!*src)
        goto exit1;

    if(!existe(NOMDIC))
        strcpy(NOMDIC, FILEPATH);

    ls = min( strlen(src), 48);
    if(src[ls] == '=')
        ls--;
    src[ls] = 0;

    fsptr = fopen(NOMDIC, "rb");
    if(!fsptr)
    {
        BOXBACK = 4;
        box("Enable to open %s", NOMDIC);
        goto exit;
    }

loop:
    dst = fgets(txt, 256, fsptr);
    if(dst)
    {
        while(*dst==' ')
            dst++;
        if(*dst != code)
            goto loop;
        dst++;

        ld = strlen(dst);
        while((ld > 1) && (dst[ld-1] < 0x1B))
            ld--;
        dst[ld] = 0;

        if(ld >= ls)
        {
            dstorg = dst;
trynext:
            if(!strnicmp(dst, src, ls))
            {
                c = dst[ls];
                if(c && (c != ' '))
                    goto loop;

                if(code == '~' || code == '')
                {
                    adr = strchr(dstorg, '=');
                    if(adr)
                        dstorg = adr + 1;
                    ls = 0;
                }
                else
                    ls = strlen(dstorg);

                strcpy(BUF, dstorg + ls);
                if(code == '')
                    goto fin_lecture;
                si = 2048 - strlen(BUF);
                if(si < 2048)
                    strcat(BUF, " ");
                line = 0;

nextdst:
                dst = fgets(txt, 256, fsptr);
                c = *dst;
                if(dst)
                    if((c != '#') && (c != '~') && (c != ''))
                    {
                        ld = strlen(dst);
                        if(dst[ld - 1] == 0x1a)
                            ld--;
                        if(dst[ld-1] == 10)
                            ld--;
                        if(dst[ld-1] == 13)
                            ld--;
                        dst[ld] = 0;

                        strcat(BUF, dst);
                        if(ld)
                            if(dst[ld-1] != ' ')
                                strcat(BUF, " ");
                        si -= ld;
                        if(++line < 24)
                            goto nextdst;
                    }

fin_lecture:
                BUF[2048] = 0;
                if(code == '~')
                    ret = dispsyn(BUF, BUF);
                if(code == '#')
                    ret = dispdef(src, BUF);
                if(code == '')
                    ret = case_title(BUF);
                goto exit;
            }

            adr = strchr(dst, '|');
            if(adr)
            {
                dst = adr + 1;
                while(*dst==' ')
                    dst++;
                goto trynext;
            }
        }
        goto loop;
    }

    NotInFile(src, NOMDIC);

exit:
    fclose(fsptr);

exit1:
    return(ret);
}



void remove_EOP(char *text)
{
    int l;

    l = strlen(text);
    if(l)
    {
        l--;
        if(text[l] == EOP)
            text[l] = '\0';
    }
}




int isletter(char c)
{
    int i;
    char nl;
    static char noletter[]= " ()[]{},.:!;?*=+|&\"\'~%#\4^@$\r";

    i = 0;

    if(c)
    {
        do
            nl = noletter[i++];
        while(nl && (nl != c));
        if(nl == 0)
            return(1);
    }

    return(0);
}

int isinword()
{
    int i;

    i = (int) *CURSOR;
    if(i && i != ' ')
        return(1);
    return(0);
}


int pickstring()
{
    char huge *stt;
    char huge *lst;

    stt = CURSOR;
    lst = stt;
    while((*stt != ' ') && (*stt) && (stt > BUFFER))
        stt--;
    while((*lst != ' ') && (*lst) && (lst < POSEND))
        lst++;
    while(((*stt == ' ') || (!*stt)) && (stt < lst))
        stt++;
    while(((*lst == ' ') || (!*lst)) && (lst > stt))
        lst--;

    MARK_START = stt;
    MARK_END = lst;
    return(stt < lst);
}

int pickword()
{
    char huge *stt;
    char huge *lst;

    stt = CURSOR;
    lst = CURSOR;
    while((stt >= MARK_START) && isletter(*stt))
        stt--;
    while((lst <= MARK_END)   && isletter(*lst))
        lst++;
    while((!isletter(*stt) || (!*stt)) && (stt < lst))
        stt++;
    while((!isletter(*lst) || (!*lst)) && (lst > stt))
        lst--;

    MARK_START = stt;
    MARK_END = lst;
    return(stt < lst);
}




void niceboard(int x1, int y1, int x2, int y2, char fond, char bord)
{
    int x = x1;
    int y = y1;

    WBACK = fond;
    WCOL = 0;
    WW = x2 - x + 1;
    WH = y2 - y + 1;
    WL = x;
    WR = x2;
    WRI = x2;
    WU = y;
    WB = y2;

    BACKCOL = fond;
    PENCOL  = 0;

    x  = x1  << 3;
    x2 = (x2 << 3) + 7;
    y  = y1 << 4;
    y2 = (y2 << 4) + 15;

    bar18(x, y, x2, y2, bord);
    bar18(x + 6, y + 6, x2 - 6, y2 - 6, fond);

    COLOR16 = bord + 8;
    hline18(x, y, x2 - 1);
    hline18(x, y + 1, x2 - 2);

    vline18(x,     y,     y2 - 1);
    vline18(x + 1, y + 1, y2 - 2);

    hline18(x + 5, y2 - 5, x2 - 5);
    hline18(x + 4, y2 - 4, x2 - 4);

    vline18(x2 - 5, y + 5, y2 - 4);
    vline18(x2 - 4, y + 4, y2 - 5);

    COLOR16 = 8;
    vline18(x + 4, y + 5, y2 - 5);
    vline18(x + 5, y + 6, y2 - 6);
    vline18(x2 - 1, y + 1, y2);
    hline18(x + 4, y + 4, x2 - 4);
    hline18(x + 1, y2 - 1, x2);

    COLOR16 = 0;
    vline18(x2, y, y2);
    hline18(x + 6, y + 5, x2 - 6);
    hline18(x, y2, x2);
    vline18(x + 6, y + 6, y2 - 6);
}
