


#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>
#include <io.h>
#include <time.h>
#include <dos.h>
#include <process.h>
#include <dir.h>
#include <alloc.h>

#include "../gui/head.h"
#include "../gui/drive.h"
#include "../gui/texte.h"
#include "../gui/design.h"
#include "../gui/popwin.h"
#include "../gui/super.h"
#include "../gui/souris.h"
#include "../gui/scroll.h"
#include "../gui/gets18.h"
#include "../gui/message.h"
#include "../gui/lift.h"
#include "../gui/winmenu.h"
#include "../gui/beeper.h"
#include "../gui/gostop.h"
#include "../gui/alt.h"
#include "../gui/hugertn.h"
#include "../gui/vga.h"
#include "listico.h"
#include "listini.h"
#include "search.h"
#include "listkeys.h"
#include "listgui.h"
#include "winview.h"
#include "view.h"


#define EOT 0x1a



char huge *BUFFER;          /* Start of text strings */
char huge *TEXTPTR;         /* Pointer on free space in buffer */
char huge *TEXTOP;          /* end of buffer */
char huge *TOP_OF_SCREEN;
char huge *POSEND;          /* End of text strings */

int LASTLINE;               /* Last record in buffer */
unsigned long FILELEN;

char FILEPATH[81];

int MOREDATA = 1;
long POSITION;
long POSTART;
long POSLAST;


int alloc_viewer()
{
    BUFFER  = (char huge *) malloc(VIEWBUF);
    TEXTOP  = BUFFER + VIEWBUF - 1;
    return(FP_SEG(BUFFER) && FP_SEG(BOXBUF));
}


char huge *getabl(int no)
{
    char *adr = (char *) BUFFER;

    while(no)
    {
        adr = adr + strlen(adr) + 1;
        no--;
    }
    return( (char huge *) adr);
}


int addtabl(char  *str)
{
    char huge *nextadr;

    nextadr = TEXTPTR + (strlen((char *) str) + 1);
    if(nextadr < TEXTOP)
    {
        strcpy((char *) TEXTPTR, (char *) str);
        TEXTPTR = nextadr;
        LASTLINE++;
    }
}


int get_new_view()
{
    if(!getlength())
        return(0);
    MOREDATA = (FILELEN > BLOCKSIZE);
    POSITION = 0;
    return(get_view(0));
}


int get_view(int flag)
{
    FILE *fviewptr = NULL;
    char txt[1024];
    char *res = (char *) txt;
    unsigned int size;
    int n2;

    clearkey();
    mshow();
    sablier();

    if(*FILEPATH == 0)
        return(0);

    TEXTPTR = BUFFER;
    LASTLINE = 0;

    if(access(FILEPATH, 0) != 0)
        goto exit;

    fviewptr = fopen(FILEPATH, "rb");
    if (fseek(fviewptr, POSITION, 0) != 0)
        goto exit;

    /* Coupure de ligne quand on prend le dernier bloc */

    if(flag)
        if(POSITION)
        {
            res = fgets(txt, 1024, fviewptr);
            POSITION = POSITION + (long) (strlen(txt) + 1);
        }

    POSTART = POSITION;
    size = 0;

    while(res && (size <= BLOCKSIZE))
    {
        res = fgets(txt, 1024, fviewptr);
        if(res)
        {
            addtabl(txt);
            size += (unsigned int) strlen(txt);
        }
    }

    POSITION += (long) size;

    n2 = HPAGE;
    while(res && n2)
    {
        res = fgets(txt, 1024, fviewptr);
        if(res)
        {
            addtabl(txt);
            size += (unsigned int) strlen(txt);
        }
        n2--;
    }

    POSLAST = POSTART + size;
    POSEND  = TEXTPTR;

exit:
    mhide();
    fclose(fviewptr);
    return(LASTLINE);
}


/* Search */

unsigned int searchstring(char *src)
{
    char *dst;
    register int ls;
    register int ld;
    unsigned line;

    ls =   SEARCH_SIZE;
    line = SEARCH_LINE;
    dst = (char *) hugepint( getabl(line), SEARCHPOS);

loop:
    if(dst)
    {
        if(*dst == EOT)
            goto nul;
        ld = strlen(dst);
        while(ld >= ls)
        {
            if(!superncmp(dst, src, ls))
            {
                if(!CASEFLAG)
                    return(line);
                if(!strncmp(dst, src, ls))
                    return(line);
            }
            SEARCHPOS++;
            dst++;
            ld--;
        }
        while(*dst)
            dst++;
    }

    dst++;
    line++;
    SEARCHPOS = 0;
    if((char huge *) dst < POSEND)
        goto loop;

nul:
    return(65535U);
}
