#include <stdlib.h>

#include "../gui/vgalib.h"
#include "../gui/vga.h"
#include "../gui/head.h"
#include "../gui/design.h"
#include "../gui/popwin.h"

void fastbar(int column, int ytop, int rcol,int ybottom,char col)
{
    asm .386
    asm mov dx, 03ceh
    asm mov ax, 0205h
    asm out dx, ax

    asm mov ax, 0a000h
    asm mov es, ax

    asm mov ax, ytop
    asm mov dx, 80
    asm mul dx
    asm mov di, ax
    asm add di, column

    asm mov dx, ybottom
    asm mov ax, ytop
    asm cmp dx, ax
    asm ja  sk1
    asm xchg dx, ax
sk1:
    asm sub dx, ax
    asm inc dx

    asm mov bx, rcol
    asm mov ax, column
    asm cmp bx, ax
    asm ja  sk2
    asm xchg bx, ax
sk2:
    asm sub bx, ax
    asm inc bx

    asm mov cl, col
    asm mov ch, cl
    asm mov ax, cx
    asm shl eax, 16
    asm mov ax, cx

    asm mov si, 80
    asm sub si, bx

cloop:
    asm mov cx, bx
    asm shr cx, 2
    asm rep stosd

    asm mov cx, bx
    asm and cx, 3
    asm shr cx, 1
    asm rep stosw

    asm rcl cx, 1
    asm rep stosb

    asm add di, si
    asm dec dx
    asm jnz cloop

exit:
    asm mov dx,03ceh
    asm mov ax,5
    asm out dx,ax
}


void bar18(int xl,int yt,int xr,int yb,char color)
{
    int nline;
    int wid;

    asm     mov dx,03ceh
    asm     mov ax,0205h
    asm     out dx,ax

    asm     mov     ax, yt
    asm     mov     cx, yb
    asm     cmp     cx, ax
    asm     jae     skp
    asm     xchg    ax, cx
skp:
    asm     sub     cx, ax
    asm     inc     cx
    asm     mov     nline, cx
    asm     mov     dx, 80
    asm     mul     dx

    asm     mov     bx, xl
    asm     mov     cl, bl
    asm     shr     bx, 3
    asm     mov     si, bx
    asm     add     si, ax

    asm     mov     ax, 0A000h
    asm     mov     es, ax

    asm     and     cl, 7
    asm     xor     cl, 7
    asm     mov     dh, 1
    asm     not     dh
    asm     shl     dh, cl
    asm     not     dh

    asm     mov     cx, xr
    asm     and 	cl, 7
    asm     xor 	cl, 7
    asm     mov 	dl, 0ffh
    asm     shl 	dl, cl

    asm     mov 	cx, xr
    asm     shr 	cx, 3
    asm     sub 	cx, bx
    asm     mov 	wid, cx

    asm     mov 	bx, dx
    asm     or 	bh, bh
    asm     js 	hmilieu

    asm     or 	cx, cx
    asm     jnz	hgauche

    asm     and 	bl, bh
    asm     jmp 	short hdroite

hgauche:
    asm     mov dx, 03ceh
    asm     mov al, 8
    asm     mov ah, bh
    asm     out dx, ax

    asm     mov cx, nline
    asm     mov al, color
    asm     mov di, si

ga2:
asm     mov  ah, es:
    [di]
asm     mov  es:
    [di],al
    asm     add  di, 80
    asm     loop ga2

    asm     inc si
    asm     mov cx, wid
    asm     dec cx

hmilieu:
    asm mov dx, 03ceh
    asm mov ax, 0FF08h
    asm out dx, ax

    asm mov  al, color
    asm mov  dx, nline
    asm push si

mi2:
    asm push  cx
    asm mov   di,si
    asm rep   stosb
    asm pop   cx
    asm add   si,80
    asm dec   dx
    asm jnz   mi2

    asm pop   si
    asm add   si,cx

hdroite:
    asm mov dx,03ceh
    asm mov ah,bl
    asm mov al,8
    asm out dx,ax

    asm mov al,color
    asm mov cx,nline
    asm mov di,si

dr2:
asm mov  ah, es:
    [di]
asm mov  es:
    [di], al
    asm add  di, 80
    asm loop dr2

    asm mov dx,03cEh
    asm mov ax,0ff08h
    asm out dx,ax
    asm mov ax,5
    asm out dx,ax
}



void hline18(int x1,int y,int x2)
{
    asm     mov     al,COLOR16
    asm     xor     ah,ah
    asm     mov     si,ax

    asm     mov     ax,0A000h
    asm     mov     es,ax

    asm     mov     ax,y
    asm     mov     dx,80
    asm     mul     dx

    asm     mov     cx,x1
    asm     mov     dx,x2
    asm     cmp     cx,dx
    asm     jbe     skip
    asm     xchg    cx,dx
skip:
    asm     mov     di,cx
    asm     shr     di,3

    asm     and     cl,7
    asm     xor     cl,7
    asm     mov     bh,0FEh
    asm     shl     bh,cl
    asm     not     bh

    asm     mov     cl,dl
    asm     and     cl,7
    asm     xor     cl,7
    asm     mov     bl,0ffh
    asm     shl     bl,cl

    asm     mov     cx,dx
    asm     shr     cx,3
    asm     sub     cx,di
    asm     add     di,ax

    asm     mov     dx,03ceh
    asm     mov     ax,0205h
    asm     out     dx,ax

    asm or bh,bh
    asm js hmilieu

    asm or cx,cx
    asm jnz hgauche

    asm and bl,bh
    asm jmp short hdroite

hgauche:
    asm mov ah,bh
    asm mov al,8
    asm out dx,ax
    asm mov ax,si
asm mov ah,es:
    [di]
    /*
    asm mov es:[di],al
    asm inc di
    */
    asm stosb
    asm dec cx

hmilieu:
    asm mov ax,0FF08h
    asm out dx,ax
    asm mov ax,si
    asm rep stosb

hdroite:
    asm mov ah,bl
    asm mov al,8
    asm out dx,ax
    asm mov ax,si
asm mov ah,es:
    [di]
asm mov es:
    [di],al

    asm mov ax,5
    asm out dx,ax
    asm mov ax,0FF08h
    asm out dx,ax
}

void vline18(int x,int yt,int yb)
{
    asm mov si,80

    asm mov ax,yt
    asm mov cx,yb
    asm sub cx,ax
    asm jge skinv

    asm neg cx
    asm mov ax,yb

skinv:
    asm     inc     cx
    asm     mov     bx,x
    asm     push    cx

    asm     mov     cl,bl
    asm     mul     si
    asm     shr     bx,1
    asm     shr     bx,1
    asm     shr     bx,1
    asm     add     bx,ax
    asm     mov     di,bx
    asm     mov     ax,0A000h
    asm     mov     es,ax
    asm     and     cl,7
    asm     xor     cl,7
    asm     mov     ah,1
    asm     shl     ah,cl

    asm     mov dx,03ceh
    asm     mov al,8
    asm     out dx,ax
    asm     mov ax,0205h
    asm     out dx,ax

    asm pop cx
    asm mov al,COLOR16

vloop:
asm mov ah,es:
    [di]
asm mov es:
    [di],al
    asm add di,si
    asm loop vloop

    asm mov ax,5
    asm out dx,ax
    asm mov ax,0FF08h
    asm out dx,ax
}


void rectangle18(int l,int u,int r,int b, char color)
{
    char s;
    s = COLOR16;
    COLOR16 = color;
    hline18(l,u,r);
    vline18(l,u,b);
    hline18(l,b,r);
    vline18(r,u,b);
    COLOR16 = s;
}



void xbloc(int x,int y,int l,int h)
{
    if(x>79)
        goto xxit;
    if(y>479)
        goto xxit;
    if(l<1)
        goto xxit;
    if(h<1)
        goto xxit;

    asm     mov     ax,y
    asm     mov     dx,80
    asm     mul     dx
    asm     mov     di,095b0h
    asm     sub     di,ax
    asm     mov     dx,x
    asm     add     di,dx

    asm     mov     ax,0A000h
    asm     mov     es,ax

    asm mov dx,03ceh
    asm mov ax,0205h
    asm out dx,ax
    asm mov ax,01803h
    asm out dx,ax

    asm push es
    asm mov al,0FFh
    asm mov bx,h

wh:
    asm mov cx,l
    asm push di

wl:
asm mov ah,es:
    [di]
    asm stosb
    asm loop wl

    asm pop di
    asm sub di,80
    asm dec bx
    asm jnz wh

    asm pop es
    asm mov ax,5
    asm out dx,ax
    asm mov ax,3
    asm out dx,ax

xxit:
    return;
}



/* IMAGE16
   Dessin de sprite code 5
   coordonnes x, y pixels
   fond bleu
*/


void image16(int x,int y,char *buf)
{
    int line;
    unsigned char nline;
    unsigned int ctr;
    unsigned char shift;

    asm push ds

    asm lds si,buf
    asm lodsw
    asm mov nline,al
    asm lodsw
    asm mov ctr,ax
    asm inc si
    asm inc si

    asm mov ax,y
    asm mov dx,80
    asm mul dx
    asm mov di,095b0h
    asm sub di,ax
    asm mov ax,x
    asm mov cl,al
    asm shr ax,3
    asm add di,ax
    asm mov line,di
    asm and cl,7
    asm mov shift,cl

    asm mov dx, 03ceh
    asm mov ax, 0205h
    asm out dx, ax
    asm mov ax, 0a000h
    asm mov es, ax

    asm mov al,8

line:
    asm mov di,line
    asm mov cl,shift
    asm mov ah,128
    asm ror ah,cl
    asm mov cx,ctr

col:
    asm  out    dx,ax
asm  mov    bl,es:
    [di]
asm  mov    bl,ds:
    [si]
    asm  inc    si
    asm  mov    bh,bl
    asm  shr    bl,4
    asm  cmp    bl, 9
    asm  je     skip
asm  mov    es:
    [di],bl
skip:
    asm  ror    ah,1
    asm  adc    di,0

    asm  dec    cx
    asm  jz     fincol

    asm  out    dx,ax
asm  mov    bl,es:
    [di]
    asm  and    bh,0xf
    asm  cmp    bh, 9
    asm  je     skip2
asm  mov    es:
    [di],bh
skip2:
    asm  ror    ah,1
    asm  adc    di,0
    asm  loop   col

fincol:
    asm  sub    word ptr line,80
    asm  dec    byte ptr nline
    asm  jnz    line

okexit:
    asm mov ax, 5
    asm out dx, ax
    asm mov ax, 0ff08h
    asm out dx, ax
    asm pop ds
}



void vpointille(int x,int yt,int yb)
{
    asm push es
    asm mov dx, 03ceh
    asm mov ax, 0205h
    asm out dx, ax

    asm mov ax, 0a000h
    asm mov es, ax

    asm mov ax, yt
    asm mov bx, yb
    asm cmp ax, bx
    asm jb  sk
    asm xchg ax,bx
sk:
    asm inc bx
    asm sub bx, ax
    asm shr bx, 1
    asm push bx

    asm mov bx, 80
    asm mul bx

    asm mov bx, x
    asm mov cl, bl
    asm shr bx, 3
    asm add bx, ax

    asm and cl, 7
    asm xor cl, 7
    asm mov ch, 1
    asm shl ch, cl
    asm mov ah, ch
    asm pop cx

    asm mov dx, 03ceh
    asm mov al, 8
    asm out dx, ax
    asm mov ah, COLOR16

vllp2:
asm mov al, es:
    [bx]
asm mov es:
    [bx], ah
    asm add bx, 160
    asm loop vllp2

    asm mov ax, 5
    asm out dx, ax
    asm mov ax, 0ff08h
    asm out dx, ax
    asm pop es
}




void hpointille(int x1,int y,int x2)
{
    asm     mov     al, COLOR16
    asm     xor     ah, ah
    asm     mov     si, ax

    asm     mov     ax, 0A000h
    asm     mov     es, ax

    asm     mov     ax, y
    asm     mov     dx, 80
    asm     mul     dx

    asm     mov     di, x1
    asm     mov     dx, x2
    asm     cmp     di, dx
    asm     jbe     skip
    asm     xchg    di, dx
skip:
    asm     mov     cx, di
    asm     shr     di, 3

    asm     and     cl, 7
    asm     xor     cl, 7
    asm     mov     bh, 0FEh
    asm     shl     bh, cl
    asm     not     bh

    asm     mov     cl, dl
    asm     and     cl, 7
    asm     xor     cl, 7
    asm     mov     bl, 0ffh
    asm     shl     bl, cl

    asm     mov     cx, dx
    asm     shr     cx, 3
    asm     sub     cx, di
    asm     add     di, ax

    asm     mov     dx, 03ceh
    asm     mov     ax, 0205h
    asm     out     dx, ax

    asm 	or 	bh, bh
    asm 	js 	hmilieu

    asm 	or 	cx, cx
    asm 	jnz 	hgauche

    asm 	and 	bl, bh
    asm 	jmp 	short hdroite

hgauche:
    asm 	mov 	ah, 170
    asm 	and 	ah, bh
    asm 	mov 	al, 8
    asm 	out 	dx, ax
    asm 	mov 	ax, si
asm 	mov 	ah, es:
    [di]
asm 	mov 	es:
    [di],al
    asm 	inc 	di
    asm 	dec 	cx

hmilieu:
    asm mov ah, 170
    asm mov al, 8
    asm out dx, ax
    asm mov ax, si
    asm test cl, cl
    asm jz   hdroite

col:
asm mov ah,es:
    [di]
    asm stosb
    asm loop col


hdroite:
    asm mov ah,170
    asm and ah,bl
    asm mov al,8
    asm out dx,ax
    asm mov ax,si
asm mov ah,es:
    [di]
asm mov es:
    [di],al

    asm mov ax,5
    asm out dx,ax
    asm mov ax,0FF08h
    asm out dx,ax
}



void xoutline(int x, int y, int x2, int y2)
{
    COLOR16 = 15;
    asm mov dx,03CEh
    asm mov ax,018h
    asm mov ah,al
    asm mov al,3
    asm out dx,ax

    x = max(0, x);
    x2 = min(639, x2);
    hpointille(x+1,y,x2-1);
    hpointille(x+1,y2,x2-1);
    vpointille(x,y,y2);
    vpointille(x2,y,y2);

    asm mov dx,03CEh
    asm mov ax,0
    asm mov ah,al
    asm mov al,3
    asm out dx,ax
}

