
#include <bios.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <io.h>
#include <dos.h>
#include <stat.h>;
#include <ctype.h>;
#include "../gui/alt.h"
#include "../gui/drive.h"
#include "../gui/gets18.h"
#include "../gui/message.h"

unsigned long DISKFREE;
unsigned long DISKSIZE;

char KEYBOARD;

char ALT;
char SHIFT;
char CTL;
char ALTLEFT;
char ALTRIGHT;
char SHIFTLEFT;
char SHIFTRIGHT;


unsigned char far *keyflags = (char far *)0x00400017;
unsigned char far *keyflags2 = (char far *)0x00400018;

void clrcaps() { *keyflags &= ~0x40;}
void setnumlock() { *keyflags |= 0x20;}


/* ------------------ NO CONTROL ------------------ */

void clearkey()
{
 unsigned int far *pu;

 disable();
 pu = (unsigned int far *) 0x41a;
 *pu++ = 0x1e;
 *pu   = 0x1e;
 enable();
}


/* NO CONTROL C etc... */

void interrupt (*OLDINT9) ();


void interrupt ctrlhandler(void)
{
 if(*keyflags & 4)
 {
  switch(inportb(0x60))        /* lire entre clavier */
   {
    case 0x2E :       /* ctrl-c  46 */
    case 0x2e + 0x80: goto newint;

    case 0x46:        /* ctrl_break  70 */
    case 0x46 + 0x80: goto newint;
    case 0x1F:                    /* ctrl-s */
    case 0x1f + 128: goto newint;
    case 25 :                     /* ctrl-p */
    case 25 + 128:   goto newint;
    default:  break;
   }
  }

 (*OLDINT9)(); return;

newint:
 *keyflags &= 251;
 _BL = inportb(0x61);          /* supprimer la touche pour lectronique */
 outportb(0x61, _BL | 0x80);
 outportb(0x61, _BL);
 outportb(0x20, 0x20);
bye:
 enable();
 return;
}

/*
void interrupt ctrlhandler(void)
{

 _AL = inportb(0x60);
 asm	test	al, 080h
 asm	jnz     normal

 KEYBOARD = _AL;

 _AH = *keyflags;
 asm	and	ah, 4
 asm	jz	normal        /* non control */

 CTL = 4;
 asm	cmp al, 02Eh  /* ctl c */
 asm   	je  newint
 asm	cmp al, 046h  /* ctl brk */
 asm   	je  newint
 asm	cmp al, 01fh  /* ctl s */
 asm   	je  newint
 asm    cmp al, 025   /* ctl p */
 asm	je  newint

normal:
 (*OLDINT9) ();
 return;

newint:
 *keyflags &= 251;             /* enlever CTRL */

 _BL = inportb(0x61);          /* supprimer la touche pour lectronique */
 outportb(0x61, _BL | 0x80);
 outportb(0x61, _BL);
 outportb(0x20, 0x20);

bye:
 enable();
 return;
}
*/



void nocontrolc()
{
 OLDINT9 = getvect(0x9);
 setvect(9, ctrlhandler);
}

void controlc()
{
 setvect(9, OLDINT9);
}


/* ------------------ NO FATAL ----------------------- */


typedef void interrupt (*fptr)();
fptr oldHandler;

void interrupt NEWINT24();

fptr OLDINT24;

int diskError;

/* This is the severe error handler.  It homes the cursor before
   processing the error. */

void interrupt NEWINT24()
{
asm	nop
};


int handler24(int errval, int da, int db, int dc)
 {
  enable();
  da = da;
  db = db;
  dc = dc;
  diskError = (int) LOWBYTE(errval);
  hardretn(diskError);
 }

void nofatal()
{
asm	mov	ax,3524H    		/* get int 24 vector */
asm	int	21H         		/* DOS call  */
asm	mov	word ptr OLDINT24,bx   	/* store the offset */
asm	mov	word ptr OLDINT24+2,es 	/* and the segment  */

/* setvect(0x24, NEWINT24); */
 harderr(handler24);
};

void fatal() { setvect(0x24, OLDINT24);}



void interrupt (*OLDINT23) ();

void interrupt NEWINT23()
{
 asm clc
};

void nobreak(int (*handler) (void))
{
 OLDINT23 = getvect(0x23);
 ctrlbrk(handler);
}

void setbreak()
{
 setvect(0x23, OLDINT23);
}


void setcaps() { *keyflags |= 0x40;}
void clrnumlock() { *keyflags &= ~0x20;}


unsigned long MULTIPLIER = 1193 * 2L;

void near dummy (void) {}

/*
Name            readtimer - read the complemented value of timer 0
Description     Obtain the complement of the value in timer 0.  The
                complement is used so that the timer will appear to
                count up rather than down.  The value returned will
                range from 0 to 0xffff.
Return value    The complement of the value in timer 0.
*/

unsigned near readtimer (void)
{
  asm pushf                    /* Save interrupt flag                       */
  asm cli                      /* Disable interrupts                        */
  asm mov  al,0h               /* Latch timer 0                             */
  asm out  43h,al
      dummy();                 /* Waste some time */
  asm in   al,40h              /* Counter --> bx                            */
  asm mov  bl,al               /* LSB in BL                                 */
      dummy();                 /* Waste some time */
  asm in   al,40h
  asm mov  bh,al               /* MSB in BH                                 */
  asm not  bx                  /* Need ascending counter                    */
  asm popf                     /* Restore interrupt flag                    */
  return( _BX );
}

/*  timer_init - initialize MULTIPLIER for delay function */

void timer_init(void)
{
 int i;

 for (i = 0; i < 100; i++)
  if ((readtimer() & 1) == 0)     /* readtimer() returns complement */
   {
     MULTIPLIER = 1193L;
     return;
   }
}


#pragma startup timer_init 16

/*
    delay - wait for specified period.
    void delay2(unsigned milliseconds);
*/

void delay2(unsigned milliseconds)
{
  unsigned long stop;
  unsigned cur, prev;

  stop = (prev = readtimer()) + (milliseconds * MULTIPLIER);

  while ((cur = readtimer()) < stop)
   {
    if(cur < prev)     /* Check for timer wraparound */
     {
	if (stop < 0x10000L) break;
	stop -= 0x10000L;
     }
    prev = cur;
   }
}

/* ------------------- TEST DRIVE --------------------- */

#define D_READABLE    1
#define D_WRITEABLE   2
#define D_NOFORMAT    4
#define D_INVALID     8
#define D_NOTINSERTED 16
#define D_REMOVABLE   32

/*
#define D_SUBST       64
#define D_REMOTE      128
#define D_RAM         256
*/


/*
   Test the availability of a drive.
   Entre:    int drive         0 = A:, 1 = B:, 2 = C:,...
   Sortie:    combinaison (bitwise OR) of
*/


int test_drive( int drive )
{

 static char *fname="x:\\test$$$$.tmp";
 int fhandle;
 int status;

/* Open a file (write) */

 diskError = -1;
 fname[0] = (char) drive + 'A';
 fhandle = open( fname, O_CREAT, S_IREAD | S_IWRITE );

 if( fhandle >= 0 )
  {
    close(fhandle);
    unlink(fname);
  }
 else
  if(diskError < 0) diskError = _doserrno + 256;



/* box("try disk derror %d derrno %d ", diskError, _doserrno);*/
 status = 0;

 switch(diskError)
 {
  case -1:   status |= D_WRITEABLE;

  case EACCES + 256:
  case  0:   status |= D_READABLE; break;

  case 0x07:
  case 0x0C: status |= D_NOFORMAT; break;
  default:   status = D_INVALID;
 }

/*  Teste si amovible pour tester insertion  */

asm mov ah, 0x44
asm mov al, 0x08
asm mov bl, drive
asm inc bl
asm int 021h
asm jc  noremove
asm test ax, ax
asm jnz noremove
status |= D_REMOVABLE;

/* Test if disk inserted */

noremove:
 if((status & D_INVALID)  && (status & D_REMOVABLE))
   {
     status |= D_NOTINSERTED;
     status &= ~D_INVALID;
   }

 return status;

}



/*
   DISK VERIFY
   Affiche les rsultat des tests sur drive

   ENTREE
   level = 0   lecture seule
   level = 1   lecture ecriture
   level = 2   format, test si subst
   SORTIE
   opt = 1     OK
   opt = 27    Annuler
   opt = y/n   Rponse
*/


int disk_verify(int drive, int level)
{

 int code;
 int opt;

retry:
 opt = 1;
 code = test_drive(drive);
/* box("code =%d drive = %d", code, drive);*/
 BOXBACK = 12;

 if(level)
  if(code & D_READABLE)
   if((code & D_WRITEABLE) == 0)
    { BOXYES = 1; opt = answer(box("Write protected, Retry?"));}
 if(code & D_NOFORMAT)
    { BOXYES = 1; opt = answer(box("No formatted, Retry?"));}
 if(code & D_INVALID)
    { BOXYES = 1; opt = answer(box("Drive %c not ready, retry?", (char) drive + 'A')); }
 if(code & D_NOTINSERTED)
    { BOXYES = 1; opt = answer(box("Insert a disk and retry?")); }
 BOXBACK = 7;

switch(opt)
{
 case 13: goto retry;
 case 'n': opt = 27; break;
 case 0:
 default: break;
}

 return(opt);

}


/* Dtermine l'unit  partir du chemin indiqu pour verify() */

int which_drive(char *FILEPATH)
{

 int d;
 char c;

 if(FILEPATH[1] == ':')
 {
  c = FILEPATH[0];
  if((c >= 'a') && (c <= 'z'))  c = _toupper(c);
  d = (int) (c - 'A');
 }
 else d = getdisk();

 return(d);

}


/* --------------- FONCTIONS DISK DIRECTES ----------------- */

 /* 0= a, 1 = b, etc... */


int testdisk(unsigned char drive)
{

int save;

asm mov dl,drive
asm cmp dl,2
asm jge any

asm pusha
asm mov ah,8
asm int 013h
asm xor ah,ah
asm mov al,bl
asm mov save,ax
asm popa
asm mov ax,save
asm jmp short exit

any:
asm mov ah,019h      /* get current */
asm int 021h
asm mov save,al

asm mov ah,0eh       /* set to test */
asm mov dl,drive
asm int 021h

asm mov ah,019h       /* get if correct */
asm int 021h

asm cmp al,drive
asm mov al,0
asm jne skip
asm inc al
skip:
asm xor  ah,ah
asm push ax

asm mov ah,0eh       /* set drive */
asm mov dl,save
asm int 021h

asm pop ax
exit:
return;

}


/*
   DISK SPACE
   Calcule espace occup, libre
*/

void diskspace(int unite,unsigned int *spc,unsigned int *ncl,unsigned int *bps,unsigned int *nct)
{

 asm mov ah,036h
 asm mov dl,unite
 asm int 021h

 asm les di,spc
 asm stosw

 asm les di,ncl
 asm mov ax,bx
 asm stosw

 asm les di,bps
 asm mov ax,cx
 asm stosw

 asm les di,nct
 asm mov ax,dx
 asm stosw

}



void freedisk(int DSK)
{

 unsigned int nsc;   /* nombre de secteurs par cluster */
 unsigned int ncl;   /* nombre de clusters */
 unsigned int bps;   /* bytes par secteurs */
 unsigned int nct;   /* clusters par piste? */

 diskspace(DSK+1, &nsc, &ncl, &bps, &nct);

 DISKFREE = (unsigned long) nsc;
 DISKFREE = DISKFREE * ncl;
 DISKFREE = DISKFREE * bps;

 DISKSIZE = (unsigned long) nsc;
 DISKSIZE = DISKSIZE * (unsigned long) bps;
 DISKSIZE = DISKSIZE * (unsigned long) nct;
 DISKSIZE /= 1024;

}



/*

   TEST EXISTENCE ET TYPE ETENDU UNITE DISQUE

 Quatres octets par unit:
 1) Existe
 2) Est amovible ou fixe
 3) Est local, distant, ou partag
 4) Est floppy, hard, RAMDRIVE, subst, ou CD-ROM

 0  Absent   1 Existe
 0  Amovible 1 Fixe
 0  Local    1 Distant   2 Partag
 0  Floppy   1 Hard      2 RAM      3 Subst  4 CD-ROM

 Appel en C: void Drives_Check(void);
 */



/* Default to not exist, fixed, local, hard drive */

char DriveType[26][4] = {
0,1,0,1, 0,1,0,1, 0,1,0,1, 0,1,0,1,
0,1,0,1, 0,1,0,1, 0,1,0,1, 0,1,0,1,
0,1,0,1, 0,1,0,1, 0,1,0,1, 0,1,0,1,
0,1,0,1, 0,1,0,1, 0,1,0,1, 0,1,0,1,
0,1,0,1, 0,1,0,1, 0,1,0,1, 0,1,0,1,
0,1,0,1, 0,1,0,1, 0,1,0,1, 0,1,0,1,
0,1,0,1, 0,1,0,1
};


void Drives_Check()
{

asm	pusha

asm	mov     ah,19h
asm	int     21h             /* get start drive */
asm	push    ax              /* save start drive */

asm	mov     ax,40h
asm	mov     es,ax
asm	mov     bh,es:[10h]     /* 40:10h is # of floppies-1 */
asm	shr     bh,6
asm	inc     bh              /* # of actual floppy drives */
asm	mov     bl,1
asm	mov     di,offset _DriveType

nextchkfloppy:
asm     mov     ax,4409h        /* check if drive exists */
asm	int     21h
asm	jc      nextsetfloppy
asm	test    dh,10000000b    /* check if SUBST drive */
asm	jz      chkfloppy
asm	dec     bh              /* dec actual drive count */
asm	mov     byte ptr [di+3],SUBST

setfloppyexist:
asm     mov     byte ptr [di],DRIVE_EXIST
asm	jmp     nextsetfloppy

chkfloppy:
asm     dec     bh              /* dec actual drive count */
asm	js      nextsetfloppy
asm 	mov     byte ptr [di+1],REMOVABLE
asm	mov     byte ptr [di+3],FLOPPY
asm	jmp     setfloppyexist

nextsetfloppy:
asm     add     di,4
asm	inc     bl
asm	cmp     bl,2            /* if B then jump back */
asm	je      nextchkfloppy

asm	mov     ch,24           /* loop 24 times (drives C - Z) */
asm	mov     cl,3            /* start at C: */

drivechkloop:
asm     mov     ax,4409h        /* check if drive exists */
asm	mov     bl,cl           /* set drive letter */
asm	int     21h             /* 0 = default, 1 = A:, etc. */
asm	jc      nextsetdrv
asm	mov     byte ptr [di],DRIVE_EXIST

asm	mov     ax,4408h        /* check if removable */
asm	int     21h
asm	mov     byte ptr [di+1],al      /* set REMOVABLE or FIXED */

asm	mov     bx,dx
asm	mov     dl,dh
asm	shr     dl,7
asm	and     dh,00010000b
asm	shr     dh,4
asm	mov     byte ptr [di+2],dh      /* set REMOTE or LOCAL */
asm	or      dl,dl                   /* if not SUBST, then jump */
asm	jz      chkremote
asm	mov     byte ptr [di+3],SUBST
asm	jmp     nextsetdrv

chkremote:
asm     cmp     dh,DRIVE_REMOTE    /* if REMOTE, then check for CD ROM */
asm	je      chkcdrom

asm	test    bh,00000010b    /* sharable? */
asm	jz      drivenoshare
asm	mov     byte ptr [di+2],DRIVE_SHARED

drivenoshare:
asm     test    bl,00000010b    /* RAMDRIVE drive? */
asm	jnz     nextsetdrv
asm	mov     byte ptr [di+3],RAMDRIVE
asm	jmp     nextsetdrv

chkcdrom:
asm      push    cx
asm	 mov     ax,1500h
asm	 xor     bx,bx
asm	 int     2fh
asm	 pop     cx
asm	 or      bx,bx           /* MSCDEX driver found? */
asm	 jz      nextsetdrv      /* if not, jump to next drive setup */
asm 	 mov     ax,150bh
asm	dec     cl              /* 0=A:, etc. */
asm	int     2fh
asm	inc     cl
asm	or      ax,ax
asm	jz      nextsetdrv      /* drive supported by MSCDEX? */
asm	mov     byte ptr [di+3],CDROM

nextsetdrv:
asm     add     di,4
asm	inc     cl
asm	dec     ch
asm	jnz     drivechkloop

asm	pop     dx
asm	mov     ah,0eh
asm	int     21h             /* reset start drive */

asm	popa

}

