#include <stdlib.h>

#include "../gui/head.h"
#include "../gui/thick.h"
#include "../gui/souris.h"
#include "../gui/vga.h"
#include "../gui/texte.h"
#include "../gui/design.h"
#include "../gui/popwin.h"
#include "../gui/drive.h"
#include "../gui/lift.h";
#include "listgui.h"

/*
    ASCENCEUR
*/



unsigned int OLDLIFT;
unsigned int LIFTSIZE;
int LIFTRMARGIN = 4;
int LIFTBMARGIN = 4;
int LIFTTMARGIN = 4;
char PUTCURSOR = 1;
char B_LIFT = 7;

int LLIFT;
int RLIFT;
int TLIFT;
int BLIFT;
int ETLIFT;
int EBLIFT;


/* dessine le bouton d'ascenseur */

void drawlift(int x,int y)
{
    bar18(x, y, x + 15, y + 15, 7);
    COLOR16=15;
    hline18(x,      y,      x + 15);
    vline18(x,      y,      y + 15);
    COLOR16=8;
    vline18(x + 15, y,      y + 14);
    hline18(x,      y + 15, x + 15);
    COLOR16=8;
    vline18(x + 14, y + 1,  y + 13);
    hline18(x + 1,  y + 14, x + 15);
    COLOR16=0;
    hline18(x,      y - 1,  x + 15);
    hline18(x,      y + 16, x + 15);
}


#define MAXBUT16 20

int X16[MAXBUT16];
int Y16[MAXBUT16];
char C16[MAXBUT16]=
    {
        23,    /* SCROLL_OPEN */
        24,    /* 1 LIFT_UP */
        25,    /* 2 LIFT_DOWN */
        27,    /* 3 LIFT_LEFT */
        26,    /* 4 LIFT_RIGHT */
        18,    /* 5 SWITCH up/down */
        23,    /* 6 SCROLL */
        '<',   /* 7 */
        '>',   /* 8 */
        '-',   /* 9 */
        '+',   /* 10 */
        23,    /* 11 SCROLL */
        23,    /* 12 SCROLL */
        'X',   /* 13 Clear  */
        'X',   /* 14 */
        30,    /* 15 up */
        'x',   /* 16 cancel */
        254,   /* 17 ok */
        '-',   /* 18 */
        '+',   /* 19 */
    };

void key16(char no)
{
    int x, y, xr, yb;
    int depl;
    char col2;

    x = X16[no];
    y = Y16[no];
    xr = x + 15;
    yb = y + 15;
    depl = PRESS;

    if(depl)
    {
        COLOR16 = 0;
        col2 = 7;
    }
    else
    {
        COLOR16 = 15;
        col2 = 8;
    }

    mhide();
    bar18(x, y, xr, yb, 7);

    hline18( x, y, xr);
    vline18( x, y, yb);

    COLOR16 = col2;
    vline18( xr, y + 1, yb);
    hline18( x + 1, yb, xr);
    vline18( xr - 1, y + 2, yb - 1);
    hline18( x + 2, yb - 1, xr);
    rectangle18( x - 1, y - 1, xr + 1, yb + 1, 0);

    if(no == 16)
        y --;
    PENCOL = 0;
    writeoncxy(x + 3 + depl, y + 1 + depl, C16[no]);
    PRESS = 0;
}


void keydown(int x, int y, char no)
{
    X16[no] = x;
    Y16[no] = y;
    key16(no);
}

void putkey16(int col, int row, char no)
{
    X16[no] = (col << 3) - 8;
    Y16[no] = (row << 4) - 16;
    key16(no);
}


void key15(char no)
{
    int x, y, xr, yb;
    int depl;
    char col2;

    x = X16[no];
    y = Y16[no];
    xr = x + 14;
    yb = y + 15;
    depl = PRESS;

    if(depl)
    {
        COLOR16 = 0;
        col2 = 7;
    }
    else
    {
        COLOR16 = 15;
        col2 = 8;
    }

    mhide();
    bar18(x, y, xr, yb, 7);

    hline18( x, y, xr);
    vline18( x, y, yb);

    COLOR16 = col2;
    vline18( xr, y + 1, yb);
    hline18( x + 1, yb, xr);
    vline18( xr - 1, y + 2, yb - 1);
    hline18( x + 2, yb - 1, xr);
    rectangle18( x - 1, y - 1, xr + 1, yb + 1, 0);

    if(no == 16)
        y --;
    PENCOL = 0;
    writeoncxy(x + 3 + depl, y + 1 + depl, C16[no]);
    PRESS = 0;
}

void keybar(int x, int y, char no)
{
    X16[no] = x;
    Y16[no] = y;
    key15(no);
}


int test16(char no)
{
    int x, y;

    x = X16[no];
    y = Y16[no];

    if(mx >= x)
        if(mx <= (x + 16))
            if(my >= y)
                if(my <= (y + 16))
                {
                    PRESS = 1;
                    key16(no);
                    delay2(250);
                    key16(no);
                    return(1);
                }
    return(0);
}


/* Afficher un compteur */

char COUNTER_BACK = 0;
char COUNTER_PEN = 2;
int COUNTER_X[2];
int COUNTER_Y[2];


void dispcounter(int no, int speed)
{
    BACKCOL = COUNTER_BACK;
    PENCOL  = COUNTER_PEN;
    writef18(COUNTER_X[no] + 2, COUNTER_Y[no], " %d ", speed);
}


void putcounter(int no, int col, int row)
{
    int key;

    key = 9 + 9 * no;
    COUNTER_X[no] = col;
    COUNTER_Y[no] = row;
    putkey16(col, row, key);
    putkey16(col + 5, row, key + 1);
}

int changecounter(int no, int key, int speed)
{
    if(key == '+')
        if(speed < 9)
            speed++;
    if(key == '-')
        if(speed > 0)
            speed--;
    dispcounter(no, speed);
    return(speed);
}



void keylift(char no)
{
    int x = LLIFT;
    int y;

    if(no == LIFT_UP)
        y = TLIFT - 17;
    else
        y = BLIFT + 17;
    keydown(x, y, no);
}

/* definit bords de l'ascenseur */

void liftcalc()
{
    RLIFT = (WR << 3) + 7 - LIFTRMARGIN;
    LLIFT = RLIFT - 15;
    TLIFT = (WU << 4) + 16 + LIFTTMARGIN;
    BLIFT = (WB << 4) - 17 - LIFTBMARGIN;
    ETLIFT = TLIFT - 17;
    EBLIFT = BLIFT + 31;
}


/* dessine l'ascenseur */

void putlift(char bflag)
{

    liftcalc();

    LIFTSIZE = BLIFT - TLIFT;
    OLDLIFT  = 0;
    WRI = WR - 2;

    mhide();
    bar18(LLIFT, TLIFT , RLIFT, BLIFT + 15, B_LIFT);
    rectangle18(LLIFT - 1, TLIFT - 18, RLIFT + 1, BLIFT + 32, 0);
    hline18(LLIFT, TLIFT-1, RLIFT);
    hline18(LLIFT, BLIFT+16, RLIFT);
    keylift(LIFT_UP);
    keylift(LIFT_DOWN);
    if(bflag)
    {
        drawlift(LLIFT, TLIFT);
        PUTCURSOR = 1;
    }
    else
        PUTCURSOR = 0;

    LIFTRMARGIN = 4;
    LIFTBMARGIN = 4;
    LIFTTMARGIN = 4;
}


/* positionne ascenseur selon numro d'item de la liste */

int num2lift(int num, int nmax)
{
    long tmp;
    tmp = ((long) LIFTSIZE * (long) num) / (long) (nmax-1);
    return((int) tmp);
}


/* Dplace l'ascenseur selon le curseur y */

void movelift(int y)
{
    int yold;
    int x = LLIFT;
    int haut;
    int bas;

    yold = TLIFT + OLDLIFT;
    haut = (yold > TLIFT);
    bas  = ((yold) < BLIFT);

    if(PUTCURSOR)
    {
        mhide();
        bar18(x, yold - haut, x + 15, yold + 15 + bas, B_LIFT);
        drawlift(x, TLIFT + y);
        mshow();
    }
    OLDLIFT = y;
}


/* deplace ascenseur selon numro */

void numberlift(int num,int nmax)
{
    if(nmax > 1)
        movelift( num2lift(num, nmax) );
}

/* Dplace ascenseur selon souris et retourne numro d'item dans la liste
   Input: numro d'item courant
	  nombre d'items
   Output: nouveau numro d'item
	   y  position relative sur ascenseur
	   -1 hors fentre
	   -2 boutons d'extrmits
 */

signed int wmouselift(int *onum,int nmax)
{
    int num = *onum;
    signed int flag = -1;
    long tmp;
    int i;

    if(nmax < 2)
        goto nul;

    if(mx < LLIFT)
        goto nul;
    if(mx > RLIFT)
        goto nul;
    if(my > EBLIFT)
        goto nul;
    if(my < ETLIFT)
        goto nul;

    if(test16(LIFT_UP))
        return(1072);
    if(test16(LIFT_DOWN))
        return(1080);

    i = min(my - TLIFT, LIFTSIZE);
    tmp  = (long) i;
    tmp  = (tmp * nmax ) / LIFTSIZE;
    num  = min((int) tmp, nmax-1);
    movelift(i);
    *onum = num;
    flag = 1;

nul:
    return(flag);
}

