#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>

#include "../gui/head.h"
#include "../gui/vga.h"
#include "../gui/texte.h"
#include "../gui/design.h"
#include "../gui/popwin.h"
#include "../gui/souris.h"
#include "../gui/gets18.h"
#include "../gui/winmenu.h"
#include "../gui/alt.h"
#include "listgui.h"
#include "../gui/menu.h"



int testroot();
int testmenu(int,int);

char MENUBAR;              /* couleur */
char *MENUROOT;
int MENUROW = 0;
int MWIDTH = 15;
int MENUROOT_STEP  = 12;
int MENUROOT_WIDTH = 10;
int MENUROOT_SIZE  = 10;
int MENUROOT_START = 1;
int MENU_NUMBER = 6;
int MENUROOT_FIRSTCOL;
int MENU_ROW_MAX = 9;

void rootinv(int pos, char mode)
{
    static char oldpos;
    char s;
    int l, r;
    int x;
    int column;

    if(mode)
    {
        BACKCOL = 0;
        PENCOL = MENUBAR;
        oldpos = pos;
    }
    else
    {
        BACKCOL = MENUBAR;
        PENCOL = 0;
        pos = oldpos;
    }

    column = MENUROOT_FIRSTCOL + MENUROOT_WIDTH * pos;
    l = MENUROOT_START + pos * MENUROOT_STEP;
    r = l + MENUROOT_SIZE;
    x = column << 3;

    mhide();
    s = MENUROOT[r];
    MENUROOT[r] = 0;
    fastbar(column, MENUROW + 1, column + MENUROOT_SIZE - 1, MENUROW + 16, BACKCOL);
    writeonxy( x, MENUROW + 1, MENUROOT + l);
    MENUROOT[r] = s;
}


void menuinv(int column, int line, char *txt, char mode)
{
    int y;

    y = MENUROW + (line << 4) + 18;

    if(mode)
    {
        BACKCOL = 0;
        PENCOL = MENUBAR;
    }
    else
    {
        BACKCOL = MENUBAR;
        PENCOL = 0;
    }

    mhide();
    fastbar(column, y, column + MWIDTH - 1, y + 15, BACKCOL);
    writeonxy((column << 3) - 1, y, txt);
}

void smenuput(int menux)
{
    menuput();
    rootinv(menux, 0);
}

#define KEY_POS menux * MENU_ROW_MAX + menuy - 1
#define TXT_POS menux * MENU_ROW_MAX + menuy - 1

int menusel(int *retour,
            int *opt,
            int *menupar,
            int *menukey,
            char *menutxt[])
{
    int column;
    int menux, menuy;
    int nentry
    , num;
    int option;
    int l, r, t, b;

    menux  = *retour;
    option = *opt;
    MENUROOT_FIRSTCOL = menupar[MENU_NUMBER * 2];

    if(option == 1080)
        goto sous_menu;

rootloop:
    column = menupar[MENU_NUMBER * 2 + menux];
    rootinv(menux, 1);

    if(MOUSE)
    {
        mshow();
        while(!kbhit())
        {
            if(mclick())
            {
                release();
                num = testroot();
                if(num >= 0)
                {
                    menux = num;
                    option = 13;
                    goto root_m_skip;
                }
                option = 27;
                goto root_m_skip;
            }
        }
    }

    option = get1000();

root_m_skip:
    rootinv(menux, 0);
    switch(option)
    {
    case 1075:
        if(--menux < 0)
            menux = MENU_NUMBER - 1;
        break;
    case 1077:
        if(++menux >= MENU_NUMBER)
            menux = 0;
        break;
    case 27:
        option = 0;
        goto updroot;
    case 13:
    case 1080:
        goto sous_menu;
    default:
        goto updroot;       /* donc escape */
    }

    goto rootloop;

sous_menu:
    column = menupar[MENU_NUMBER * 2 + menux] - 1;
    MWIDTH = max(menupar[menux], 10);
    nentry
    = menupar[MENU_NUMBER + menux];
    rootinv(menux, 1);

    l = (column << 3) - 1;
    r = l + (MWIDTH << 3) + 1;
    t = MENUROW + 18;
    b = t + ((nentry
              + 2) << 4) + 1;
    menuhold(l - 7, t, r, b);
    fastbar(column, t, column + MWIDTH - 1, b, MENUBAR);
    PENCOL = 0;
    for(menuy = 1; menuy <= nentry
            ; menuy++)
        writeonxy(l, t + (menuy << 4) , menutxt[TXT_POS]);
    rectangle18(l ,t, r, b, 0);

    menuy = 1;

ssmenuloop:
    menuinv(column, menuy, menutxt[TXT_POS], 1);

    if(MOUSE)
    {
smloop:
        mshow();
        while(!kbhit())
        {
            if(mclick())
            {
                release();
                num = testmenu(column, nentry
                              );
                if(num)
                {
                    menuy = num;
                    option = 13;
                    goto menu_m_skip;
                }
                num = testroot();
                if(num >= 0)
                {
                    smenuput(menux);
                    menux = num;
                    goto sous_menu;
                }
                option = -27;
                goto menu_m_skip;
            }
        }
    }

    option = get1000();

menu_m_skip:
    menuinv(column, menuy, menutxt[TXT_POS], 0);

parse:
    switch(option)
    {
    case 1072:
        if(--menuy < 1)
            menuy = nentry
                    ;
        break;
    case 1080:
        if(++menuy > nentry
          ) menuy = 1;
        break;
    case 1075:
        if(--menux < 0)
            menux = MENU_NUMBER - 1;
        smenuput(menux);
        goto sous_menu;
    case 1077:
        if(++menux >= MENU_NUMBER)
            menux = 0;
        smenuput(menux);
        goto sous_menu;
    case 27:
        smenuput(menux);
        goto rootloop;
    case -27:
        option = 0;
        goto upd;
    case 13:
        option = menukey[KEY_POS];
    default:
        goto upd;
    }

    goto ssmenuloop;


upd:
    smenuput(menux);
updroot:
    *retour = menux;
    return(option);
}



/****** MOUSE ROUTINES *******/

int testmenu(int column,int nentry
            )
{
    int l, u, b, r;

    l = (column << 3);
    r = l + (MWIDTH << 3) - 1;
    u = MENUROW + 18 + 16;
    b = u + (nentry
             << 4);

    if(mx >= l)
        if(mx <= r)
            if(my >= u)
                if(my <= b)
                    return( ((my - u) >> 4) + 1);

    return(0);
}


int testroot()
{
    register int u = MENUROW;
    register int w = MENUROOT_WIDTH * 8;
    int left;

    left = MENUROOT_START * 8 + 24;

    if(my >= u)
        if(my < (u + 17))
            if(mx > left)
                if(mx < (left + w * MENU_NUMBER))
                    return((mx - left) / w);
    return(-1);
}
