#include <io.h>
#include <stdlib.h>
#include <dos.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include "../gui/head.h"
#include "../gui/souris.h"
#include "../gui/vgalib.h"
#include "../gui/vga.h"
#include "../gui/texte.h"
#include "../gui/design.h"
#include "../gui/gets18.h"
#include "../gui/popwin.h"
#include "../gui/lift.h"
#include "listgui.h"


int WW = 80;
int WH = 30;
int WL = 0;
int WR = 79;
int WU = 0;
int WB = 29;
int WRI = 79;

char DIALOG_BAR = 1;
char DIALOG_BARCOL = 2;
char DIALOG_BACK = 7;
char DIALOG_BORDER = 7;
char DIALOG_KEYS = 1;

unsigned char WBACK=0;
unsigned char WCOL=7;

unsigned char T_WIN=1;
unsigned char B_WIN=7;
unsigned char P_WIN=0;

char PRESS=0;



void buttonslot(int l,int u,int r,int b)
{
    COLOR16 = 0;
    hline18(l+1,u,r-1);
    vline18(l,u+1,b-1);
    hline18(l+1,b,r-1);
    vline18(r,u+1,b-1);
}


/*
   Is mouse inside the rectangle?
*/

int testfield(int l,int t,int r,int b)
{
    int temp;
    if (t > b)
    {
        temp = t;
        t = b;
        b = temp;
    }

    if (mx < l)
        goto non;
    if (mx > r)
        goto non;
    if (my < t)
        goto non;
    if (my > b)
        goto non;

    return 1;

non:
    return 0;
}

/*
   Is mouse inside the title bar?
*/

int titleinside()
{
    int left;
    int right;
    int top;
    int bottom;

    left = WL * 8 + 22;
    right = (WR + 1) * 8 - 4;
    top = WU * 16 + 4;
    bottom = top + 22;

    if(mx < left)
        goto no;
    if(mx > right)
        goto no;
    if(my < top)
        goto no;
    if(my > bottom)
        goto no;

    return 1;

no:
    return 0;
}


int sysinside()
{
    int left;
    int right;
    int top;
    int bottom;

    left = WL * 8 + 4;
    right = left + 22;
    top = WU * 16 + 4;
    bottom = top + 22;

    if(mx < left)
        goto no;
    if(mx > right)
        goto no;
    if(my < top)
        goto no;
    if(my > bottom)
        goto no;

    return 1;

no:
    return 0;

}



int wininside()
{
    int x;
    int y;

    x = mx << 3;
    y = my << 4;

    if(x < WL)
        goto no;
    if(x > WR)
        goto no;
    if(y < WU)
        goto no;
    if(y > WB)
        goto no;

    return 1;

no:
    return 0;

}



void buttonsystem(int x, int y)
{
    mhide();
    bar18(x , y , x + 17 , y + 17, 7);

    /* le petit rectangle */
    rectangle18(x + 3, y + 8, x + 14, y + 10, 0);
    COLOR16 = 8;
    hline18( x + 4, y + 11, x + 15);
    vline18( x + 15, y + 9, y + 11);
    COLOR16 = 15;
    hline18( x + 4, y + 9, x + 13);

    COLOR16 = 0;
    vline18( x + 18, y , y + 18);
}


void wincolor(char b, char h, char p)
{
    B_WIN = b;
    T_WIN = h;
    P_WIN = p;
    WBACK = b;
    BACKCOL = b;
    WCOL = p;
    PENCOL = p;
}

unsigned char WINTITLE = 1;
unsigned char WINTITLE_COLOR = 0;
unsigned char MORE_RELIEF = 0;
unsigned char BUTTON_SYSTEM = 1;
unsigned char WINMOVE_FLAG = 0;     /* mettre les coins */

void wincreate(int lcol, int trow, int rcol, int brow, char *txt)
{
    int l, u, r, b;
    int toprelief;
    int lw;

    WL = lcol;
    WR = rcol;
    WU = trow;
    WB = brow;
    WW = rcol - lcol + 1;
    WH = brow - trow + 1;
    WRI = rcol;

    l = (lcol << 3);
    r = (rcol << 3) + 7;
    u = (trow << 4);
    b = (brow << 4) + 15;

    if(WINMOVE_FLAG)
        lw = l;
    else
        lw = l + 4;

    fastbar(lcol, u, rcol, b, B_WIN);

    if(WINTITLE)
    {
        toprelief = u + 23;
        COLOR16 = 0;
        hline18(lw, u + 22, r - 4);
        bar18( l + 4, u + 4,  r - 4, u + 21, T_WIN);

        PENCOL = WINTITLE_COLOR;
        writeonxy( (WL + 4) << 3, u + 6, txt);
        if(BUTTON_SYSTEM)
        {
            buttonsystem( l + 4, u + 4);
            COLOR16 = 0;
            vline18(l + 22, u + 4, u + 21);
        }
    }
    else
        toprelief = u + 4;

    if(MORE_RELIEF)
    {
        COLOR16 = min(15, B_WIN + 8);
        vline18(l + 4, toprelief, b - 4);
        hline18(l + 4, toprelief, r - 4);
    }

    rectangle18(l, u, r, b, 0);
    COLOR16 = 0;
    rectangle18(l + 3, u + 3, r - 3, b - 3, 0);

    if(WINMOVE_FLAG)
    {
        vline18(l + 22, u, u + 4);
        vline18(r - 20, b, b - 2);
        hline18(r - 3, b - 20, r);
    }

    WINTITLE = 1;
    WINTITLE_COLOR = 0;
    BUTTON_SYSTEM = 1;
    MORE_RELIEF = 0;
    WINMOVE_FLAG = 0;
}


void winboard(int HL, int HT, int HR, int HB, char color)
{
    int l,t,r,b;
    int bxl, bxr, byt, byb;

    WL = HL;
    WR = HR;
    WU = HT;
    WB = HB;
    WW = HR - HL + 1;
    WH = HB - HT + 1;
    WRI = HR;
    B_WIN = color;
    DIALOG_BACK = color;

    l = (HL << 3) + 2;
    r = (HR << 3) + 3;
    t = (HT << 4) + 4;
    b = (HB << 4) + 13;

    mhide();
    bar18(l, t, r, b, DIALOG_BORDER);

    COLOR16 = 15;
    vline18( l - 1, t , b + 1);
    hline18( l - 1, t - 1, r + 1);

    COLOR16 = 8;
    vline18( r + 1, t , b );
    hline18( l , b + 1, r + 1);

    rectangle18(l - 2, b + 2, r + 2, t - 2, 0);

    bxl = l + 2;
    bxr = r - 2;
    byt = t + 2;
    byb = b - 2;

    if(DIALOG_BACK != DIALOG_BORDER)
    {
        bar18(bxl, byt, bxr, byb, DIALOG_BACK);
        rectangle18(bxl, byt, bxr, byb, 0);
    }

    if(DIALOG_BAR)
    {
        bar18(bxl, byt, bxr, byt + 16, DIALOG_BARCOL);
        rectangle18(bxl,  byt, bxr, byt + 17, 0);
        if(DIALOG_KEYS)
        {
            keybar( bxr - 16,  byt + 1, 16);
            keydown(bxr - 34, byt + 1, 17);
        }
    }
    DIALOG_BAR = 1;
    DIALOG_BARCOL = 2;
    DIALOG_BACK = 7;
    DIALOG_BORDER = 7;
    DIALOG_KEYS = 1;
}


int WWSAV[8]={80};
int WHSAV[8]={30};
int WLSAV[8]={0};
int WRSAV[8]={79};
int WUSAV[8]={0};
int WBSAV[8]={29};
int WRISAV[8]={79};

int XLOCSAV[8]={1};
int YLOCSAV[8]={1};

int WBACKSAV[8]={0};
int WCOLSAV[8]={7};
int T_WINSAV[8]={0};
int B_WINSAV[8]={0};

/*
   Locate mouse in multiple windows
*/

int whichwin(int no)
{
    int AX = WLSAV[no] << 3;
    int DX = (WBSAV[no] + 1) << 4;
    int SI = (WRSAV[no] + 1) << 3;
    int DI = WUSAV[no] << 4;

    if(mx < AX)
        return(0);
    if(mx >= SI)
        return(0);

    if(my < DI)
        return(0);
    if(my >= DX)
        return(0);

    if(mx < (AX + 1))
        return(4);
    if(mx > (SI - 4))
        return(5);

    if(my < (DI + 4))
        return(4);
    if(my < (DX - 4))
        return(0);

    return(1);
}


void wintextcol(int b, int t)
{
    WBACK = b;
    BACKCOL = b;

    WCOL = t;
    PENCOL = t;
}

void winsave(int no)
{
    WWSAV[no]=WW;
    WHSAV[no]=WH;
    WLSAV[no]=WL;
    WRSAV[no]=WR;
    WUSAV[no]=WU;
    WBSAV[no]=WB;
    WRISAV[no]=WRI;

    XLOCSAV[no]=XLOC;
    YLOCSAV[no]=YLOC;

    WBACKSAV[no]=WBACK;
    WCOLSAV[no]=WCOL;
    T_WINSAV[no]=T_WIN;
    B_WINSAV[no]=B_WIN;
}

void winopen(int no)
{
    WW = WWSAV[no];
    WH = WHSAV[no];
    WL = WLSAV[no];
    WR = WRSAV[no];
    WU = WUSAV[no];
    WB = WBSAV[no];
    WRI = WRSAV[no];

    XLOC = XLOCSAV[no];
    YLOC = YLOCSAV[no];

    WBACK = WBACKSAV[no];
    WCOL = WCOLSAV[no];
    T_WIN = T_WINSAV[no];
    B_WIN = B_WINSAV[no];
    BACKCOL = WBACK;
    PENCOL = WCOL;
}



void winwrite18(int co, int li, char *txt)
{
    int l;
    char savecar;
    int lcol, rcol;

    lcol = WL + co + 1;
    rcol = WRI - lcol;

    l = strlen(txt);
    if(rcol < l)
        l = rcol;

    savecar = txt[l];
    txt[l] = '\0';
    BACKCOL = WBACK;
    PENCOL = WCOL;
    write18( lcol, li + WU + 1, txt);
    txt[l] = savecar;
}


void winwritef18(int c, int l, char *fmt, ... )
{
    va_list argptr;
    char STRBUF[256];

    argptr = ...;
    vsprintf((char *) STRBUF, fmt, argptr);
    winwrite18(c, l, (char *) STRBUF);
}




int testborder(int old)
{
    int res;

    int left = WL << 3;
    int right = (WR + 1) << 3;
    int top = WU << 4;
    int bottom = (WB + 1) << 4;

    if(mx < left)
        goto no;
    if(mx >= right)
        goto no;
    if(my >= bottom)
        goto no;
    if(my < top)
        goto no;

    res = MOUSE_LEFT;
    if(mx <= (left + 4))
        goto yes;

    res = MOUSE_RIGHT;
    if(mx >= (right - 4))
        goto yes;

    res = MOUSE_UP;
    if(my <= (top + 4))
        goto yes;

    res = MOUSE_DOWN;
    if(my >= (bottom + 4))
        goto yes;

no:
    res = old;
yes:
    return(res);

}


/*
   Is the mouse over a corner?
   Entry: flag, is 0, exit
*/

int testcorner(int old)
{
    int res = old;
    int left;
    int right;
    int top;
    int bottom;

    if (old == 0)
        goto yes;

    left = (WL << 3) + 20;
    right = (WR << 3) - 12;
    top = (WU << 4) + 20;
    bottom = (WB << 4) - 4;

    if(old != MOUSE_UP)
        goto toleft;

    res = MOUSE_NW;
    if(mx < left)
        goto yes;
    goto no;

toleft:
    if(old != MOUSE_LEFT)
        goto toright;

    res = MOUSE_NW;
    if(my < top)
        goto yes;
    goto no;

toright:
    if(old != MOUSE_RIGHT)
        goto todown;

    res = MOUSE_SE;
    if(my >= bottom)
        goto yes;
    goto no;

todown:
    if(old != MOUSE_DOWN)
        goto yes;
    res = MOUSE_SE;
    if(mx >= right)
        goto yes;

no:
    res = old;
yes:
    return (res);
}





void winset(int l, int u, int r, int b)
{
    WL = l;
    WU = u;
    WR = r;
    WB = b;
    WW = r - l + 1;
    WH = b - u + 1;
    WRI = r;
}


int XWIN;
int YWIN;

void winbacksave(int l, int t, int r, int b)
{
    l = (l << 3);            /* moins une colonne */
    t = 479 - (t << 4);
    r = (r << 3) + 7;            /* plus une colonne */
    b = 479 - ((b << 4) + 15);
    if(r < 639)
        r++;

    XWIN = l;
    YWIN = b;
    mhide();
    getBPsprite(l, t, r, b, BOXBUF);
}

void winbackhold()
{
    winbacksave(WL, WU, WR, WB);
}

void winbackput()
{
    mhide();
    release();
    fastBPsprite(XWIN, YWIN, BOXBUF);
}


void winlocate(int col,int row)
{
    locate(WL + col + 1, WU + row + 1);
}


void wincenter(int y, char *txt)
{
    winwrite18((WW - strlen(txt)) >> 1, y, txt);
}


