
/*
   Variables for window limits
   These variables are set when a window is made with the wincreate()
   function. They are saved by the winsave functions, restored by winopen.
*/


extern int WL;
extern int WR;
extern int WU;
extern int WB;
extern int WW;
extern int WH;
extern int WRI;


extern unsigned char WBACK;  /* Background writing color in windows*/
extern unsigned char WCOL;   /* Text color in windows              */
extern unsigned char T_WIN;  /* Window title bar color             */
extern unsigned char B_WIN;  /* Window background color            */
extern unsigned char P_WIN;  /* Color of text in a background */
extern char DIALOG_BAR;      /* Bar on dialog box */
extern char DIALOG_BARCOL;   /* Color of this bar */
extern char DIALOG_BACK;     /* Color of middle of box */
extern char DIALOG_BORDER;   /* Border of dialog box */
extern char DIALOG_KEYS;     /* Keys on title bar */

/* internal variables */
extern char PRESS;


/*
  WINTEXTCOL
  Set color for background and text
  Change WBACK, WCOL, BACKCOL, PENCOL
*/

void wintextcol(int b,int t);

/*
   WINWRITE18
   Write a string, coordinate inside window
   Use WBACK, WCOL
*/

void winwrite18(int co, int li, char *txt);

/*
   WINWRITE18
   Write a formatted string (as printf), coordinate inside window
   Use WBACK, WCOL
*/

void winwritef18(int c, int l, char *fmt, ...);


/*
   GETCADRE
   Draw a frame for string input
*/

void getcadre(int col,int line,int ll);


/*
   TESTFIELD
   Test if mouse (mx, my) inside the field
   Output: 1 if true, 0 else
*/


int testfield(int l,int t,int r,int b);

/*
   TITLEINSIDE
   Return 1 if mouse on the title bar, 0 otherwise
*/

int titleinside();


/*
   SYSINSIDE
   Return 1 if mouse on the system button, 0 otherwise
*/

int sysinside();

/*
  WININSIDE
  Return 1 if mouse inside the window, 0 otherwise.
  mx and my must be set by a call to mpos() or mclick
  The wincreate() or winopen() functions define the window limits
*/

int wininside();


void buttonslot(int l,int u,int r,int b); /* internal sub-routine */

void buttonsystem(int x, int y);  /* internal sub-routine */

/*
   WINCOLOR
   Set window background, title bar, pen color
   Change: B_WIN, T_WIN, P_WIN,
	   WBACK, WCOL,
	   BACKCOL, PENCOL
*/

void wincolor(char b,char h, char p);


extern unsigned char WINTITLE;         /* set to 1 for title bar */
extern unsigned char WINTITLE_COLOR;   /* set title bar text color */
extern unsigned char MORE_RELIEF;      /* set to 1 for more 3D */
extern unsigned char BUTTON_SYSTEM;    /* set to 1 for a system button */
extern unsigned char WINMOVE_FLAG;     /* set to 1 for corners */

/*
   WINCREATE
   Open and draw a window
   Uses but resets all settings above.
   Change limits WL and so one...
*/

void wincreate(int lcol, int trow, int rcol, int brow, char *txt);


/*
   WINBOARD
   Draw a box
   Change limits WL and so one...
*/

void winboard(int HL,int HT,int HR,int HB,char color);

/*
   WHICHWIN
   Return the window number mouse is clicked inside
*/

int whichwin(int no);

/*
   WINSAVE
   Save settings (limits) of current window
   Until 8 windows may be saved, therefore no = 0..7
*/


void winsave(int no);

/*
  WINOPEN
  Set limits for window number no
  no = 0..7
*/


void winopen(int no);

int testcorner(int);
int testborder(int);
void winbacksave(int l, int t, int r, int b);
void winbackhold();
void winbackput();
void winlocate(int col,int row);
void wincenter(int y, char *txt);

