#include <stdlib.h>
#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>

#include "../gui/head.h"
#include "../gui/texte.h"
#include "../gui/design.h"
#include "../gui/popwin.h"
#include "../gui/message.h"
#include "../gui/souris.h"
#include "../gui/gostop.h"
#include "../gui/gets18.h"
#include "../gui/alt.h"
#include "../gui/print.h"


#define CODE_UNDERLINE 21
#define CODE_NEXTPAGE 12

static FILE *file_point;      /* pointer to file to be read */
static FILE *PP;              /* pointer to printer */

#define LINEMAX 257

int PRINT_LINES   = 66;          /* maximum number of lines per page */
int PRINT_COLUMNS = 76;
int PRINT_TOP     = 2;
int PRINT_LEFT    = 2;

char PRINT_HEADER = 1;
char PRINT_WAIT = 1;
char PRINT_FILE[81];
char PRINTER_TYPE[13] = "PRN";

int HEADER_LEFT = 2;
int HEADER_BOTTOM = 2;
char HEADER_TITLE = 0;
char HEADER_DOC = 1;
char HEADER_PAGES = 1;
char HEADER_FIRST = 0;
char HEADER_CENTERED = 1;


char TO_PRINTER = 1;
int PAGE_NUMBER = 1;          /* page number initialized to one */
int PAGE_PRINTED = 1;
int ligne_de_page = 0;        /* lines on this page so far */

char TITLE[81];

int next_page(int);
int Header(int);

/* PRINTER STATUS if ready return 0x90: Powered on, Selected, Not Busy */

unsigned char printer_status()
{
    union REGS regs;

    regs.h.ah = 2;     /* request printer status */
    regs.x.dx = 0;     /* printer (0-2) */
    int86(0x17, &regs, &regs);
    return(regs.h.ah);
}


int printer_ready()
{
    if(TO_PRINTER == 0)
        return(1);
    if(printer_status() == 0x90)
        return(1);
    else
        box("Printer not ready");
    return(0);
}

/* This routine prints an ASCII Form-Feed character. */

void paper_advance()
{
    union REGS regs;

    if(printer_ready())
    {
        regs.h.ah = 0;      /* imprime */
        regs.h.al = 12;     /* code form feed */
        regs.x.dx = 0;      /* printer number (0-2) */
        int86(0x17, &regs, &regs);
        if(regs.h.ah & 1)
            goto PRINT_DONE;  /* time out ? */

        regs.h.ah = 0;
        regs.h.al = 13;     /* finir avec CR */
        int86(0x17, &regs, &regs);
    }

PRINT_DONE:
    return;
}


int WaitPage()
{
    int r;

    if(PRINT_WAIT)
    {
        r = answer(box("Insert the %d page, please", PAGE_PRINTED));
    }
    else
        r = 13;

    return(r);
}

void printchar(char c)
{
    if(c == 13)
        return;
    fputc(c, PP);
    return;
}

void nextline()
{
    fputc('\n', PP);
}

int next_page(int incr)
{
    int index;

    for(index = ligne_de_page; index <= PRINT_LINES; index++)
        nextline();
    ligne_de_page = 0;
    PAGE_NUMBER += incr;
    PAGE_PRINTED++;
    return(WaitPage());
}



/* MAKE FILE PRINT Cration du nom pour l'en-tte pour Header */

void make_file_print(char *name)
{
    char c;

    strcpy(PRINT_FILE, name);
    c = PRINT_FILE[0];
    if(islower(c))
        PRINT_FILE[0] = _toupper(c);
}


int askprint(char *text)
{
    int col, colr, lin, linb;
    int ch;

    TO_PRINTER = (
                     !stricmp(PRINTER_TYPE, "PRN") ||
                     !stricmp(PRINTER_TYPE, "LPT1") ||
                     !stricmp(PRINTER_TYPE, "LPT2")
                 );

    if(!printer_ready() )
        return(0);

    DIALOG_BAR = 1;
    DIALOG_BARCOL = 3;
    DIALOG_BACK = 7;
    DIALOG_KEYS = 0;

    col =  20;
    colr = 60;
    lin =  10;
    linb = 15;

    mhide();
    winbacksave(col, lin, colr, linb);
    wincolor(7, 4, 0);
    winboard(col, lin, colr, linb, 7);
    writeonxy(22 << 3, (10 << 4) + 7, "Printing");
    winwritef18(2, 3, "DOCUMENT: %-s", text);

    go_key(  33, 3);
    stop_key(26, 3);

getloop:
    if(MOUSE)
    {
        mshow();
mloop:
        while(!kbhit())
        {
            if(mclick())
            {
                if(test_go())
                {
                    ch = ENTER;
                    goto parse;
                }
                if(test_stop())
                {
                    ch = ESCAPE;
                    goto parse;
                }
                if(wininside())
                    goto mloop;
                ch = ESCAPE;
                goto parse;
            }
        }
    }

    ch = get1000();

parse:
    mhide();
    if(ch != ESCAPE && ch != ENTER)
        goto getloop;

exit:
    winbackput();
    return(ch == 13);
}



/* teste si Header  imprimer, fin de page et avance papier */


int print_Header_sub()
{
    char headertext[256];
    char pagetext[6];
    int i;
    int l;

    *headertext = 0;

    strcat((char *) headertext, PRINT_FILE);

    strcat((char *) headertext, " Page ");
    itoa(PAGE_PRINTED, (char *) pagetext, 10);
    strcat((char *) headertext, pagetext);

    l = strlen((char *) headertext);

    i = PRINT_LEFT;
    l += i;
    while(i)
    {
        printchar(' ');
        i--;
    }
    fprintf(PP, "%s", headertext);
    ligne_de_page++;

    return(l);
}


int Header(int incr)
{
    int i;
    int ret;

    /* bas de page? */

    ret = 0;

    if(ligne_de_page > PRINT_LINES)
    {
        if(next_page(incr) == 27)
            return(27);
        ret = 13;
    }

    /* place le Header */

    if(ligne_de_page == 0)
    {
        i = PRINT_TOP;
        while(i)
        {
            nextline();
            i--;
        }
        if(PRINT_HEADER && ((PAGE_NUMBER > 1) || HEADER_FIRST))
        {
            print_Header_sub();
            i = HEADER_BOTTOM + 1;
            ligne_de_page = i;
            while(i--)
                nextline();
        }
    }

    return(ret);
}


/* imprime une ligne */

int print_a_line(char *oneline)
{
    int index;
    int length;
    int ctr;
    char c;


    length = strlen(oneline);
    if(length)
    {
        if(oneline[length-1] == 10)
            length--;
        if(oneline[length-1] == 13)
            length--;
    }

    if(!length)
    {
        nextline();
        goto finish;
    }

    ctr = PRINT_LEFT;
    while(ctr)
    {
        ctr--;
        printchar(' ');
    }

    ctr = 0;
    for(index = 0; index < length; index++)
    {
        c = oneline[index];
        if(c == CODE_NEXTPAGE)
        {
            if(next_page(1) == 27)
                return(27);
            if(Header(1) == 27)
                return(27);
            goto nextchar;
        }

        if(c == CODE_UNDERLINE)
            goto nextchar;
        if(c == '\n')
        {
            ligne_de_page++;
            ctr = 0;
        }
        else
            if(ctr == PRINT_COLUMNS)
            {
                nextline();
                ctr = 0;
                ligne_de_page++;
            }

        printchar(c);

nextchar:
        ctr++;
    }

    length = max(0, length - 1);
    if(oneline[length] != '\n')
        nextline();

finish:
    ligne_de_page++;
    return(13);
}

/* PRINTER  fdest = PRN ou fichier */

void print_file(char *name)
{
    char *c;
    char oneline[LINEMAX];

    if(!askprint(name))
        return;

    make_file_print(name);

    PAGE_NUMBER = 1;
    ligne_de_page = 0;

    file_point = fopen(name, "r");
    if(file_point != NULL)
    {
        PP = fopen(PRINTER_TYPE, "w");
        do
        {
            c = fgets(oneline, LINEMAX, file_point);
            if (c != NULL)
            {
                if(Header(1) == 27)
                    goto fini;
                if(print_a_line(oneline) == 27)
                    goto fini;
            }
        }
        while (c != NULL);

fini:
        fclose(PP);
        fclose(file_point);
    }
    else
        box("Enable to open");
}

