
#include "../gui/vgalib.h"

/*
   VGA Library
   Set of BIOS or VGA card calls
   Ensemble de fonctions qui font appel au BIOS ou la carte VGA
*/

/*
   BIOSscreen
   Get and set the screen mode
    Input:   new mode
    Output:  previous mode
 
   Lit et change le mode ecran
    Entree:   nouveau mode
    Sortie:   mode precedent
 
   Modes: 18  640 x 480 x 16
          19  320 x 200 x 256
           3  Text color
           0  Read only, no change
   Add 128 to mode to screen not cleared
*/

int BIOSscreen(int mode)
{
    asm     mov     ah, 15
    asm     int     0x10
    asm     mov     dl, al
    asm     mov     al, mode
    asm     test    al, al
    asm     je      bye
    asm     mov     ah,0
    asm     int     0x10
bye:
    asm     mov     al, dl
    asm	 xor     ah, ah
}


/*
   BIOSborder
   Set the screen border color
   Change la couleur du bord de l'cran
*/

void BIOSborder(char color)
{
    asm mov al,1
    asm mov ah,010h
    asm mov bl,0
    asm mov bh,color
    asm int 010h
}

/*
   WRITEMODE
   Set a logical write mode for sprite or drawing
   Dfinit un mode logique de sprite ou trace
   Modes:
     0    COPY
    24    XOR
*/

void writemode(int mode)
{
    asm mov dx, 03CEh
    asm mov ax, mode
    asm mov ah, al
    asm mov al, 3
    asm out dx, ax
}

/*
   WAITREFRESH
   Wait for a screen refresh
   Attente du rafraichissement de l'cran
*/

void waitrefresh()
{
    asm mov dx,3dah
loop1:
    asm in al,dx
    asm test al,8
    asm jne loop1
loop2:
    asm in al,dx
    asm test al,8
    asm je loop2
}


/*
   SetRGB
   Set the 3 red, green, blue components for a color value
   Definit les 3 composantes rouge, vert, bleu d'une valeur de couleur
*/

void setRGB(char creg, char r, char g, char b)
{
    asm mov dx,3c8h
    asm mov al,creg
    asm out dx,al
    asm inc dx
    asm mov al,r
    asm out dx,al
    asm mov al,g
    asm out dx,al
    asm mov al,b
    asm out dx,al
}


/*
   BIOScolor
   Set value to a color number
   Affecte une valeur a un numero de couleur
*/

void BIOScolor(int col,int reg)
{
    asm mov ax,reg
    asm mov bh,al
    asm mov ax,col
    asm mov bl,al
    asm mov ah,010h
    asm mov al,0
    asm int 010h
}

/*
   Getcolor
   Get value of a color number
   Retourne la valeur d'un numero de couleur
*/

unsigned char getcolor(unsigned char color)
{
    asm mov ah,10h
    asm mov al,7
    asm mov bx, color
    asm int 010h
    asm mov al,bh
    asm xor ah, ah
}



