<?php
include_once("path.php");
include_once("dirlist.php");
include_once("strtools.php");
include_once("dom.php");
$VERSION="Propagator 1.0 - Scriptol.com";
$extensions=array("htm","html","php","php3","php4","php5","php6","xhtml","dhtml","asp");
$dirtools=new DirList();
$stringtools=new StrTools();
define("FACTOR",1024);
$QUIET=false;
$VERBOSE=false;
$DEBUG=false;
$RECURSE=false;
$DELTAG=false;
$INSTAG=false;
$ATSTART=false;
$HEADTAG=false;
$SEEONLY=false;
$WITHPHP=false;
$MINSIZE=1024;
define("PADLEFT",STR_PAD_LEFT);
$SOURCE=null;
$IDENTIFIER="";
$TAGNAME="";
$CURRPAGE="";
$SOURCEFILE="";
$SOURCEDIR="";
$MODE=0;
$TOTAL=0;
$DIRCOUNT=0;
$COUNTER=0;
$pattern="";
$searching="";
$replacing="";
function syntax()
{
   echo "\n";
   global $VERSION;
   echo $VERSION, "\n";
   echo "Copy a tag with an ID from a file into the whole website.", "\n";
   echo "Syntax:   solp propag [options] ID sourcefile", "\n";
   echo "    or:   php propag.php etc...", "\n";
   echo "Options:", "\n";
   echo "  -h       inside head (default inside body).", "\n";
   echo "  -b       at start of the container tag (default at end).", "\n";
   echo "  -d       delete (default add or update).", "\n";
   echo "  -i       iterate only, do not recurse subdirectories.", "\n";
   echo "  -p       include pages with PHP inside, at your own risks.", "\n";
   echo "  -q       quiet, don't display actions and results.", "\n";
   echo "  -v       verbose, display all parsed files.", "\n";
   echo "  -0..9    digit from 1 to 9, min size for a page to process in kb.", "\n";
   echo "  -t       test, see what will be done and stop before any change.", "\n";
   echo "Multiple options in a string, -hiq8 for example", "\n";
   exit();
   return;
}

function dirplural($count)
{
   if($count>1)
   {
      return "ies";
   }
   return "y";
}

function heading($name)
{
   global $RECURSE;
   if($RECURSE)
   {
      return getcwd()."/".$name;
   }
   return $name;
}

function isHTML($fname)
{
   $size=intVal(filesize($fname));
   if($size===0)
   {
      echo "Error, $currpath is empty.", "\n";
      return false;
   }
   global $MINSIZE;
   if($size<$MINSIZE)
   {
      global $QUIET;
      if(!$QUIET)
      {
         echo "Skipped short file $fname", "\n";
      }
      return false;
   }
   $content=file_get_contents($fname);
   $mask="/<body/i";
   if(preg_match($mask,$content)===0)
   {
      return false;
   }
   global $WITHPHP;
   if($WITHPHP)
   {
      return true;
   }
   $mask="/<.php/i";
   if(preg_match($mask,$content)>0)
   {
      global $QUIET;
      if(!$QUIET)
      {
         echo "Skipped PHP inside $fname", "\n";
      }
      return false;
   }
   return true;
}

function getSource($filename)
{
   $page=new DOMDocument();
   $page->loadHTMLFile($filename);
   $id=false;
   $element=null;
   $found=false;
   global $VERBOSE;
   if($VERBOSE)
   {
      global $IDENTIFIER;
      echo "Searching \"",$IDENTIFIER,"\" in ",$filename,"\n";
   }
   if(!file_exists($filename))
   {
      die("$filename not found");
   }
   global $SOURCE;
   global $IDENTIFIER;
   $SOURCE=$page->getElementById($IDENTIFIER);
   if($SOURCE===null)
   {
      die("Identifier \"$IDENTIFIER\" not found in source");
   }
   if($VERBOSE)
   {
      echo "Found \"",$IDENTIFIER,"\" in a ",$SOURCE->nodeName," tag.\n";
   }
   if($SOURCE->textContent==="")
   {
      die("Source empty.");
   }
   global $DEBUG;
   if($DEBUG)
   {
      echo "Propagating", "\n";
      echo $SOURCE->textContent, "\n";
   }
   global $COUNTER;
   return intVal($COUNTER);
}

function deleting($currpath)
{
   global $DEBUG;
   if($DEBUG)
   {
      echo "Cleaning", " ", $currpath, "\n";
   }
   $page=new DOMDocument();
   global $CURRPAGE;
   if(!$page->loadHTMLFile($CURRPAGE))
   {
      global $QUIET;
      if(!$QUIET)
      {
         echo "Skipped", " ", $currpath, "\n";
      }
      return false;
   }
   global $IDENTIFIER;
   $dn=$page->getElementById($IDENTIFIER);
   if($dn===null)
   {
      global $QUIET;
      if(!$QUIET)
      {
         echo "Skipped", " ", $currpath, "\n";
      }
      return false;
   }
   $parent=$dn->parentNode;
   if($dn===false)
   {
      return false;
   }
   $parent->removeChild($dn);
   global $QUIET;
   if(!$QUIET)
   {
      echo "Deleted $IDENTIFIER in $currpath", "\n";
   }
   global $SEEONLY;
   if($SEEONLY)
   {
      return true;
   }
   $page->saveHTMLFile($CURRPAGE);
   return true;
}

function adding($page,$currpath)
{
   global $CURRPAGE;   
   global $SOURCE;   
   global $DEBUG;
   if($DEBUG)
   {
      echo "Adding to", " ", $currpath, "\n";
   }
   global $TAGNAME;
   $dnl=$page->getElementsByTagName($TAGNAME);
   if($dnl->length===0)
   {
      global $QUIET;
      if(!$QUIET)
      {
         echo "Skipped no $TAGNAME in $currpath.", "\n";
      }
      return false;
   }
   $dn=$dnl->item(0);
   global $SOURCE;
   $newnode=$page->importNode($SOURCE,true);

   global $ATSTART;
   if($ATSTART)
   {
      $dn->insertBefore($newnode,$dn->firstChild);
   }
   else
   {
      $dn->appendChild($newnode);
   }
   global $QUIET;
   if(!$QUIET)
   {
      echo "Added to $currpath", "\n";
   }
   global $SEEONLY;
   if($SEEONLY)
   {
      return true;
   }
   $page->saveHTMLFile($CURRPAGE);
   return true;
}

function updating($currpath)
{
   global $CURRPAGE;   
   $page=new DOMDocument();
   global $CURRPAGE;
   if(!$page->loadHTMLFile($CURRPAGE))
   {
      global $QUIET;
      if(!$QUIET)
      {
         echo "Enable to load", " ", $currpath, "\n";
      }
      return false;
   }
   global $IDENTIFIER;
   $dn=$page->getElementById($IDENTIFIER);
   if($dn===null)
   {
      return adding($page,$currpath);
   }
   global $DEBUG;
   if($DEBUG)
   {
      echo "Updating", " ", $currpath, "\n";
   }
   global $SOURCE;
   $newnode=$page->importNode($SOURCE,true);
   $parent=$dn->parentNode;
   $parent->replaceChild($newnode,$dn);
   global $QUIET;
   if(!$QUIET)
   {
      echo "Updated $currpath", "\n";
   }
   global $SEEONLY;
   if($SEEONLY)
   {
      return true;
   }
   $page->saveHTMLFile($CURRPAGE);
   return true;
}

function scanning($thedir)
{
   $dirarray=array();
   $filename="";
   $dirname="";
   $node="";
   $ext="";
   $here=getcwd();
   global $VERBOSE;
   if($VERBOSE)
   {
      echo str_repeat('-',4), " ", $here, " ", str_repeat('-',56-strlen($here)), "\n";
   }
   $handle=opendir(".");
   if($handle===false)
   {
      echo "Error, enable to read $here", "\n";
   }
   rewinddir($handle);
   do
   {
         $filename=readdir($handle);

         if($filename ==false)
         {
            break;
         }
         if(in_array($filename,array(".","..")))
         {
            continue;
         }
         if(Path::isFile($filename))
         {
            global $SOURCEDIR;
            if($thedir===$SOURCEDIR)
            {
               global $SOURCEFILE;
               if($filename===$SOURCEFILE)
               {
                  continue;
               }
            }
            $_I1=Path::splitExt($filename);
            $node=reset($_I1);
            $ext=next($_I1);
            global $extensions;
            if(!in_array($ext,$extensions))
            {
               continue;
            }
            global $CURRPAGE;
            $CURRPAGE=$filename;
            $currpath=Path::merge($thedir,$filename);
            if(!isHTML($CURRPAGE))
            {
               continue;
            }
            global $TOTAL;
            $TOTAL+=1;
            global $MODE;
            
            if($MODE===1)
            {
               if(deleting($currpath))
               {
                  global $COUNTER;
                  $COUNTER+=1;
               }
            }
            else
            {
               if(updating($currpath))
               {
                  global $COUNTER;
                  $COUNTER+=1;
               }
            }
            
         }
   }
   while(true);
   global $RECURSE;
   if($RECURSE===false)
   {
      closedir($handle);
      return;
   }
   rewinddir($handle);
   do
   {
         $dirname=readdir($handle);
         if($dirname ==false)
         {
            break;
         }
         if(in_array($dirname,array(".","..")))
         {
            continue;
         }
         if(Path::isDir($dirname))
         {
            global $DIRCOUNT;
            $DIRCOUNT+=1;
            chdir($dirname);
            scanning(Path::merge($thedir,$dirname));
            chdir("..");
         }
   }
   while(true);
   closedir($handle);
   return;
}

function main($argnum,$arglist)
{
   if(count($arglist)<2)
   {
      syntax();
   }
   $thisdir=getcwd();
   global $QUIET;
   $QUIET=false;
   global $RECURSE;
   $RECURSE=true;
   global $VERBOSE;
   $VERBOSE=false;
   global $MINSIZE;
   $MINSIZE=1024;
   global $MODE;
   $MODE=0;
   global $TAGNAME;
   $TAGNAME="body";

   $optstr=$arglist[1];
   $optchr=$optstr{0};
   array_shift($arglist);
   while(($optchr==='-')||($optchr==='/'))
   {
      do
      {
         $opt=substr($optstr,1);
         $_L3=strlen($opt);
         for($__3 = 0; $__3 < $_L3; $__3++)
         {
            $i=$opt{$__3};
            
            if($i==='h')
            {
               global $HEADTAG;
               $HEADTAG=true;
               $TAGNAME="head";
            }
            else
            {
               if($i==='b')
               {
                  global $ATSTART;
                  $ATSTART=true;
               }
            else
            {
               if($i==='d')
               {
                  $MODE=1;
               }
            else
            {
               if($i==='i')
               {
                  $RECURSE=false;
               }
            else
            {
               if($i==='q')
               {
                  $QUIET=true;
                  $VERBOSE=false;
               }
            else
            {
               if($i==='v')
               {
                  $VERBOSE=true;
                  $QUIET=false;
               }
            else
            {
               if($i==='t')
               {
                  global $SEEONLY;
                  $SEEONLY=true;
               }
            else
            {
               if($i==='p')
               {
                  global $WITHPHP;
                  $WITHPHP=true;
               }
            else
            {
               if($i==='g')
               {
                  global $DEBUG;
                  $DEBUG=true;
                  $VERBOSE=true;
               }
            else
            {
               if(($i>=0&&$i<=9))
               {
                  global $FACTOR;
                  $MINSIZE=intval($i)*FACTOR;
               }
            else
            {
               echo $i, " ", "bad option", "\n";
               syntax();
            }
            }}}}}}}}}
         }
         array_shift($arglist);
         $optstr=$arglist[0];
         $optchr=$optstr{0};
      } while(false);
   }
   echo "\n";
   global $VERSION;
   echo $VERSION, "\n";
   if(count($arglist)<2)
   {
      die("Argument missing, identifier and source filename required. Stopped.");
   }
   global $IDENTIFIER;
   $IDENTIFIER=$arglist[0];
   global $SOURCEFILE;
   $SOURCEFILE=$arglist[1];
   $TARGETFILE="";
   if(count($arglist)===3)
   {
      $TARGETFILE=$arglist[2];
   }
   global $SEEONLY;
   if($VERBOSE||$SEEONLY)
   {
      echo "Processing from $SOURCEFILE", "\n";
      if($RECURSE)
      {
         echo "recursively subdirectories.", "\n";
      }
      else
      {
         echo "only the source directory.", "\n";
      }
      echo "When page size is $MINSIZE or more, ";
      if($MODE===1)
      {
         echo "delete ";
      }
      else
      {
         echo "update or add ";
      }
      echo "\"$IDENTIFIER\" tag ";
      global $ATSTART;
      if($ATSTART)
      {
         echo "at start";
      }
      else
      {
         echo "at end";
      }
      echo " of $TAGNAME.", "\n";
      echo "Parsing ";
      if($SEEONLY)
      {
         echo "Test mode, changes are not saved as of -t option.", "\n";
      }
      if($VERBOSE)
      {
         echo "Verbose mode.", "\n";
      }
      if($QUIET)
      {
         echo "Quiet mode.", "\n";
      }
   }
   getSource($SOURCEFILE);
   $location="";
   $filename="";
   $_I2=Path::splitFile($SOURCEFILE);
   $location=reset($_I2);
   $filename=next($_I2);
   echo "location=", " ", $location, " ", "in", " ", $SOURCEFILE, "\n";
   if($TARGETFILE!=false)
   {
      $location=$TARGETFILE;
      $filename="";
   }
   chdir($location);
   if($VERBOSE)
   {
      echo "Moving to directory", " ", getcwd(), "\n";
   }
   $SOURCEFILE=$filename;
   global $SOURCEDIR;
   $SOURCEDIR=$TARGETFILE;
   scanning($TARGETFILE);
   chdir($thisdir);
   if($VERBOSE)
   {
      echo str_repeat('-',60), "\n";
   }
   global $TOTAL;
   $x=($TOTAL>1?"s":"");
   global $DIRCOUNT;
   $y=dirplural($DIRCOUNT);
   global $COUNTER;
   $z=(intVal($COUNTER)>1?"s":"");
   echo $TOTAL, " ", "file$x updated in $DIRCOUNT director$y, $COUNTER tag$z updated.", "\n";
   return 0;
}

main(intVal($argc),$argv);

?>
