<?php
include_once("path.php");
include_once("dirlist.php");
include_once("pattern.php");
include_once("strtools.php");
$dirtools=new DirList();
$stringtools=new StrTools();
$TEXTCASE=false;
$QUIET=false;
$FILECASE=false;
$PURETEXT=true;
$RECURSE=false;
$VERBOSE=false;
define("PADLEFT",STR_PAD_LEFT);
$TOTAL=0;
$MATCHES=0;
$COUNTER=0;
$pattern="";
$searching="";
$replacing="";
function syntax()
{
   echo "Search and replace  1.4 - www.scriptol.com.", "\n";
   echo "Syntax:   search [option] search-string [replacing-string] file.", "\n";
   echo "    or:   search [option] search-string [replacing-string] pattern.", "\n";
   echo "    or:   php -q search.php etc...", "\n";
   echo "Options:", "\n";
   echo "  -i   ignore case for strings (default case-sensitive).", "\n";
   echo "  -c   search identifiers inside code (default string in text).", "\n";
   echo "  -u   unix style, filename case sensitive (default ignore case).", "\n";
   echo "  -q   quiet, don't display matches (default display).", "\n";
   echo "  -r   recursively scan subdirectories.", "\n";
   echo "  -v   verbose, display more infos.", "\n";
   echo "  -icurv is the format for multiple options", "\n";
   exit();
   return;
}

function heading($name)
{
   global $RECURSE;
   if($RECURSE)
   {
      return getcwd()."/".$name;
   }
   return $name;
}

function replace($line)
{
   global $searching;
   $sealen=strlen($searching);
   global $replacing;
   $replen=strlen($replacing);
   $linelen=strlen($line);
   global $TEXTCASE;
   if($TEXTCASE===false)
   {
      $searching=strtolower($searching);
      $line=strtolower($line);
   }
   $idx=0;
   $idr="";
   while(($idx+$sealen)<$linelen)
   {
      do
      {
         $idx=strpos($line,$searching,$idx);
         if($idx===false)
         {
            break 2;
         }
         if($idx===0)
         {
            $line=$replacing.substr($line,$idx+$sealen);
         }
         else
         {
            $line=substr($line,0,$idx).$replacing.substr($line,$idx+$sealen);
         }
         $idx+=intVal($replen);
         $linelen=strlen($line);
         global $COUNTER;
         $COUNTER+=1;
      } while(false);
   }
   return $line;
}

function openfile($filename,$mode)
{
   $f=0;
   $error=($f=fopen($filename,$mode));
   if($error===false)
   {
      echo "Enable to open ", " ", $filename, "\n";
      return false;
   }
   return $f;
}

function replacefile($srcname,$dstname)
{
   $node="";
   $ext="";
   $_I1=Path::splitExt($srcname);
   $node=reset($_I1);
   $ext=next($_I1);
   if(Path::exists($node))
   {
      if($ext!="")
      {
         $node=$srcname;
      }
   }
   $newname=$node.".bak";
   Path::erase($newname);
   Path::ren($srcname,$newname);
   Path::ren($dstname,$srcname);
   return;
}

function search($filename)
{
   global $VERBOSE;
   if($VERBOSE)
   {
      echo heading($filename), " ", ":", "\n";
   }
   $f2=openfile($filename,"r");
   if($f2 ==false)
   {
      return 0;
   }
   $linenum=0;
   while(true)
   {
      do
      {
         $line=fgets($f2,65536);
         if(!$line)
         {
            break 2;
         }
         $linenum+=1;
         global $COUNTER;
         $old=$COUNTER;
         global $stringtools;
         global $_StrTools_cdelimiters;
         $words=explode($_StrTools_cdelimiters,$line);
         reset($words);
         do
         {
            $cmp= current($words);
            global $searching;
            if($searching===$cmp)
            {
               $COUNTER+=1;
            }
            else
            {
               global $TEXTCASE;
               if($TEXTCASE===false)
               {
                  if(strtolower($searching)===strtolower($cmp))
                  {
                     $COUNTER+=1;
                  }
               }
            }
         }
         while(!(next($words) === false));

         if($COUNTER>$old)
         {
            global $QUIET;
            if($QUIET===false)
            {
               if(!$VERBOSE)
               {
                  echo heading($filename),":";
               }
               global $PADLEFT;
               echo str_pad(strval($linenum),4,"0",PADLEFT),": ",$line;
            }
         }
      } while(false);
   }
   fclose($f2);
   global $COUNTER;
   return $COUNTER;
}

function clean($dstname)
{
   if(Path::exists($dstname))
   {
      if(!Path::erase($dstname))
      {
         echo "Enable to clean", " ", $dstname, " ", "replacing cancelled", "\n";
         return false;
      }
   }
   return true;
}

function replaceid($srcname)
{
   global $VERBOSE;
   if($VERBOSE)
   {
      global $searching;
      global $replacing;
      echo "Replacing identifier", " ", $searching, " ", "by", " ", $replacing, " ", "in", " ", heading($srcname), "\n";
   }
   $dstname=$srcname.".tmp";
   if(!clean($dstname))
   {
      return 0;
   }
   global $TEXTCASE;
   if($TEXTCASE===false)
   {
      global $searching;
      $searching=strtolower($searching);
   }
   $src=array();
   $src=file($srcname);
   $linenum=0;
   global $searching;
   $lowsearch=strtolower($searching);
   reset($src);
   do
   {
      $line= current($src);
      global $COUNTER;
      $oldcounter=intVal($COUNTER);
      $newline="";
      global $_StrTools_cdelimiters;
      $srcwords=explode($_StrTools_cdelimiters,$line);
      reset($srcwords);
      do
      {
         $cmp= current($srcwords);
         $word=$cmp;
         if($searching===$cmp)
         {
            global $replacing;
            $word=$replacing;
            $COUNTER+=1;
         }
         else
         {
            if(($TEXTCASE===false)&&($lowsearch===strtolower($cmp)))
            {
               global $replacing;
               $word=$replacing;
               $COUNTER+=1;
            }
         }
         $newline.=$word;
      }
      while(!(next($srcwords) === false));

      $linenum+=1;
      $src[key($src)]=$newline;

      global $QUIET;
      if((!$QUIET)&&($COUNTER>$oldcounter))
      {
         if(!$VERBOSE)
         {
            echo heading($srcname),": ";
         }
         global $PADLEFT;
         echo str_pad(strval($linenum),4,"0",PADLEFT),": ",$newline;
      }
   }
   while(!(next($src) === false));

   $dst=0;
   $error=($dst=fopen($dstname,"w"));
   if($error===false)
   {
      die("enable to write on ".$dstname);
   }
   reset($src);
   do
   {
      $line= current($src);
      fwrite($dst,$line);
   }
   while(!(next($src) === false));
   fclose($dst);
   replacefile($srcname,$dstname);
   global $COUNTER;
   return $COUNTER;
}

function searchstr($srcname)
{
   global $VERBOSE;
   if($VERBOSE)
   {
      echo heading($srcname).": ", "\n";
   }
   $src=openfile($srcname,"r");
   if($src ==false)
   {
      return 0;
   }
   $linenum=0;
   global $TEXTCASE;
   if($TEXTCASE===false)
   {
      global $searching;
      $searching=strtolower($searching);
   }
   while(true)
   {
      do
      {
         $line=fgets($src,65536);
         if(!$line)
         {
            break 2;
         }
         $linenum+=1;
         if($TEXTCASE===false)
         {
            $line=strtolower($line);
         }
         global $searching;
         if(strpos($line,$searching)!=false)
         {
            if(!$VERBOSE)
            {
               echo heading($srcname),": ";
            }
            global $QUIET;
            if((!$QUIET))
            {
               global $PADLEFT;
               echo str_pad(strval($linenum),4,"0",PADLEFT),": ",$line;
            }
            global $COUNTER;
            global $stringtools;
            $COUNTER=$COUNTER+$stringtools->count($line,$searching);
         }
      } while(false);
   }
   fclose($src);
   global $COUNTER;
   return intVal($COUNTER);
}

function replacestr($srcname)
{
   global $VERBOSE;
   if($VERBOSE)
   {
      global $searching;
      global $replacing;
      echo "Replacing string \"".$searching."\" by \"".$replacing."\" in ".heading($srcname), "\n";
   }
   $dstname=$srcname.".tmp";
   if(!clean($dstname))
   {
      return 0;
   }
   $src=array();
   $src=file($srcname);
   $linenum=1;
   reset($src);
   do
   {
      $line= current($src);
      global $COUNTER;
      $oldcounter=intVal($COUNTER);
      $line=replace($line);
      global $QUIET;
      if((!$QUIET)&&($COUNTER>$oldcounter))
      {
         if(!$VERBOSE)
         {
            echo heading($srcname),": ";
         }
         global $PADLEFT;
         echo str_pad(strval($linenum),4,"0",PADLEFT),": ",$line;
      }
      $linenum+=1;
      $src[key($src)]=$line;
   }
   while(!(next($src) === false));

   $dst=openfile($dstname,"wb");
   if($dst ==false)
   {
      return 0;
   }
   reset($src);
   do
   {
      $line= current($src);
      fwrite($dst,$line);
   }
   while(!(next($src) === false));
   fclose($dst);
   replacefile($srcname,$dstname);
   global $COUNTER;
   return intVal($COUNTER);
}

function scanning($thedir)
{
   $dirarray=array();
   $filename="";
   $dirname="";
   $here=getcwd();
   global $VERBOSE;
   if($VERBOSE)
   {
      echo str_repeat('-',4), " ", $here, " ", str_repeat('-',56-strlen($here)), "\n";
   }
   if(Path::type($thedir)!="dir")
   {
      return;
   }
   $handle=opendir($thedir);
   rewinddir($handle);
   do
   {
         $filename=readdir($handle);
         if($filename ==false)
         {
            break;
         }
         if(in_array($filename,array(".","..")))
         {
            continue;
         }
         if(Path::isFile($filename))
         {
            global $TOTAL;
            $TOTAL+=1;
            global $pattern;
            global $FILECASE;
            if(patmatch($pattern,$filename,$FILECASE))
            {
               global $MATCHES;
               $MATCHES+=1;
               global $replacing;
               if($replacing==="")
               {
                  global $PURETEXT;
                  if($PURETEXT===false)
                  {
                     search($filename);
                  }
                  else
                  {
                     searchstr($filename);
                  }
               }
               else
               {
                  global $PURETEXT;
                  if($PURETEXT===false)
                  {
                     replaceid($filename);
                  }
                  else
                  {
                     replacestr($filename);
                  }
               }
            }
         }
   }
   while(true);
   global $RECURSE;
   if($RECURSE===false)
   {
      closedir($handle);
      return;
   }
   rewinddir($handle);
   do
   {
         $dirname=readdir($handle);
         if($dirname ==false)
         {
            break;
         }
         if(in_array($dirname,array(".","..")))
         {
            continue;
         }
         if(Path::isDir($dirname))
         {
            chdir($dirname);
            scanning(".");
            chdir("..");
         }
   }
   while(true);
   closedir($handle);
   return;
}

function main($argnum,$arglist)
{
   if(!(count($arglist)>=3&&count($arglist)<=5))
   {
      syntax();
   }
   global $TEXTCASE;
   $TEXTCASE=true;
   global $QUIET;
   $QUIET=false;
   global $FILECASE;
   $FILECASE=false;
   global $PURETEXT;
   $PURETEXT=true;
   global $RECURSE;
   $RECURSE=false;

   array_shift($arglist);
   $optstr=$arglist[0];
   $optchr=$optstr{0};
   while(($optchr==='-')||($optchr==='/'))
   {
      do
      {
         $opt=substr($optstr,1);
         array_shift($arglist);
         $_L3=strlen($opt);
         for($__3 = 0; $__3 < $_L3; $__3++)
         {
            $i=$opt{$__3};
            
            if($i==='i')
            {
               $TEXTCASE=false;
            }
            else
            {
               if($i==='c')
               {
                  $PURETEXT=false;
               }
            else
            {
               if($i==='u')
               {
                  $FILECASE=true;
               }
            else
            {
               if($i==='q')
               {
                  $QUIET=true;
               }
            else
            {
               if($i==='f')
               {
                  global $VERBOSE;
                  $VERBOSE=true;
               }
            else
            {
               if($i==='r')
               {
                  $RECURSE=true;
               }
            else
            {
               if($i==='v')
               {
                  global $VERBOSE;
                  $VERBOSE=true;
               }
            else
            {
               echo $i, " ", "bad option", "\n";
               syntax();
            }
            }}}}}}
         }
         $optstr=$arglist[0];
         $optchr=$optstr{0};
      } while(false);
   }
   if(count($arglist)===3)
   {
      global $replacing;
      $replacing=$arglist[1];
      array_splice($arglist,1,1,array());
   }
   global $searching;
   $searching=$arglist[0];
   global $pattern;
   $pattern=$arglist[1];

   global $replacing;
   if(($replacing{0}==="-")||($searching{0}==="-")||($pattern{0}==="-"))
   {
      echo "Put options at beginning...", "\n";
      syntax();
   }
   scanning(getcwd());
   global $VERBOSE;
   if($VERBOSE)
   {
      echo str_repeat('-',60), "\n";
   }
   global $TOTAL;
   global $MATCHES;
   global $COUNTER;
   echo $TOTAL, " ", "file".($TOTAL>1?"s":"").",", " ", $MATCHES, " ", "file".($MATCHES>1?"s":""), " ", "matching,", " ", $COUNTER, " ", "occurence".(intVal($COUNTER)>1?"s":""), " ", "found", "\n";
   return 0;
}

main(intVal($argc),$argv);

?>
