/*
   SEB
   Simple and efficient backup script
   
   Input: a list of directories or files.
   Ouput: a dated zip file.
   
   Requirement: Scriptol and/or PHP interpreter.
                7-Zip or another archive compressor.
*/

include "path.sol"


// The list of files
// To save a directories add * after the slash.

array saving = []


void usage(text archive)
  print "SEB - Simple & Efficient Backup script"
  print "Syntax: seb target"
  print "Target is a directory or a drive or both."
  print "Archive to create: $archive"
  exit(0)
return


void main(int argc, array argv)
  
  // Choose your zone, comment others    
  date_default_timezone_set("Europe/Paris")
  date_default_timezone_set("Asia/Calcutta")
  date_default_timezone_set("US/Central")
  
  text archive = "backup-" + date("Y-M-d-G-i", time()) 

  if argc < 2 let usage(archive)
  text target = argv[1]  
  target = Path.merge(target, archive)
  
  print "Backup into $target"
  
  // Choose your archiver command, comment others
  //text command = "pkzip -add -dir=root $target "
  text command = "7z a -tzip $target "
  for text t in saving
   command + t + " "
  /for
  
  print command
  exec(command)
  
  print "All done."

return

main($argc, $argv)
