
`` Directory To Xml converter - Version 1.1 - (c) 2004 scriptol.com
`` Licence: OSS BSD
`` Requirement: The free Scriptol to C++ compiler.
`` Reads a directory, builds an xml document or a web page,
`` elements are sub-directories and files,
`` attributes are names, lengths and dates...
`` Example of use is to build a directory of all your CDs...

include "path.sol"
include "dirlist.sol"
include "libdom.sol"

dom disktree
boolean BULLETS = false

int buildtree(text dirname, text fname, int total)
  DirList dl
  int files, dirs
  text sizestr
  xelement element
  text fullname
  boolean flag
  int si
  text da
  boolean flag2 = false

  dl.open(dirname)     ` open the directory
  dl.begin()            ` move the pointer to the first entry
  flag = true

  do
     fname = dl.next()                 ` the name of an entry
     if fname = nil ? break
     if fname in (".", "..") ? continue  ` ignore these
     if fname[0] = '.' ? continue        ` ignore under unix

     fullname = Path.merge(dirname, fname)
     if Path.type(fullname)
     = "dir" :              ` a subdirectory
               dirs + 1
               element = xelement("dir")
               if flag
                 disktree.addChild(element)
                 flag = false
               else
                 disktree.addNext(element)
               /if
               si = buildtree(fullname, fname, 0)
               element.addAttribute("name", fname)
               element.addAttribute("size", text(si))
               total + si
               flag2 = true

     = "file" :             ` a file
               si = Path.size(fullname)
               da = Path.created(fullname)
               files + 1
               total + si   ` add size to total
               element = xelement("file")
               element.addAttribute("name", fname)
               element.addAttribute("size", text(si))
               element.addAttribute("date", text(da))
               if flag
                 disktree.addChild(element)
                 flag = false
               else
                 disktree.addNext(element)
               /if
               flag2 = true
     /if

  /do forever

  dl.close()

  if flag2 let disktree.up()

return total


dom dirtoxml(text root, text dirname)
  dict d
  disktree = dom()
  int total
  text dname, fname
  xelement xe = xelement("dir")

  if not Path.exists(dirname)
     print dirname, "not found"
     exit()
  /if

  dname, fname = Path.splitFile(dirname)

  if Path.type(dirname) <> "dir" ?  die(dirname + " not a directory")

  disktree.addHeader("<?xml version=\"1.0\"?>");
  disktree.addChild(xe)
  xe.addAttribute("name", dirname)
  total = buildtree(dirname, fname,  0)
  xe.addAttribute("size", text(total))
  disktree.up()

  print "Total size", total

return disktree


dom htmlDom
array page

void htmlsub(int nextElement)

  int childElement
  text elementName
  text filename

  while forever

    htmlDom.setIndex(nextElement)
    childElement = htmlDom.getChild()
    nextElement = htmlDom.getNext()

    if htmlDom.isElement()

      elementName = htmlDom.getElementName()
      filename = htmlDom.getValue("name")
      //print filename

      if (childElement > 0) or (elementName = "dir")
        page.push("<b>[")
        page.push(filename)
        page.push("]</b><br>\n<ul>\n")
        if childElement > 0
          htmlsub(childElement)
        /if
        page.push("</ul>\n")
      else
        if BULLETS let page.push("<li>")
        page.push(filename)
        if BULLETS let page.push("</li>")
        page.push("<br>\n")
      /if
    /if

    if nextElement = 0 break

  /while

return


void xml2Html(dom d)

  text line
  xelement xe

  htmlDom = d

  page.push("<html>\n")
  page.push("<body background='#FFFFFF'>\n")
  htmlsub(1)              ` skip the root node
  page.push("</body>\n")
  page.push("</html>\n")

return



void usage()
   print "Directory To Xml - by scriptol.com"
   print "Syntax:  dir2xml [-html] directory filename.xml"
   print "- 'directory' is the directory to display, . for current"
   print "   Root directory has the form  c: (windows) or  / (unix)"
   print "- 'filename.xml' is the file to generate."
   print "- use the '-html' option to produce a html file."

   exit(0)
return


int main(int argc, array argv)

   text dirname
   boolean HTMLFLAG = false

   dirname = argv[1]
   if (dirname = "-html") or (dirname = "--html")
     argv.shift()
     dirname = argv[1]
     HTMLFLAG = true
   /if

   if argc < 3
      usage()
   /if

  text xmlname = argv[2]

  print "Building an xml document from", dirname


  dom mydom = dirtoxml("root", dirname)

  if HTMLFLAG
    xml2Html(mydom)
    mydom.display()
    page.store(xmlname)
  else
    mydom.save(xmlname)
    //mydom.display()
  /if

  print xmlname, "generated..."

return 0






