`` Ini To Dom - (c) 2004 scriptol
`` Scriptol Library
`` www.scriptol.com
`` Licence: OSS Freeware


include "path.sol"
include "libphp.sol"
include "libdom.sol"


boolean LIGHT = false
boolean EXPANDED = false
dom initree
file so
text COMMENTCODE
array iniArray
dom iniDom


void usage()
  print
  print "Ini To Dom Transformer - www.scriptol.com"
  print "Licence: OSS Freeware"
  print "Syntax:"
  print "ini2dom [-light][-expanded] sourcefile"
  print "- source is an ini file."
  print "- generates an xml (default) or light xml file."
  print "Options:"
  print "  -light: generates light."
  print "  -expand: option name and value are separated attributes."
  exit(0)
return



`` From a title [name], builds an element

xelement makeTitleElement(text line)
  xelement element
  if EXPANDED
    element = xelement("title")
  /if
  int i = line.find("[")
  if i <> nil
    int j = line.find("]", i)
    if j = nil let j = line.length()
    text name = line[i + 1 -- j]
    if EXPANDED
       element.addAttribute("name", name)
    else
       element = xelement(name)
    /if
  /if
return element


`` From an entry, attribute=value, builds an element

xelement makeElement(text line)
  text commentline
  int leftq, rightq

  int j = line.find(";")

  leftq = line.find("\"")
  if leftq <> nil
    rightq = line.find("\"", leftq + 1)
    if rightq = nil let rightq = leftq
  /if

  if j <> nil
     if (j < leftq) or (j > rightq)
       commentline = line[j + 1 .. ]
       line = line[0 -- j]
     /if
  /if

  int i = line.find("=")
  if i = nil
    i = line.find(":")
  /if

  if i = nil return null

  text name = line[0 -- i]
  text value = line[i + 1 .. ]

  xelement element
  element = xelement("option")
  if not EXPANDED
    element.addAttribute(name.trim(), value.trim())
  else
    element.addAttribute("name", name.trim())
    element.addAttribute("value", value.trim())
  /if

  if commentline <> nil
    element.addAttribute("comment", commentline)
  /if
return element


xelement makeComment(text line)
  xelement element = xelement("comment")
  element.addAttribute("data", line)
return element


xelement makeBlank()
  xelement element = xelement("blank")
return element


// Test if the line holds  a comment
// return the position if one

int hasComment(text line)
  int rq = 0
  int lq = 0
  int pos

  pos = line.find("=")
  if pos = nil
    pos = line.find(":")
    if pos = nil return -1
  /if

  pos + 1

  lq = line.find("\"", pos)
  if lq <> nil
    rq = line.find("\"", lq + 1)
    if rq = nil ? rq = pos
  else
    lq = pos
  /if

  pos = line.find(";", pos)

return pos



`` processing files

dom iniToTree(text source)

  dom d
  boolean flag = true
  boolean inlevel = false
  text c
  text elementName
  text code = "#"
  xelement element
  xcomment comment
  xelement childElement
  int pos

  COMMENTCODE = ""

  so = fopen(source, "r")

  while not so.eof()
    text line = so.readLine().rTrim()

    childElement = null

    if line.length() < 1
      element = makeBlank()
      if flag
        d.addChild(element)
        flag = false
      else
        d.addNext(element)
      /if
      continue
    /if

    code = line[0]
    if (code = "#") or (code = ";")
      if COMMENTCODE = "" let COMMENTCODE = code
      if line[1] not in "#; "
        if (line.find("=") <> nil) or (line.find(":") <> nil)
           line = line[1 ..]
           element = makeElement(line)
           if element = null continue
           element.addAttribute("active", "false")
           if flag
              d.addChild(element)
              flag = false
           else
              d.addNext(element)
           /if
           continue
        /if
      /if

      element = makeComment(line[ 1 ..])
      if flag
        d.addChild(element)
        flag = false
      else
        d.addNext(element)
      /if

      continue
    /if


    for int i in 0 -- line.length()
      c = line[i]
      if c = " " continue
      if c = "["
        if inlevel
          d.up()
        /if
        element = makeTitleElement(line)
        elementName = element.getValue("name")
        if elementName.length() = 0 continue
        if flag
          d.addChild(element)
          flag = false
        else
          d.addNext(element)
        /if
        break          // goto next line
      else
        pos = hasComment(line)
        if pos <> nil
          childElement = makeComment(line[ pos + 1 ..])
          line = line[0 -- pos]
        /if
        element = makeElement(line)
        if element = null continue
        element.addAttribute("active", "true")
        if flag
          d.addChild(element)
          flag = false
        else
          d.addNext(element)
        /if
        // test if a comment on line
        if childElement <> null
          d.addChild(childElement)
          d.up()
        /if
        break
      /if
    /for

  /while

  so.close()

return d



`` Save the dom tree in ini form, into an array
`` you can save into a file again.
`` We need just a dom iterator applied on two levels of tree.


text processTitle(xelement xe)
  text t
  text value

  if EXPANDED
    value = xe.getValue("name")
  else
    value = xe.getName()
  /if
  t = text("[") + value + "]" + "\n"
return t


text processEntry(xelement xe)
  text t
  text name
  text value
  text active

  if EXPANDED
     name  = xe.getValue("name")
     value = xe.getValue("value")
  else
     xe.begin()
     name  = xe.nextName()
     value = xe.nextValue()
  /if

  active = xe.getValue("active")

  if active = "false" ? t + COMMENTCODE

  t + name
  t + " ="
  if value.length() > 0
   t + " "
   t + value
  /if

return t + "\n"


text processComment(xcomment xc)
  text t
  if xc.data.trim().length() > 0
    t + COMMENTCODE
  /if
  t + xc.data
  t + "\n"
return t


void d2i_sub(int no)
   text line
   int child
   xelement xe
   xcomment xc
   text elementName

 while forever

   iniDom.setIndex(no)
   child = iniDom.getChild()
   no = iniDom.getNext()

   do
   case iniDom.isElement()
     xe = iniDom.getElement()
     if EXPANDED
       elementName = xe.getValue("name")
     else
       elementName = iniDom.getElementName()
     /if
     if elementName

     = "option":
       line = processEntry(xe)

     = "title":
       line = processTitle(xe)

     = "blank":
       line = "\n"

     = "comment":
       line = COMMENTCODE
       line + xe.getValue("data")
       line + "\n"

     else
       line = processTitle(xe)

     /if

     /*
     if child > 0
       iniArray.push( processTitle(xe) )
       d2i_sub(child);
     else
       iniArray.push( processEntry(xe) )
     /if
     */

     iniArray.push(line)

   case iniDom.isComment()
     xc = iniDom.getComment()
     iniArray.push( processComment(xc))
   /do

   if no = 0 break

 /while

return


void dom2ini()
  iniArray = array()
  d2i_sub(1)
return



`` main function for a command-line tool

int main(int argc, array argv)

 ` processing arguments

 if argc not in 2..4 let usage()

 text source
 text target
 text extension = ".xml"
 text node, ext
 LIGHT = false
 EXPANDED = false


 source = argv[1]

 // processing options -light and/or -expanded

 while source[0] = '-'
   if source
   = "-light":
               extension = ".sol"
               LIGHT = true
   = "-expand":
               EXPANDED = true
   /if
   argv.shift()
   argc - 1
   source = argv[1]
 /while

 // deciding target name

 if argc = 2
   node, ext = Path.splitExt(source)
   target = node + extension
 else
   target = argv[2]
 /if

 if target.compare(source) = 0 let usage()

 if not file_exists(source)
   die(source + " not found...")
 /if

 print "Converting", source, "into", target, "..."
 iniDom = iniToTree(source)
 iniDom.save(target)
 //iniDom.dump()

 print "Storing dom tree into", node + ".tmp"
 dom2ini()
 iniArray.store(node + ".tmp")

return 0


