`` Ini To Xml - (c) 2004 scriptol
`` www.scriptol.com
`` Licence: OSS Freeware


include "path.sol"
include "libphp.sol"


text tagName = ""
boolean LIGHT = false
boolean COMMENT = true
file so
file ta

void usage()
  print
  print "Ini To Xml Transformer - Scriptol.com"
  print "Syntax: ini2xml [-light] sourcefile [targetfile]"
  print "- Source is a configuration file with a format as:"
  print "  [title]"
  print "  name=value"
  print "  ..."
  print "- Target will be a xml document."
  print "  Default target name is source name with an .xml extension."
  print "- Option -light for a light xml Scriptol source."
  exit(0)
return


void indent(boolean mode)
  ta.write("  ")
  if mode ? ta.write("  ")
return


`` convert a comment

text makeComment(text line)
  text outline
  if not LIGHT
    outline = "<!--"
    outline + line
    outline + "-->"
    return outline
  /if
  outline = "`` "
  outline + line
return outline


`` opening a tag from the title

text makeTitle(text line)
  int i = line.find("[")
  if i = nil return ""
  int j = line.find("]")
  if j = nil
    j = line.length()
  /if
  text outline
  if not LIGHT let outline = "<"
  outline + "title name="
  outline + line[i + 1 -- j]
  tagName = "title"
  if not LIGHT let outline + ">"

return outline


`` closing the tag

text makeEnding()
  text outline
  if not LIGHT ? outline = "<"
  outline + "/"
  outline + tagName
  if not LIGHT ? outline + ">"
return outline


`` add quotes if required

text quote(text value)
  value = value.trim()
  if value[0] = "\"" return value
  text line = "\""
  line + value
return line + "\""


`` transform an entry

text makeEntry(text line)
  int i = line.find("=")
  if i = nil
    i = line.find(":")
    if i = nil return ""
  /if
  text name = line[0 -- i]
  text value = line[i + 1 .. ]
  text outline
  if not LIGHT ? outline = "<"
  outline + "entry "
  outline + name
  outline + "="
  outline + quote(value)
  outline + " /"
  if not LIGHT ? outline + ">"

return outline


`` processing files

void iniToXml(text source, text target)

  so = fopen(source, "r")
  ta = fopen(target, "w")
  boolean intag = false
  text c
  text outline

  if LIGHT
    ta.write("xml\n")
  else
    ta.write("<?xml version=\"1.0\">\n")
  /if

  while not so.eof()
    text line = so.readLine().rTrim()
    if line = nil continue
    //print line

    outline = ""

    if (line[0] = "#") or (line[0] = ";")
      outline = makeComment(line[ 1 ..])
      line = ""
      if COMMENT
        indent(intag)
        ta.write(outline + "\n")
      /if
    /if

    for int i in 0 -- line.length()
      c = line[i]
      if c = " " continue
      if c = "["
        // purge previous title
        if intag
          outline = makeEnding()
          indent(false)
          ta.write(outline + "\n")
        /if
        outline = makeTitle(line)
        indent(false)
        ta.write(outline + "\n")
        intag = true
        break          // goto next line
      else
        outline = makeEntry(line)
        if(outline = "") break
        indent(true)
        ta.write(outline + "\n")
        break
      /if
    /for

  /while

  if intag
    indent(false)
    ta.write(makeEnding())
    ta.write("\n")
  /if

  if LIGHT ? ta.write("/xml\n")

  so.close()
  ta.close()

return


`` main function for a command-line tool

int main(int argc, array argv)

 ` processing arguments

 if argc not in 2..4 let usage()

 text extension = ".xml"
 text source = argv[1]
 if source = "-light"
   argv.shift()
   argc - 1
   source = argv[1]
   LIGHT = true
   extension = ".sol"
 /if
 text target
 if argc = 2
   text node, ext
   node, ext = Path.splitExt(source)
   target = node + extension
 else
   target = argv[2]
 /if

 if target.compare(source) = 0 let usage()

 print "Converting", source, "into", target, "..."
 iniToXml(source, target)
 print target, "generated."


return 0

main($argc, $argv)
