

`` Light
`` (c) 2004 By D.G. Sureau  - www.scriptol.com
`` Convert a "pure" xml document, with angle-brackets
`` into "light" xml, ready to be used as a Scriptol source
`` and conversely


include "path.sol"
include "libphp.sol"


void usage()
  print "Light (c) 2004 Scriptol - www.scriptol.com"
  print "Converts an xml file into a light xml source."
  print "Syntax: light [-u] sourcefile [targetfile]"
  print "- The -u (unlight) option converts light source into standard xml."
  print "- Source is an xml document or a .sol light source."
  print "- Target will be a file in the other format,"
  print "  if name omitted, source's name with other extension."
  exit(0)
return


`` Light, converts standard xml file into light xml source.

void light(text source, text target)
  file so = fopen(source, "r")
  file ta = fopen(target, "w")
  boolean incode = false
  text c
  text outline

  while not so.eof()
    text line = so.readLine()
    if line = nil continue

    outline = ""

    for int i in 0 -- line.length()
      c = line[i]

      if incode
        if c <> "?" continue
        if (i + 1) < line.length()
          if line[i + 1] = ">"
            incode = false
            i + 1
            continue
          /if
        /if
      /if

      if c = "<"
        if (i + 1) < line.length()
          if line[i + 1] = "?"
            incode = true
            i + 1
            continue
          /if
        /if
       continue
      /if

      if c = ">"
        continue
      /if

      outline[i] = line[i]

     /for
     if outline.length() > 0 let ta.write(outline)
   /while

  so.close()
  ta.close()
return


`` Unlight, converts light xml source into standard xml file.

void unlight(text source, text target)
  file so = fopen(source, "r")
  file ta = fopen(target, "w")
  boolean incode = false
  text c
  text outline
  boolean DATA = false
  boolean COMMENT = false
  boolean PROPERTY

  while not so.eof()
    text line = so.readLine()
    if line = nil continue

    line = line.rTrim()

    ` Processing data

    outline = line.lTrim()

    if DATA
      if outline[0 .. 1] = "~~"
        DATA = false
        continue
      /if
      ta.write(outline + "\n")
      continue
    /if
    if outline[ 0 .. 1] = "~~"
      DATA = true
    /if

    if outline[0] = "\""
      outline = outline[1 .. -1]
      ta.write(outline)
      continue
    /if

    ` Processing comments

    if COMMENT
      if outline[0 .. 1] = "*/"
        ta.write("-->\n")
        COMMENT = false
        continue
      /if
      ta.write(outline + "\n")
      continue
    /if
    if outline[ 0 .. 1] = "/*"
      COMMENT = true
      outline[0..1] = "<!--"
      if outline.find("*/") <> nil
        COMMENT = false
      /if
      ta.write(outline + "\n")
      continue
    /if


    ` Processing unterminated list of properties

    PROPERTY = false

    if line[-1 .. ] = ","
       line = line[ .. -1]
       PROPERTY = true
    /if

    ` Processing a tag

    if not PROPERTY
      outline = "<"
      outline + line
    /if


    ` Processing the end of a tag

    int l = outline.length()
    int i, j
    for i in 0 -- l
      if outline[i] = "/"
        outline.insert(i , "<")
        for j in i + 1 -- l
          if outline[j] = " "
            outline.insert(j, ">")
            break
          /if
        for
        i + 1
      /if
    /for

    ta.write(outline)
  /while

  so.close()
  ta.close()
return


int main(int argc, array argv)

 ` processing arguments

 if argc not in 2..4 let usage()

 boolean UNLIGHT = false
 text source = argv[1]
 print "source", source
 text target

 if argv[1] = "-u"
   UNLIGHT = true
   argv.shift()
 /if

 if argc = 2
   text node, extension
   node, extension = Path.splitExt(source)
   target = node
   if UNLIGHT
     target + ".xml"
   else
     target + ".sol"
   /if
 else
   target = argv[2]
 /if

if target.compare(source) = 0 let usage()

` processing files

print "Converting", source, "into", target, "..."

if UNLIGHT
  unlight(source, target)
else
  light(source, target)
/if

print target, "generated."

return 0

main($argc, $argv)

