`` XmlOptions - (c) 2004 scriptol.com
`` www.scriptol.com
`` Licence: OSS Freeware
`` Requires:
`` - solp the Scriptol to php compiler + the PHP interpreter
`` - or solc the Scriptol to C++ compiler

/*
  Process a ini file and convert it into a xml configuration file
  values separated by command are converted into several
  tags
*/



include "path.sol"
include "libphp.sol"


text tagName = ""
boolean LIGHT = false
boolean COMMENT = true
file so
file ta

void usage()
  print
  print "XmlOptions - www.scriptol.com"
  print "Syntax: opt2xml [-light][-xml] sourcefile [targetfile]"
  print "- Source is a standard configuration file with titles and properties."
  print "- Target will be a xml document where titles are element,"
  print "  properties sub-elements and values their data."
  print "- Default target name is source name with an .xml extension."
  print "- Option -light for a light xml Scriptol source."
  print "-        -xml   for an xml extension (default uc)."
  exit(0)
return


void indent(boolean mode)
  ta.write("   ")
  if mode ? ta.write("   ")
return



`` convert a comment

text makeComment(text line)
  text outline = ""
  line.replace("--", "- -")
  if not LIGHT let outline + "<"
  outline + "comment value="
  outline + quote(line, "\"")
  outline + " /"
  if not LIGHT let outline + ">"
return outline


`` opening a tag from the title

text makeTitle(text line)
  int i = line.find("[")
  if i = nil return ""
  int j = line.find("]")
  if j = nil
    j = line.length()
  /if
  text outline
  if not LIGHT let outline = "<"
  tagName = line[i + 1 -- j].trim()
  outline + "title name="
  outline + quote(tagName, "\"")
  outline + " /"
  if not LIGHT let outline + ">"
  tagName = "title"
return outline



`` add quotes if required

text quote(text value, text qtype)
  value = value.trim()
  value.replace("&", "&amp;")
  value.replace("<", "&lt;")
  value.replace(">", "&gt;")
  value.replace("\"", "&quot;")

  //if not LIGHT return value
  if (value[0] = "\"") or (value[0] = "\'") return value
  text line = qtype
  line + value
return line + qtype


`` Builds a list of values from a comma separated text

array listOfValues(text line)
  array a
  int first = 0
  int size = line.length()
  int pos = 0
  int last
  text subline

  last = size

  do
    pos = line.find(",", first)
    if pos <> nil
       last = pos
    /if
    subline = line[first -- last]
    a.push(subline.trim())
    first = last + 1
    last = size
  until pos = nil

return a


`` transform an entry

text makeEntry(text line)

  `` processing comment at end of the line

  text commentline
  int leftq, rightq

  int j = line.find(";")

  leftq = line.find("\"")
  if leftq <> nil
    rightq = line.find("\"", leftq + 1)
    if rightq = nil let rightq = leftq
  /if

  if j <> nil
     if (j < leftq) or (j > rightq)
       commentline = line[j + 1 .. ]
       line = line[0 -- j]
     /if
  /if

  `` separating name and value

  int i = line.find("=")
  if i = nil
    i = line.find(":")
    if i = nil return ""
  /if
  text name = line[0 -- i].trim()
  array valueList = listOfValues( line[i + 1 .. ] )
  text outline = "   "
  if not LIGHT ? outline + "<"
  outline + "entry name="
  outline + quote(name, "\"")
  if not LIGHT ? outline + ">"
  outline + "\n"
  for text v in valueList
    outline + "      "
    if not LIGHT ? outline + "<"
    outline + "option value="
    outline + quote(v, "'")
    outline + "/"
    if not LIGHT ? outline + ">"
    outline + "\n"
  /for
  if commentline.length() > 0
    outline + "      "
    if not LIGHT ? outline + "<"
    outline + "comment value="
    outline + quote(commentline, "'")
    outline + "/"
    if not LIGHT ? outline + ">"
    outline + "\n"
  /if
  outline + "   "
  if not LIGHT ? outline +"<"
  outline + "/entry"
  if not LIGHT ? outline + ">"
return outline


`` processing files

void iniToXml(text source, text target)

  so = fopen(source, "r")
  ta = fopen(target, "w")
  text c
  text outline
  text line
  text lastchar
  text temp

  if LIGHT
    ta.write("xml\n")
    ta.write("options\n")
  else
    ta.write("<?xml version=\"1.0\"?>\n")
    ta.write("<options>\n")
  /if

  while not so.eof()

    line = so.readLine().trim()
    if line = nil continue
    //print line
    while forever
      lastchar = line[line.length() -1 ]
      if lastchar = ','
        temp = so.readLine().rTrim()
        line + temp
      else
        break
      /if
    /while


    outline = ""

    if (line[0] = "#") or (line[0] = ";")
      if line[1] = " "
        outline = makeComment(line[1..])
        line = ""
        if COMMENT
          indent(false)
          ta.write(outline + "\n")
        /if
        continue
      /if
      line = line[1..]
    /if

    if line[0] = "["
        outline = makeTitle(line)
        indent(false)
        ta.write(outline + "\n")
        continue
    /if

    if line.find("=") = nil
       if line.find(":") = nil
          continue
       /if
    /if

    outline = makeEntry(line)
    if(outline = "") break
    ta.write(outline + "\n")

  /while


  if LIGHT
    ta.write("/xml\n")
    ta.write("/options")
  else
    ta.write("</options>")
  /if

  so.close()
  ta.close()

return


`` main function for a command-line tool

int main(int argc, array argv)

 ` processing arguments

 if argc not in 2..4 let usage()

 text extension = ".uc"
 text source = argv[1]

 // processing options -light and/or -xml

 while source[0] = '-'
   if source
   = "-light":
               extension = ".sol"
               LIGHT = true
   = "-xml":
               extension = ".xml"
   /if
   argv.shift()
   argc - 1
   source = argv[1]
 /while

 // deciding target name

 text target
 if argc = 2
   text node, ext
   node, ext = Path.splitExt(source)
   target = node + extension
 else
   target = argv[2]
 /if

 // target name and source must be different

 if target.compare(source) = 0 let usage()

 print "Converting", source, "into", target, "..."
 iniToXml(source, target)
 print target, "generated."

return 0

main($argc, $argv)

