const https = require('https')
const http = require('http')   
const urltool = require("url")
const { DOMParser } = require('xmldom')

var VERBOSE = false

function beforeExit() {
    process.on("exit", function() {
        dispLinksChecks()
        console.log(CHECKS + " links verified.")        
        var s = (BROCOUNT > 1 ? "s" : "")
        console.log(BROCOUNT + " broken link" + s + ".")
        console.log("Done.")
    })
}

function convertUnix(src) {
   return src.replace(/\\/g,'/');
}


function retrieveLinks(content) {
    var links = []
    var res = content.match(/<a href( *)=( *)("|')(.*?)("|')( |>)/gi);
    if(res != null)
    for(var i = 0; i < res.length; i++) {
        var l = res[i]
        l = l.replace("<a href=", "")
        l = l.slice(1, -1)
        links.push(l)
    }
    res = content.match(/src( *)=( *)("|')(.*?)("|')( |>)/gi);
    if(res != null)
    for(var i = 0; i < res.length; i++) {
        var l = res[i]
        l = l.replace("src=", "")                
        l = l.slice(1, -1)
        links.push(l)
    }

    return links
}

/*
function retrieveLinks(content) {
    const parser = new DOMParser();
    var links = []    
    const doc = parser.parseFromString(content, "text/html")
    let lnlist = doc.links;
    console.log(lnlist)
    for(let i=0; i < lnlist.length; i++) {
        links.push(lnlist[i].href);
        console.log(lnlist[i].href)
    }
    lnlist = doc.getElementsByTagName("img");
    for(let i=0; i < lnlist.length; i++) {
        links.push(lnlist[i].src);
        console.log(lnlist[i].src)
    }

    console.log(links)
}    
*/

function showStatus(code, link, filename) {  
    var mess = ""
    if (DEBUG)
      console.log("statusCode: "+ code)

    if(code == 200 || code == 302) {
        CHECKOK += 1
        return true
    }

    if(typeof PAGES[filename] == "undefined"){
        PAGES[filename] = []
    }

    switch(code) {
        case 404: mess = "Broken " + link
           BROCOUNT += 1 
           break;
        case 301: mess = "Redirect " + link
            break;
        default:
            mess = code + " " + link
    }
    
    PAGES[filename].push(mess)
   return false
}    

var count = 0;
function checkLink(url, filename) {
    if(VERBOSE) 
        console.log("Process " , url)
    else {
        count++
        if(count == 10) {
            process.stdout.write('.')
            count=0
        }
    }
      
    return new Promise(function (resolve) { 
        CHECKS+=1;
        var req;
        const urlobj = URL.parse(url)
        options = {
            method: 'HEAD', 
            timeout: 50,
            hostname: urlobj.host,
            path:urlobj.pathname
        }        
        //console.log("CALL", url, urlobj.host);

        if(url.charAt(4).toLowerCase() === "s") {
            try {
                req = https.request(options, (res)=> {
                    resolve(showStatus(res.statusCode, url, filename))
                });
                req.on('error', (e) => {
                    console.error(`\nPage ${filename}: ${e.message} in ${url}`);
                    resolve(showStatus(0, url, filename))
                });
                req.end();
                
            }
            catch(e) {
                console.log("ERR", e)
                resolve(showStatus(0, url, filename))
            }
        }
        else {
            try {
                req = http.request(options, (res)=> {
                    resolve(showStatus(res.statusCode, url, filename))
                });
                req.on('error', (e) => {
                    console.error(`\nPage ${filename}: ${e.message} in ${url}`);
                    resolve(showStatus(0, url, filename))
                });
                req.end();
            }
            catch(e) {
                resolve(showStatus(0, url, filename))
            }
        }

        
    })
}




