<?php

/*
  phpBB to HTML
  Convert threads on your phpBB 3 forum to static HTML pages.
 
  (c) 2013 Scriptol.com
   Freeware
   
   Installing and how to use on...
     
   English:        http://www.scriptol.com/cms/
   French :        http://www.scriptol.fr/cms/
   
   There is a version of the script for the fluxBB CMS too.
*/

// User configuration: update these data according to your own website

$TRANSLATE_BB = true;  // true to convert BB code such as [code] to <pre>
$formatflag = false;   // True to convert accents and special chars

$dateformat='D, d M Y H:i:s';

// End of user configuration

$cvt = array( 
   "(´)"=>"'",          "(ç)"=>"&ccedil;",
   "(à)"=>"&agrave;",   "(â)"=>"&acirc;",   "(ä)"=>"&auml;",
   "(è)"=>"&egrave;",   "(é)"=>"&eacute;",  "(ê)"=>"&ecirc;",  "(ë)"=>"&euml;",
   "(î)"=>"&icirc;",    "(ï)"=>"&iuml;",
   "(ô)"=>"&ocirc;",    "(ö)"=>"&ouml;",
   "(ù)"=>"&ugrave;",   "(ü)"=>"&uuml;",    "(û)"=>"&ucirc;",
   "(«)"=>"&laquo;",    "(»)"=>"&raquo;",
   "(©)"=>"&copy;",     "(§)"=>"&para;",
);  

$cvturl = array( 
   "(´)"=>"'", "(ç)"=>"c",
   "(à)"=>"a", "(â)"=>"a", "(ä)"=>"a",
   "(è)"=>"e", "(é)"=>"e", "(ê)"=>"e",  "(ë)"=>"e",
   "(î)"=>"i", "(ï)"=>"i",
   "(ô)"=>"o", "(ö)"=>"o",
   "(ù)"=>"u", "(ü)"=>"u", "(û)"=>"u",
   "(«)"=>"-", "(»)"=>"-",
   "(©)"=>"-", "(§)"=>"-", "(\?)"=>"-",
   "(\.)"=>"-", "(\')"=>"-"
);  
   
function converturl($url)
{
  global $cvturl;
  return preg_replace(array_keys($cvturl), array_values($cvturl), $url);
}  

// Use this function only if the format differs

function convert($content)
{
  global $cvt;
  return preg_replace(array_keys($cvt), array_values($cvt), $content);
}  

// Use  to convert to UTF-8

function makeUTF($desc)
{  
  $desc = UTF8_encode($desc);
  $desc = stripslashes($desc);
  return($desc);
}  

$excluded = array('a', 'an', "l'", "d", "d'", 'le', 'el', 'al', 'the', 'd', '\'', 'un', 'une', 'de', '?', '!', ',', ';', '.');

function buildURL($title, $id)
{
  global $excluded;

  $title = str_replace('/', ' ', $title);
  $parts = explode(" ", $title);
  
  $url="forum";
  foreach($parts as $word)
  {
    if(!in_array($word, $excluded)) {
      $word = strtolower($word);
      $url .= "-$word";
    }  
  }
  $url = converturl($url);
  $url .= "-$id.php";
  return $url;
}

/*
  addPost
  Add a message to the page for a topic
  
  Input: 
  - doc is the template to fill
  - forum is the parent node
  - line is the array of data for a post
*/

function addPost($doc, $forum, $line)
{
  global $dateformat;
  global $table_prefix;
  global $bbcode;
   
  $tableusers = $table_prefix."users";     

  $posterid =  $line['poster_id'];
  $message = $line['post_text'];
  $posted = date($dateformat, $line['post_time']+(0));  
  
  $query = "SELECT user_id, username FROM $tableusers WHERE user_id='$posterid'";
  $resusers = mysql_query($query) or die(mysql_error());
  
  $userrow = mysql_fetch_assoc($resusers);  
  $username =  $userrow['username']; 
  
  
  $box = $doc->createElement("div");
  $box->setAttribute('class', 'box');
  $forum->appendChild($box);
  
  $boxtitle = $doc->createElement("div", $posted);
  $boxtitle->setAttribute('class', 'boxtitle');
  $box->appendChild($boxtitle); 
  
  $boxbody = $doc->createElement("div");
  $boxbody->setAttribute('class', 'boxbody');
  $box->appendChild($boxbody);   
  
  $postleft = $doc->createElement("div");
  $postleft->setAttribute('class', 'postleft');
  $boxbody->appendChild($postleft);

  $postright = $doc->createElement("div");
  $postright->setAttribute('class', 'postright');
  $boxbody->appendChild($postright);

  $leftcont =  $doc->createElement("p", $username);
  $leftcont->setAttribute('class', 'leftcont');
  $postleft->appendChild($leftcont);

  $postpar = $doc->createElement("div");
  $postpar->setAttribute('class', 'postpar');  
  $postright->appendChild($postpar);

  $message = mb_convert_encoding($message, "UTF-8", "HTML-ENTITIES");
  $messtag = $doc->createTextNode($message);
  $postpar->appendChild($messtag);
  
}

/*
  buildPage
  - load the HTML template
  - Get data from database for a topic
  - fill the template with those data
*/  

function buildPage($line, $id)
{
  global $table_prefix;
  global $forumdir;
  global $TRANSLATE_BB;
   
  $tableposts = $table_prefix."posts";   
  
  //echo "Building $id<br>";
  
  // load template
  $doc = new DOMDocument('2.0', 'UTF-8');
  $doc->preserveWhiteSpace = false;
  $doc->formatOutput   = true;  
  $docres = $doc->loadHTMLFile("template.php");
  if(!$docres) echo "Template not loaded.<br>";
  //echo $doc->saveHTML();

  // get topic title
  $title = $line['topic_title'];
  $title = mb_convert_encoding($title, "UTF-8", "HTML-ENTITIES");
  
  $metatitle = $doc->getElementsByTagName("title");
  $metatitle = $metatitle->item(0);
  $titletag = $doc->createTextNode($title);
  $metatitle->appendChild($titletag);
  
  $url = $forumdir . "/viewtopic.php?t=" . $line['id'];
  if($formatflag) $title = convert($title);
  
  // get posts data and build HTML
  $query = "SELECT poster_id, post_text, post_time FROM $tableposts WHERE topic_id='$id'";
  $resposts = mysql_query($query) or die(mysql_error());

  $comment = $doc->createComment("Generated by fluxBB2HTML");
  
  $forum = $doc->createElement("div");
  $forum->setAttribute("id", $id);
  $forum->setAttribute("class", 'forum');

  $forumtag =  $doc->createElement("div", 'Forum');
  $forumtag->setAttribute('class', 'forumtag');
  $forum->appendChild($forumtag); 
  
  $h3  =  $doc->createElement("h3", $title);
  $forum->appendChild($h3);
    
  $container = $doc->getElementById("container");
  $container->appendChild($comment);
  $container->appendChild($forum);

  while($postrow = mysql_fetch_assoc($resposts)) 
  {
     addPost($doc, $forum, $postrow);
  }
  
  $commentend = $doc->createComment("End of thread");
  $container->appendChild($commentend);
  
  // Save template with the url built from title
  $url = buildURL($title, $id);
  
  if($TRANSLATE_BB)
  {
    $content = $doc->saveHTML();
    $bbcode = array('[code]', '[/code]', '[b]', '[/b]', '[i]', '[/i]', 
      '[u]', '[/u]', '[quote]', '[/quote]', );
    $htmlcode = array('<pre>', '</pre>', '<b>', '</b>', '<i>', '</i>', 
      '<u>', '</u>','<blockquote>', '</blockquote>');

    $content = str_replace($bbcode, $htmlcode, $content);
    $content = preg_replace('/\[quote\:(.+)\]/Us', '<blockquote>', $content);
    $content = preg_replace('/\[\/quote\:(.+)\]/Us', '</blockquote>', $content);
    $content = preg_replace('/\[code\:(.+)\]/Us', '<pre>', $content);
    $content = preg_replace('/\[\/code\:(.+)\]/Us', '</pre>', $content);
    $content = preg_replace('/\[i\:(.+)\]/Us', '<i>', $content);
    $content = preg_replace('/\[\/i\:(.+)\]/Us', '</i>', $content);
    $content = preg_replace('/\[b\:(.+)\]/Us', '<b>', $content);
    $content = preg_replace('/\[\/b\:(.+)\]/Us', '</b>', $content);
    $content = preg_replace('/\[url\=(.+\:.+)\:(.+)\]/Us', '<a href="$1">', $content);    
    $content = preg_replace('/\[\/url\:(.+)\]/Us', '</a>', $content);
    file_put_contents($url, $content);
  }  
  else
    $doc->saveHTMLFile($url);
  
  echo "<a href='$forumdir/$url'>$title</a><br>";  
}

/*
  sql2HTML
  Main function
  - get data for each topic ID
  - and build a page for each
*/


function sql2html($host, $name, $user, $password, $starting, $ending)
{
    global $site;
    global $forum;
    global $topiclist;
    global $table_prefix;     // From config.php
   
     // Get the threads

    $db = mysql_connect($host, $user, $password);
    mysql_select_db($name);
 
    $tabletopics = $table_prefix."topics"; 
    
    if(intval($starting) == intval($ending))
      $condition = "((topic_id = '$starting') AND (topic_moved_id = 0))";
    else  
      $condition = "((topic_id >= '$starting') AND (topic_id <= '$ending') AND (topic_moved_id = 0))";
      
    $sql = "SELECT topic_id, topic_title, topic_moved_id FROM $tabletopics WHERE $condition ORDER BY topic_time ASC";
    $results = mysql_query($sql) or die(mysql_error());
    $size = mysql_num_rows($results);
    echo "$size thread(s) found...<br>";
    echo "Files created:<br>";
    while($topicrow = mysql_fetch_assoc($results)) 
    {
        buildPage($topicrow, $topicrow['topic_id']);
    }
    mysql_close($db);  
    echo "<hr>"; 
}

include("config.php");

if (!PHPBB_INSTALLED) die("phpBB not installed in $forumdir");

$forumdir = $_POST['url'];
$pos = strrpos($forumdir, "/");
$forumdir = substr($forumdir, 0, $pos);

$starting = $_POST['starting'];
if($starting != false)
{
  $ending = $_POST['ending'];
  if($ending == false)
    $ending = $starting;
  sql2html($dbhost, $dbname, $dbuser, $dbpasswd, $starting, $ending);
}       

?>

<!DOCTYPE html>
<html>
<head>
<meta charset=utf-8>
<title>phpBB to HTML</title>
</head>
<script>
function makeupd(value)
{
	var utag = document.getElementById("url");
	var url = forumdir + "/viewtopic.php?t="  + value;
  utag.value = url;
}

var forumdir = location.protocol + "//" + location.host + location.pathname;  
var scriptname = location.href;
var pos = forumdir.lastIndexOf('/');
forumdir = forumdir.slice(0, pos);
</script>
<body>
<?php
echo "PHP version ", phpversion(), " (5 is required)<br>";
?>
<h1>fluxBB to HTML</h1>
<p>Enter the ID of a post or a range (displaying in the URL in the bar)</p>
<form method="post" action="<?php echo $scriptname?>">
  <p>ID from  <input type="text" name="starting" value="" onkeyup="makeupd(this.value)"> to 
		  <input type="text" name="ending"   value="">
  </p>
  <p>URL  <input type="text" name="url" id="url" value="" size="64"> </p>
  <p><input type="submit" name="Submit" value="Convert"></p>
</form>
</body>
</html>
