/*
   XML to JS
   (c) 2015 Denis Sureau/Scriptol.com/Scriptol.org
   License MIT

   Load an XML file to a JavaScript objects and
   save an object to an XML file.
*/


var fs = require('fs');

/*
  Search for a sub-object with some id.
  Return the sub-object.
*/

function getById(d, idval) {
  for(var k in d) {
    if(typeof d[k] === "object") {
      var dsub = d[k];
      if("id" in dsub && dsub.id == idval) return d;
      var dret = getById(dsub, idval)
      if(dret !== false) return dret;
    }
  }
  return false
}

/*
  Load and convert to object
*/  

function loadXML(filename)
{
  var data = fs.readFileSync(filename).toString("utf8");
  var sax = require("sax");
  
  var parser = sax.parser(true, { trim:true });
  parser.onerror = function (e) {
    console.log("XML error: ", e.toString());
    return{};
  };

  var ctag = null;
  var xmlroot = null;
  
  parser.ontext = function (t) {
      if (ctag && t.length > 0) { 
          ctag["data"] = t;
      }   
  }    
  
  parser.onopentag = function (node) {
    var name = node.name;
    var parent = ctag;
    ctag = {};
    ctag.array = [];
    ctag.idFlag = false;   // same tags at same level

    if (xmlroot === null) {
      xmlroot = {};
      xmlroot[name] = ctag;
    }
    else
    {
      ctag.parent = parent;
      var xtag = {};
      xtag[name]= ctag;
      parent.array.push(xtag);
    }
    
    for(var k in node.attributes) {
      ctag[k] = node.attributes[k];
    }
    // check ident. tag
    while(parent && !parent.idFlag) 
    {
        for(var i=0; i < parent.array.length - 1; i++) 
        {
           var elem = parent.array[i];
           for(var key in elem) 
           {
            if(key == name) parent.idFlag=true;
            break;
           }
        }
        break;
    }  
  };
  parser.onclosetag = function(name) {
    if(ctag.idFlag == false) // only one child / all childs different
    {
        for(var i = 0; i < ctag.array.length; i++) {
          var xtag = ctag.array[i];
          for(var u in xtag) {
              ctag[u]=xtag[u];
          } 
        }
        delete ctag.array;
     }
    delete ctag.idFlag;
    if (ctag.parent) {
        var parent = ctag.parent;
        delete ctag.parent;
        ctag = parent;
    }
  }

  parser.write(data).end();
  return xmlroot;
}

/*
  Convert to XML and save
*/  

var XMLStorage = "";
function xmlSub(d, name) 
{
  var flag = true;
  if(name=='array') {
    for(var i = 0; i < d.length; i++)
    {
        var tag = d[i];
        var o;
        for(var k in tag) { o = tag[k]; break; }
        XMLStorage += "<" + k;
        flag = xmlSub(o, k);
        XMLStorage += "</" + k + ">\n";
        if(flag) XMLStorage += ">\n";
    }  
    return false;
  }
  for(var x in d)
  {
    if (d[x] instanceof Object || typeof d[x] == "object") {
      if(flag) XMLStorage += ">\n";
      if(x != 'array')
        XMLStorage += "<" + x;
      flag = xmlSub(d[x], x);
      if(flag)  XMLStorage += ">\n";
      if(x != 'array')
        XMLStorage += "</" + x + ">\n";
      flag = false;      
      continue;
    }
    if (x == "data") { 
      XMLStorage += ">" + d[x];
      flag = false;
    }  
    else { 
      XMLStorage += " " + x + "=\""+ d[x] + "\"";
      flag = true;
    }    
  }
  return flag;  
}

function saveXML(d, filename) 
{
  XMLStorage = '<?xml version="1.0" encoding="UTF-8"?>';
  if(xmlSub(d)) XMLStorage += ">\n";
  fs.writeFileSync(filename, XMLStorage);
}

/*
    Demo
*/

var filename = "test.xml";
var obj = loadXML(filename)

console.log("Loaded:")
console.log(JSON.stringify(obj, null, ' '))

var val = getById(obj, "idc");
console.log("\nThis element has id='idc':")
console.log(JSON.stringify(val, null, ' '))

obj['Car']['Travel']['array'][2]['Passenger']['data'] = "Lambda";

saveXML(obj, "test2.xml")

console.log("File 'test2.xml' created with a new passenger.");

