<?php

/*
     Scriptol Gallery Generator
     (c) Scriptol.com
     Licence: GPL 3.0
    
    Input:
    - Directory of the images.
    - Title of the page (optional).
    - Name of the file to create.
    - Number of columns (1 column for a vertical gallery).
    - Website path.
    
*/


$galist = array();
$title = "";
$page = "";
$fhandle = false;
$icount = 0;
$extlist = array("jpg", "jpeg", "gif", "png");

function disp($str)
{
   global $fhandle;  

   fwrite($fhandle, $str."\n");
   return;
}


function generate()
{
    global $page;
    global $galist;
    global $title; 
    global $columns;  
    global $fhandle;
    global $icount;

    $data = "";

    $fhandle = fopen($page, "w");
    if($fhandle == false)
       die("Enable to create $page");    
 

    disp('<html><head>');
    if($title)
      disp('<title>'.$title.'</title>');
    disp('<link type="text/css" href="gallery.css" rel="stylesheet"></head>');
    disp('<body>');
    disp('<div id="content">');
    if($title)
      disp('<h1>'.$title.'</h1>');
     
    $colctr = 0;      
    foreach($galist as $img)
    {
      $data .= '<img class="thumb" src="'.$img.'" />';
      if(($columns > 0) && (++$colctr >= $columns))
      {
        $data .= '<br>';
        $colctr = 0;
      } 
      $icount ++; 
    }  
    disp($data);
    disp('</div>');
    disp('</body></html>');
    
    if($infile) fclose($fhandle);
}    


function isImage($url)
{
  global $extlist;
      
  $ext = strrchr($url, ".");
  if($ext == false || $ext == "") return false;
  $ext = substr($ext, 1);
  return (in_array($ext, $extlist, true));
}  


function getImages($currdir)
{
  global $webroot;
  global $galist;

  $dircontent = opendir($currdir);
  
  while ($fname = readdir($dircontent))
  {
    if($fname == '.' ) continue; 
    if($fname == '..') continue;

    //$fullpath = $currdir . $fname;
    $fullpath = $fname;
    if (is_dir($fullpath)) continue;
    if(!isImage($fullpath)) continue;

    //$relname = substr($fullpath, $locroot);
    $relname = $fname;                       
    $webname = $webroot.$relname;
    array_push($galist,$webname);
  }
  
  closedir($dircontent);   

}

function syntax()
{
  print "Gallery Generator 1.0\n";
  print "(c) 2009 Scriptol.com - Command Line version - GPL 3.0\n";
  print "Syntax: php galgen.php [parameters] pagename.html\n";
  print "Parameters:\n";
  print "-c  then numbers of columns\n";
  print "-t  then a title\n";
  print "-w  then site root\n";
  print "-d  then directory. Default current.";
  exit(0);
}    
    
function main($argc, $argv)
{
  global $columns;
  global $title;
  global $page;
  global $webroot;
  global $fhandle;
  global $icount;

  $columns = 999;
  $title = "";
  $page = "";
  $dir = ".";
  
  if($argc < 2)
  {
    syntax();
  }
  
  if($title) print "Title: $title\n";
  
  array_shift($argv);
  while(count($argv) > 0)
  {
    $arg = array_shift($argv);
    if($arg[0] == "-" || $arg[0] == "/")
    {
      $value = substr($arg, 2);
      switch($arg[1])
      {
        case "c": $columns = intval($value);
                  break;
        case "t": $title = $value;          
                  break;
        case "w": $webroot = $value;          
                  break;
        case "d"; $dir = $value;
                  break;                  
                    
      }
    }
    else
    {
      if($page != "") syntax;
      $page = $arg;
    }
  }
  
  getImages($dir);
  generate();

  if($fhandle)
  {
    $plutal = ($columns > 1) ? "s" : "";
  
    print "$page generated with $icount images on ";
    if($columns == 999)
      print "1 row.";
    else
      print "$columns column$plural.";
    print "\n";    
  }

}


main($argc, $argv);   


?>
