/*
    Add Attributes to an XML Document
    addatt.sol
    A script to add an attribute to each element for a given tag of an XML file
    (c) 2009 Scriptol.com
    MIT License - Use it freely
    
    Note: target file may be the source file, but an intermediate file, test.xml, is used for security
          remove the value of the targetfile variable to update directly the source file:
          text targetfile = ""  
    
*/


include "dom.sol"

text targetfile = "test.xml"

void usage()
  print "Syntax"
  print "  solp addatt fname tname aname"
  print "Attribute 'aname' is added to any 'tname' tag in the 'fname' XML file."
  exit(0)
return

void addAttribute(text srcname, text tgtname, text tname, text aname)

  DOMDocument docsrc = DOMDocument("1.0")
  docsrc.load(srcname)
  
  DOMNodeList dnl = docsrc.getElementsByTagName(tname)	
  int size = dnl.length
  DOMElement de = null
  int i = 0
	
  while i < size
	de = dnl.item(i)
    de.setAttribute(aname, "")
  let i + 1

  docsrc.save(tgtname)

return 

int main(int argc, array argv)

   if argc < 4 ? usage()
   
   text fname = argv[1]
   text tname = argv[2]
   text aname = argv[3]
   
   if targetfile = "" let targetfile = fname
   
   print "Loading '$fname', adding '$aname' attribute to each '$tname' tag."
   
   addAttribute(fname, targetfile, tname, aname)  
   print "Type $targetfile to view the resulting file." 
return 1


main($argc, $argv)

