import java.sql.SQLException;

public class Main {
    public static void main(String[] args) {
        try (var connection = SQLServerConnection.connect()) {
            var authorDB = new AuthorDB(connection);
            var authors = authorDB.find(5, 0);
            for(var author: authors) {
                System.out.println(author.getAuthorId() + " - " + author.getFirstName() + ", " + author.getLastName());
            }
        } catch (SQLException | DBException e) {
            System.err.println(e.getMessage());
        }
    }
}