<!DOCTYPE html>
<html lang="en">

<head>
    <title>Index page</title>
    <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">
    <style>
        #event,
        #code,
        #result {
            margin-left: 16px;
        }
        
        .line-hgt {
            line-height: 2.0;
        }
    </style>
</head>

<body>
    <div class="container">
        <h2 align="center" class="text-danger">Events in JavaScript</h2>
        <hr />

        <!-- Javascript events tutorial -->
        <div class="form-group">
            <div id="event">
                <h4 class="text-primary font-weight-bold">What is an event?</h4>
                <ol class="text-info line-hgt">
                    <li>An event is a signal from the browser that something has happened or something that a user does.</li>
                    <li>For e.g.:
                        <ul>
                            <li>A webpage has finished loading</li>
                            <li>An input field is changed</li>
                            <li>A button is clicked</li>
                        </ul>
                    </li>
                    <li>Javascript language provides several ways to connect an event handler to an event. These ways are:
                        <ul>
                            <li>Using HTML tag attributes</li>
                            <li>Using DOM object property</li>
                            <li>Using special methods such as <code>addeventlistener()</code></li>
                        </ul>
                    </li>
                </ol>
            </div>
            <!-- Input form -->
            <div id="code">
                <h4 class="text-sucess">Code Snippet</h4>
                <div>&nbsp;</div>
                <div id="myform">
                    <div class="form-group">
                        <label for="name">Name:</label>
                        <input type="text" class="form-control" id="name" onblur="validate('name')">
                    </div>
                    <button id="btn_submit" type="button" class="btn btn-default" onmouseover="mouseover();" onmouseout="mouseout();" onclick="submit();">Submit</button>
                </div>
            </div>
        </div>
        <div>&nbsp;</div>

        <!-- Result -->
        <h5 id="result" class="text-info"></h5>
    </div>
    <script>
    	// Mouseover function
        function mouseover() {
            var mover = document.getElementById("btn_submit");
            mover.style.background= 'blueviolet';
            mover.style.color= 'white';
        }

     	// Mouseout function
        function mouseout() {
            var mout = document.getElementById("btn_submit");
            mout.style.background= 'gainsboro';
            mout.style.color= 'black';
        }

     	// Blur function
        function validate(id) {
            var input = document.getElementById(id);
            if (input.value == "") {
                input.style.color= '#e52213';
                input.style.border= 'solid';
            } else {
                input.style.color= '#00ff99';
                input.style.border= 'solid';
            }
        }

     	// Form submit function
        function submit() {
            alert("Form submitted.");
        }
    </script>
</body>

</html>