<!DOCTYPE html>
<html lang="en">

<head>
    <title>Index page</title>
    <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.2.1/css/bootstrap.min.css">
</head>

<body>
    <div class="container">
        <h2 align="center" class="text-muted">Array Iteration Methods in JavaScript</h2>
        <hr />

        <!-- JavaScript Array Iteration Methods Example -->
        <div id="title">
            <h5 class="font-weight-normal"><mark>Array Iteration Methods</mark> in javascript operate on every element of an array. The table below explains the different methods.</h5>
            <div>&nbsp;</div>

            <table class="table table-bordered">
                <thead>
                    <tr class="text-center">
                        <th scope="col">Method</th>
                        <th scope="col">Description</th>
                        <th scope="col">Example</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><code>Array.forEach()</code></td>
                        <td>This method calls a callback function once for each array element.</td>
                        <td><code>myarray.forEach(myfunction);</code></td>
                    </tr>
                    <tr>
                        <td><code>Array.map()</code></td>
                        <td>This method creates a new array by performing a function on each element of the array. It does not change the original array.</td>
                        <td><code>myarray.forEach(myfunction);</code></td>
                    </tr>
                    <tr>
                        <td><code>Array.filter()</code></td>
                        <td>This method creates a new array with elements that pass the test.</td>
                        <td><code>myarray.filter(myfunction);</code></td>
                    </tr>
                    <tr>
                        <td><code>Array.reduce()</code></td>
                        <td>This method runs a function on each element to produce a single value and it works from <em>left-to-right</em> in the array. Do <em>note</em>, this method does not reduce the original array.</td>
                        <td><code>myarray.reduce(myfunction);</code></td>
                    </tr>
                    <tr>
                        <td><code>Array.reduceRight()</code></td>
                        <td>This method runs a function on each element to produce a single value and it works from <em>right-to-left</em> in the array. Do <em>note</em>, this method does not reduce the original array.</td>
                        <td><code>myarray.reduceRight(myfunction);</code></td>
                    </tr>
                    <tr>
                        <td><code>Array.every()</code></td>
                        <td>This method checks if all the values of an array pass the test.</td>
                        <td><code>myarray.every(myfunction);</code></td>
                    </tr>
                    <tr>
                        <td><code>Array.some()</code></td>
                        <td>This method checks if some values of an array pass the test.</td>
                        <td><code>myarray.some(myfunction);</code></td>
                    </tr>
                    <tr>
                        <td><code>Array.find()</code></td>
                        <td>This method returns the value of the first array element that pass a test function.</td>
                        <td><code>myarray.find(myfunction);</code></td>
                    </tr>
                    <tr>
                        <td><code>Array.findIndex()</code></td>
                        <td>This method returns the index of the first array element that pass a test function.</td>
                        <td><code>myarray.findIndex(myfunction);</code></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <script type="text/javascript">
        // Array iteration methods.
        // forEach() method.
        [1, 2, 3].forEach(function(item, index) {
            console.log(item, index);
        });

        // map() method.
        const three = [1, 2, 3];
        const doubled = three.map(function(item) {
            return item * 2;
        });
        console.log("map()= " + doubled);

        // filter() method.
        const ints = [1, 2, 3];
        const evens = ints.filter(function(item) {
            return item % 2 === 0;
        });
        console.log("filter()= " + evens);

        // reduce() method.
        const sum = [1, 2, 3].reduce(function(result, item) {
            return result + item;
        }, 0);
        console.log("reduce()= " + sum)

        // some() method.
        const hasNegativeNumbers = [1, 2, 3, -1, 4].some(function(item) {
            return item < 0;
        });
        console.log("some()= " + hasNegativeNumbers);

        // every() method.
        const allPositiveNumbers = [1, 2, -3].every(function(item) {
            return item > 0;
        });
        console.log("every()= " + allPositiveNumbers);

        // find() method.
        const objects = [{
            id: 'a'
        }, {
            id: 'b'
        }, {
            id: 'c'
        }];
        const found = objects.find(function(item) {
            return item.id === 'b';
        });
        console.log(found);

        // findIndex() method.
        const objects2 = [{
            id: 'a'
        }, {
            id: 'b'
        }, {
            id: 'c'
        }];
        const foundIndex = objects2.findIndex(function(item) {
            return item.id === 'b';
        });
        console.log(foundIndex);
    </script>
</body>

</html>