function act_p = activateISA(input, network_isa, pa_layer)

% Function to forward propagate in the ISA network to obtain features
% input:       input data, assumed 16x16x10 video blocks vectorized, 
%              col example
% network_isa: isa data structure as provided in bases/
% pa_layer:    optional stuct to specify low and high thresholds for 
%              network activation

if nargin<3
   pa_layer.type = 'lhthresh';
   pa_layer.lowthresh = 0;
   pa_layer.highthresh = 1;
end

sq_vec = @(v)(v.^2);
sqrt_vec = @(v)(sqrt(v));

act_w = activateNN(input, network_isa.W, single(0), sq_vec, pa_layer);    
    
act_p = activateNN(act_w, network_isa.H, single(1e-4), sqrt_vec, pa_layer);

end
