function act_out = activateNN(act_in, W, bias, act_func, pa_layer)

% funciton to feed forward one layer of neural network
% act_in and act_out are column vectors
% act_func needs to handle vectors

if ~exist('pa_layer','var')
    pa_layer.type = 'none';        
end

if isfield(pa_layer, 'usegpu')
%    W = gsingle(W);
   bias = gsingle(bias);
   act_in = gsingle(act_in);
end

z_out = W*act_in + bias;

act_out = single(act_func(z_out));

%% post activation processing
if strcmp(pa_layer.type, 'lhthresh')
    act_out(act_out > pa_layer.highthresh) = pa_layer.highthresh;
    act_out(act_out < pa_layer.lowthresh) = 0;
elseif strcmp(pa_layer.type, 'hthresh')
    act_out(act_out > pa_layer.highthresh) = pa_layer.highthresh;
elseif strcmp(pa_layer.type, 'lthresh')
    act_out(act_out < pa_layer.lowthresh) = 0;
elseif strcmp(pa_layer.type, 'maxnorm')
%   act_out = bsxfun(@rdivide, act_out, max(abs(act_out)));
    act_out(act_out > pa_layer.highthresh) = pa_layer.highthresh;
elseif strcmp(pa_layer.type, 'l1norm') %all +ve
    act_out(act_out > pa_layer.highthresh) = pa_layer.highthresh;
%     act_out = bsxfun(@rdivide, act_out, sum(abs(act_out), 1));
end

end
