function features = compute_features(input, l1_isanetwork, l2_isanetwork, gpu)

% Function to forward propagate in the 2 layer stacked ISA network to obtain features
% input:       input data matrix in the following form:
%              - 20x20x14 gray-scale video blocks
%              - data normalized to range [0, 1]
%              - vectorized and column exampled
%                (dimensions:5600xnum_samples)
%              
% l1_isanetwork: isanetwork loaded from 'bases/isa1layer_16_10_300_1.mat';
% l2_isanetwork: isanetwork loaded from 'bases/isa2layer_16t20_ts10t14_nf200_gs2_st4t4_l1_isa1layer_16_10_300_1.mat';

addpath activation_functions
if gpu
    fprintf('please addpath to /**/jacket/engine/');
%     addpath /**/jacket/engine/;
end

% set block sizes for layer 1 and layer 2
l1_isanetwork{1}.fovea.spatial_size = 16;
l1_isanetwork{1}.fovea.temporal_size = 10;
l2_isanetwork{1}.fovea.spatial_size = 20; 
l2_isanetwork{1}.fovea.temporal_size = 14;

l1_isanetwork{1}.spatial_stride = 4;
l1_isanetwork{1}.temporal_stride = 4;

% set activation thresholds
post_act.layer1.type = 'lhthresh';
post_act.layer1.lowthresh = 0;
post_act.layer1.highthresh = 1;
if gpu
   post_act.layer1.gpu = 1; 
end

post_act.layer2.type = 'lhthresh';
post_act.layer2.lowthresh = 0;
post_act.layer2.highthresh = 1;
if gpu
   post_act.layer2.gpu = 1; 
end

features = activate2LISA(input, l1_isanetwork{1}, l2_isanetwork{1}, 5e3, post_act);
