function features = compute_features_1layer(input, l1_isanetwork, gpu)

% Function to forward propagate in the 1 layer stacked ISA network to obtain features
% input:       input data matrix in the following form:
%              - 16x16x10 gray-scale video blocks 
%              - data normalized to range [0, 1]
%              - vectorized and column exampled
%                (dimensions:5600xnum_samples)
% l1_isanetwork: isanetwork loaded from 'bases/isa1layer_16_10_300_1.mat';

addpath activation_functions

if gpu
    fprintf('please addpath to /**/jacket/engine/');
%     addpath /**/jacket/engine/;
end

pa_layer.type = 'lhthresh';
pa_layer.lowthresh = 0;
pa_layer.highthresh = 1;

if gpu
    pa_layer.gpu = 1;
end

features = activateISA(input, l1_isanetwork{1}, pa_layer);
