%%% example script: learn Independent Subspace Analysis features for images
%%% code is adapted from Natural Image Statistics (2009)

%% load image patches (16x16)
%% you could download this data from ai.stanford.edu/wzou/isaimage/testdata.mat
load testdata.mat d

% remove DC component (remove mean across the dataset)
d = removeDC(d);

% perform ZCA whitening
[V, E, D] = pca(d);
WhitenFilter = E*V;
d = WhitenFilter*d;

% start running the ISA algorithm
num_features = 50; %% ISA is able to learn up to 256 features for
                   %% 256 dimensions (16x16) 
group_size = 2; maxiter = 1000;
W = isa_est(d, num_features, group_size, maxiter);

% pre-multiply ISA matrix with whitening filter
Weights = W*WhitenFilter;

% plot results
figure; plotrf(Weights', 10, './testimg.png');

%% note: to extract features, vectorize data 'd' to column example
%% and use formula: f = sqrt(H*(Weights*d).^2);
%% where H is the subspace matrix: 
%% H=subspacematrix(num_features, group_size);

%% this code can also be easily adapted to color images
%% usually, we vectorize all 3 color channels; for instance if each
%% of color image patch in the training data is 16x16x3 (RGB), 
%% the input vectorized data matrix will be of dimensions 768 X
%% num_examples
