
float[] ACCEL_SCALES = new float[] {
  160,  // X
  162,  // Y
  140,  // Z
};

class _Esplora {
  /*
   * The Processing main thread reads the input data, the serial thread
   * writes them. As long as all variables are independent from each
   * other (i.e. there is no inconsistent state), I just ignore
   * synchronization issues and just declare the input variables
   * as volatile to disable any form of caching.
   */
  volatile boolean switch1;
  volatile boolean switch2;
  volatile boolean switch3;
  volatile boolean switch4;
  
  volatile float joystickX;
  volatile float joystickY;
  volatile boolean joystickSwitch;

  volatile float accelX;
  volatile float accelY;
  volatile float accelZ;

  volatile float mic;
  volatile float slider;
  volatile float light;
  volatile float temperatureC;

  volatile float ledR;
  volatile float ledG;
  volatile float ledB;
  volatile int tone;
  

  public boolean switches(int sw) {
    switch(sw) {  // no pun intended :)
    case 0: return switch1;
    case 1: return switch2;
    case 2: return switch3;
    case 3: return switch4;
    }
    return false;
  }

  /**
   * List of valid serial ports. If at startup there's a port named
   * like one of them, that will be used.
   * Maybe a more general approach is better.
   */
  final String[] SERIAL_PORT_NAMES = {
    "/dev/ttyACM0", 
    "/dev/ttyACM1", 
    "/dev/tty.usbmodemfd131", 
    "/dev/tty.usbmodemfa131", 
    "/dev/tty.usbmodemfd121", 
    "/dev/tty.usbmodemfa121",
    "COM6",
    "COM7"
  };

  Serial serial = null;
  StringBuilder serialRow;


  public void begin(PApplet applet) {
    String[] serialList = Serial.list(); 

    if (serialList.length >= 1) {
      try {
        for (String portNameA : serialList) {
          for (String portNameB : SERIAL_PORT_NAMES) {
            if (portNameB.equals(portNameA)) {
              serial = new Serial(applet, portNameA, 9600);
              println("found serial port: " + portNameA);
              break;
            }
          }
        }
      }
      catch (Exception e) {
        println("Serial port open error: " + e.toString());
      }
    }
  }

  public void update() {
    if (serial == null)
      return;
      
    String s = String.format("D\nR%d\nG%d\nB%d\nT%d\n",
      (int)(constrain(ledR*256, 0, 255)),
      (int)(constrain(ledG*256, 0, 255)),
      (int)(constrain(ledB*256, 0, 255)),
      tone
    );

    serial.write(s);
    delay(10);
    if (serial.available() == 0)
      return;

    String line = serial.readStringUntil('\n');
    if (line == null)
      return;
    
    line = line.trim();

    String[] fields = line.split(",");
    if (fields.length != 14) {
      println("nodump: " + line);
      return;
    }
    
    int[] values = new int[fields.length];
    for (int i=0; i<values.length; i++) {
      values[i] = Integer.parseInt(fields[i]);
    }
    
    switch1 = values[0] == 0;
    switch2 = values[1] == 0;
    switch3 = values[2] == 0;
    switch4 = values[3] == 0;

    joystickSwitch = values[8] == 0;
    joystickX = -((float)values[9]/1024);
    joystickY =   (float)values[10]/1024;
    
    int aX = values[11];
    int aY = values[12];
    int aZ = values[13];
    accelX = aX / ACCEL_SCALES[0];
    accelY = aY / ACCEL_SCALES[1];
    accelZ = aZ / ACCEL_SCALES[2];
    
    mic = (float)values[7] / 1024;
    slider = (float)values[4] / 1024;
    light = (float)values[5] / 1024;
    temperatureC = values[6];
  }
}

_Esplora Esplora = new _Esplora();

