

boolean lastPressed = false;
int startDragX = 0;
int startDragY = 0;

boolean draggingLed = false;
boolean draggingTone = false;

final int slideBarHeight = 40;
final int slideBarWidth  = 250;

final int toneSliderX = 50;
final int toneSliderY = 50;

final int rgbSlidersX = 700;
final int rgbSlidersY = 500;

abstract class SlideControl {
  float value = 0;
  float valueDragging = value;
  color col;
  SlideControl(color col) {
    this.col = col;
  }
  void beginDrag() { valueDragging = value; }
  void endDrag()   { value = valueDragging; }
  
  abstract void send();
}

class ToneSlideControl extends SlideControl {
  ToneSlideControl() {
    super(color(255,255,255));
  }
  void send(){
    Esplora.tone=(int)(valueDragging*2000);
  }
  void beginDrag() {
    Esplora.tone=(int)(value*2000);
    super.beginDrag();
  }
  void endDrag() {
    Esplora.tone=0;
    super.endDrag();
  }
}

SlideControl[] rgbControls = new SlideControl[] {
  new SlideControl(color(255, 0, 0)) {void send(){Esplora.ledR=valueDragging;}},
  new SlideControl(color(0, 255, 0)) {void send(){Esplora.ledG=valueDragging;}},
  new SlideControl(color(0, 0, 255)) {void send(){Esplora.ledB=valueDragging;}},
};

SlideControl toneControl = new ToneSlideControl();

void handleInputControls() {

  if (mousePressed) {
    if (mouseX > rgbSlidersX && mouseX < rgbSlidersX + slideBarWidth) {
      for (int i=0; i<rgbControls.length; i++) {          
        SlideControl rc = rgbControls[i];
        if (mouseY > rgbSlidersY + i * slideBarHeight - slideBarHeight/2
         && mouseY < rgbSlidersY + i * slideBarHeight + slideBarHeight/2) {
           rc.valueDragging = (mouseX - rgbSlidersX) / (float)slideBarWidth;
           rc.send();
        }
      }
    }

    if (mouseY > toneSliderX && mouseX < toneSliderX + slideBarWidth) {
      if (mouseY > toneSliderY - slideBarHeight/2
       && mouseY < toneSliderY + slideBarHeight/2) {
         toneControl.valueDragging = 
           (mouseX - toneSliderX) / (float)slideBarWidth;
         toneControl.send();
      }
    }    
  }
  else
    toneControl.endDrag();

  
  /*
   * Tone slider
   */
  pushStyle(); pushMatrix();
  {
    translate(toneSliderX, toneSliderY);
    drawSliders(new SlideControl[]{toneControl});
  }
  popMatrix(); popStyle();

  /*
   * Color sliders
   */
  pushStyle(); pushMatrix();
  {
    translate(rgbSlidersX, rgbSlidersY);
    drawSliders(rgbControls);
  }
  popMatrix(); popStyle();

}

void drawSliders(SlideControl[] controls) {
  for (int i=0; i<controls.length; i++) {
    SlideControl c = controls[i];
    pushMatrix();
    {
      translate(0, i*slideBarHeight);
      //rect(0, -slideBarHeight/2, slideBarWidth, slideBarHeight);
      gradientRect(
        0, -slideBarHeight/2, 
        slideBarWidth, slideBarHeight,
        color(0,0,0), c.col);

      translate(slideBarWidth*c.valueDragging, 0);
      stroke(255);
      line(0, -slideBarHeight/2, 0, slideBarHeight/2);
    }
    popMatrix();
  }
}

void gradientRect(int l, int t, int w, int h, color c1, color c2) {
  for (int x=l; x<w; x++) {
    float inter = map(x, l, l+w, 0, 1);
    color c = lerpColor(c1, c2, inter);
    stroke(c);
    line(x, t, x, t+h);
  }
}
