import processing.serial.*;

final int WIDTH = 1162;
final int HEIGHT = 652;

final int margin = 20;
final int boardRatio = 2;
final int b_width = WIDTH - boardRatio*margin;
final int b_height = b_width/3;

final int middleY = margin+b_height/2;

final int jsCenterX = 255;
final int jsCenterY = 289;
final int jsOuterRadius = 80;
final int jsInnerRadius = 60;
final int jsSwing   = 60;

final int switchLeft      = 787;
final int switchesCenterX = 849;
final int switchRight     = 910;
final int switchTop       = 231;
final int switchesCenterY = 290;
final int switchBottom    = 351;
final int switchRadius    = 20;

final int accelCenterX = 549;
final int accelCenterY = 289;
final int accelBarHeight = 20;
final int accelBarWidth  = 50;

final int micCenterX = 377;
final int micCenterY = 419;
final int micRadiusOffset = 10;
final float micRadiusScale = 50;

final int sliderLeft = 448;
final int sliderRight = 645;
final int sliderY = 419;
final int sliderCursorHeight = 12;
final int sliderCursorWidth  = 35;

final int lightCenterX = 765;
final int lightCenterY = 167;
final int lightRadius = 10;
final float lightScale = 70;

final int ledCenterX = 720;
final int ledCenterY = 419;
final int ledRadius = 10;

final int buzzCenterX = 336;
final int buzzCenterY = 167;
final int buzzRadius = 30;

final int tempCenterX = 549;
final int tempCenterY = 351;

PImage esploraBkg;

void setup() {
  size(WIDTH, HEIGHT);

  esploraBkg = loadImage("esplora.png");

  Esplora.begin(this);
  
  for (SlideControl rc : rgbControls) {
    rc.send();
  }
}



void draw() {
  Esplora.update();
  
  background(255);
  ellipseMode(RADIUS);

  /*
   * Esplora drawing
   */
  image(esploraBkg, 0, 0);

  pushMatrix(); 
  {
    translate(jsCenterX, jsCenterY);

    /*
     * Joystick, static part
     */
    fill(64);
    ellipse(0, 0, jsOuterRadius, jsOuterRadius);
 
    /*
     * Joystick, dynamic part
     */
    if (Esplora.joystickSwitch)
      fill(255, 0, 0);
    else
      fill(0, 0, 0);    
    ellipse(Esplora.joystickX * jsSwing, 
    Esplora.joystickY * jsSwing, 
    jsInnerRadius, jsInnerRadius);
  } 
  popMatrix();

  /*
   * Switches
   */
  int[][] switchMap = new int[][] {
    { switchesCenterX, switchBottom }, 
    { switchLeft     , switchesCenterY }, 
    { switchesCenterX, switchTop }, 
    { switchRight    , switchesCenterY }, 
  };
  pushMatrix(); 
  {
    for (int i=0; i<switchMap.length; i++) {
      pushMatrix(); 
      {
        translate(switchMap[i][0], switchMap[i][1]);
        if (Esplora.switches(i))
          fill(255, 0, 0);
        else
          fill(0, 0, 0);
        ellipse(0, 0, switchRadius, switchRadius);
      } 
      popMatrix();
    }
  } 
  popMatrix();

  /*
   * Accelerometer's axes
   */
  pushMatrix(); 
  {
    translate(accelCenterX, accelCenterY);

    fill(192);
    drawAccelBar(Esplora.accelX);
    rotate(-PI/2);
    drawAccelBar(Esplora.accelY);
    rotate(-PI/2-PI/4);
    drawAccelBar(Esplora.accelZ);
    
    fill(0);
  } 
  popMatrix();
  
  
  /*
   * Microphone
   */
  pushMatrix();
  {
    translate(micCenterX, micCenterY);
    float radius = micRadiusOffset + Esplora.mic*micRadiusScale;
    ellipse(0, 0, radius, radius);
  }
  popMatrix();
  
  
  pushMatrix(); pushStyle();
  {
    /*
     * Linear potentiometer, static part
     */
    final int sliderWidth = sliderRight - sliderLeft;
    //line(sliderLeft, sliderY, sliderRight, sliderY);
    
    /*
     * Linear potentiometer, dynamic part
     */
    fill(143, 121, 99);
    translate(sliderLeft + (1-Esplora.slider) * sliderWidth, sliderY);
    rect(
      -sliderCursorWidth/2, -sliderCursorHeight/2, 
       sliderCursorWidth,    sliderCursorHeight);
    
  }
  popStyle(); popMatrix();
  
  /*
   * Light sensor
   */
  pushMatrix(); pushStyle();
  {
    translate(lightCenterX, lightCenterY);
    noStroke();
    
    float l = Esplora.light; 
    scale(l);
    for (float r = 1; r > 0; r -= .05f) {
      fill(l*(1-r)*255, l*(1-r)*255, l*(1-r)*255, (1-r)*255);
      ellipse(0, 0, r*lightScale, r*lightScale);
    } 
    
  }
  popStyle(); popMatrix();
  
  /*
   * Temperature sensor
   */
  pushMatrix(); pushStyle();
  {
    translate(tempCenterX, tempCenterY);
    scale(2);
    fill(255);
    textAlign(CENTER, CENTER);
    text((int)Esplora.temperatureC, 0, 0);
    textAlign(LEFT, CENTER);
    text("  °C", 0, 0);
  }
  popStyle(); popMatrix();
  
  
  handleInputControls();
}

void drawAccelBar(float value) {
  pushMatrix(); 
  {
    translate(accelBarHeight/2,0);
    rect(0, -accelBarHeight/2, accelBarWidth*value, accelBarHeight);
  }
  popMatrix();
}


