package com.javacodegeeks.snippets.enterprise.services;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;


public class Employee {
	
	private Long id;

	private String position;
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
	
	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}
	
	@Override
	public String toString(){
		return "id "+ id + " and position " + position;
	}

	@PostConstruct
	public void initIt() throws Exception {
		  System.out.println("Init method after properties are set : " + id + " " + position);
		}
	
	@PreDestroy
	public void cleanUp() throws Exception {
		  System.out.println("Spring Clean Up! Employee is cleaned up now.");
		}
}
