/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.InvalidPropertyValueException;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.TopicConnectionFactory;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.XAQueueConnectionFactory;
import com.sun.messaging.XATopicConnectionFactory;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryListCObj;
import com.sun.messaging.jmq.admin.apps.console.event.ObjAdminEvent;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.Frame;
import java.util.Properties;
import javax.jms.JMSException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class ObjStoreConFactoryAddDialog
extends ObjStoreConFactoryDialog {
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private ObjStoreConFactoryListCObj osCObj;

    public ObjStoreConFactoryAddDialog(Frame parent) {
        super(parent, acr.getString("A1130"), 89);
        this.setHelpId("add_connection_fact");
    }

    @Override
    public void doOK() {
        String lookupName = this.lookupText.getText();
        if ((lookupName = lookupName.trim()) == null || lookupName.equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3000"), acr.getString("A1130") + ": " + acr.getString("A1218", "A3000"), 0, 0, null, close, close[0]);
            return;
        }
        int type = 7;
        ConnectionFactory tempObj = null;
        String factory = (String)this.factoryCombo.getSelectedItem();
        if (factory.equals(acr.getString("A1203"))) {
            type = 3;
            tempObj = new QueueConnectionFactory();
        } else if (factory.equals(acr.getString("A1204"))) {
            type = 4;
            tempObj = new TopicConnectionFactory();
        } else if (factory.equals(acr.getString("A1235"))) {
            type = 7;
            tempObj = new ConnectionFactory();
        } else if (factory.equals(acr.getString("A1232"))) {
            type = 5;
            tempObj = new XAQueueConnectionFactory();
        } else if (factory.equals(acr.getString("A1233"))) {
            type = 6;
            tempObj = new XATopicConnectionFactory();
        } else if (factory.equals(acr.getString("A1234"))) {
            type = 8;
            tempObj = new XAConnectionFactory();
        }
        Properties props = tempObj.getConfiguration();
        String propType = null;
        String propLabel = null;
        for (int i = 0; i < this.cfProps.size(); ++i) {
            String propValue;
            LabelledComponent cfItem = (LabelledComponent)this.cfProps.elementAt(i);
            String propName = (String)cfItem.getClientData();
            if (propName == null) continue;
            if (!cfItem.getComponent().isEnabled()) {
                props.remove(propName);
                continue;
            }
            try {
                propType = tempObj.getPropertyType(propName);
                propLabel = tempObj.getPropertyLabel(propName);
            }
            catch (JMSException jmsex) {
                JOptionPane.showOptionDialog(this, jmsex.toString(), acr.getString("A1130"), 0, 0, null, close, close[0]);
                return;
            }
            if (propType == null || (propValue = this.getValue(cfItem.getComponent(), propType).trim()).equals("")) continue;
            try {
                tempObj.setProperty(propName, propValue);
                props.put(propName, propValue);
                continue;
            }
            catch (JMSException jmsex) {
                if (jmsex instanceof InvalidPropertyValueException) {
                    JOptionPane.showOptionDialog(this, acr.getString("A3016", propLabel), acr.getString("A1130") + ": " + acr.getString("A1218", "A3016"), 0, 0, null, close, close[0]);
                } else {
                    JOptionPane.showOptionDialog(this, jmsex.toString(), acr.getString("A1130"), 0, 0, null, close, close[0]);
                }
                return;
            }
        }
        ObjAdminEvent oae = new ObjAdminEvent(this, 6);
        ObjStore os = this.osCObj.getObjStore();
        oae.setLookupName(lookupName);
        oae.setObjStore(os);
        oae.setFactoryType(type);
        oae.setObjProperties(props);
        if (this.checkBox.isSelected()) {
            oae.setReadOnly(true);
        } else {
            oae.setReadOnly(false);
        }
        oae.setOKAction(true);
        this.fireAdminEventDispatched(oae);
    }

    @Override
    public void doApply() {
    }

    @Override
    public void doReset() {
        this.lookupText.setText("");
        this.factoryCombo.setSelectedItem(acr.getString("A1235"));
        this.checkBox.setSelected(false);
        QueueConnectionFactory tempObj = new QueueConnectionFactory();
        Properties props = tempObj.getConfiguration();
        String propName = null;
        String propType = null;
        String defaultValue = null;
        for (int i = 0; i < this.cfProps.size(); ++i) {
            LabelledComponent cfItem = (LabelledComponent)this.cfProps.elementAt(i);
            JComponent comp = cfItem.getComponent();
            propName = (String)cfItem.getClientData();
            if (propName == null) continue;
            try {
                if (!comp.isEnabled()) continue;
                propType = tempObj.getPropertyType(propName);
                defaultValue = tempObj.getProperty(propName);
                this.setValue(comp, propType, defaultValue);
                if (!(comp instanceof JComboBox)) continue;
                this.doComboBox((JComboBox)comp);
                continue;
            }
            catch (Exception e) {
                System.err.println(e.toString() + ": " + propName);
            }
        }
        QueueConnectionFactory tempObj2 = new QueueConnectionFactory();
        this.setOtherValues(tempObj2, false);
        this.lookupText.requestFocus();
    }

    @Override
    public void doCancel() {
        this.hide();
    }

    @Override
    public void doClose() {
        this.hide();
    }

    @Override
    public void doClear() {
    }

    @Override
    public void show() {
    }

    public void show(ObjStoreConFactoryListCObj osCObj) {
        this.osCObj = osCObj;
        this.doReset();
        this.tabbedPane.setSelectedIndex(0);
        super.show();
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
    }
}

