/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel.client;

import com.sun.messaging.jmq.httptunnel.api.share.HttpTunnelDefaults;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelPacket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class HttpTunnelPush
extends Thread
implements HttpTunnelDefaults {
    private URL pushUrl = null;
    private Vector q = null;
    private boolean stopThread = false;
    private boolean shutdownComplete = false;

    public void startPushThread(URL pushUrl) {
        this.pushUrl = pushUrl;
        this.q = new Vector();
        this.setName("HttpTunnelPush");
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Vector vector = this.q;
        synchronized (vector) {
            this.stopThread = true;
            this.q.notify();
        }
        while (!this.shutdownComplete) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(HttpTunnelPacket p) {
        Vector vector = this.q;
        synchronized (vector) {
            if (this.stopThread) {
                return;
            }
            this.q.addElement(p);
            this.q.notify();
        }
    }

    public HttpTunnelPacket sendPacketDirect(URL u, HttpTunnelPacket p, boolean getResponse) throws Exception {
        URLConnection uc = u.openConnection();
        uc.setDoInput(true);
        uc.setDoOutput(true);
        uc.setUseCaches(false);
        uc.setRequestProperty("content-type", "application/octet-stream");
        OutputStream os = uc.getOutputStream();
        p.writePacket(os);
        os.close();
        uc.connect();
        int response = 200;
        if (uc instanceof HttpURLConnection) {
            response = ((HttpURLConnection)uc).getResponseCode();
        } else {
            uc.getContentType();
        }
        InputStream is = uc.getInputStream();
        if (!getResponse) {
            is.close();
            return null;
        }
        if (response != 200) {
            is.close();
            throw new IOException("Failed to receive response");
        }
        HttpTunnelPacket ret = new HttpTunnelPacket();
        ret.readPacket(is);
        is.close();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            HttpTunnelPacket p = null;
            Vector vector = this.q;
            synchronized (vector) {
                while (this.q.isEmpty() && !this.stopThread) {
                    try {
                        this.q.wait();
                    }
                    catch (Exception exception) {}
                }
                if (this.stopThread && this.q.isEmpty()) {
                    break;
                }
                p = (HttpTunnelPacket)this.q.elementAt(0);
                this.q.removeElementAt(0);
            }
            try {
                this.sendPacketDirect(this.pushUrl, p, false);
            }
            catch (Exception exception) {}
        }
        this.shutdownComplete = true;
    }
}

