/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.auth.api.client.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionInitiator;
import com.sun.messaging.jmq.jmsclient.ConnectionMetaDataImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.ContextableConnection;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.FlowControl;
import com.sun.messaging.jmq.jmsclient.InterestTable;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.QueueSessionImpl;
import com.sun.messaging.jmq.jmsclient.ReadChannel;
import com.sun.messaging.jmq.jmsclient.ReadQTable;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.TemporaryDestination;
import com.sun.messaging.jmq.jmsclient.TopicSessionImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsclient.UnifiedSessionImpl;
import com.sun.messaging.jmq.jmsclient.WriteChannel;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jmq.jmsclient.notification.EventHandler;
import com.sun.messaging.jmq.util.DebugPrinter;
import com.sun.messaging.jms.Connection;
import com.sun.messaging.jms.MQIllegalStateRuntimeException;
import com.sun.messaging.jms.MQInvalidClientIDRuntimeException;
import com.sun.messaging.jms.MQRuntimeException;
import com.sun.messaging.jms.notification.EventListener;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.XASession;

public class ConnectionImpl
implements Connection,
Traceable,
ContextableConnection {
    private static final String ENABLE_FAILOVER_PROP = "imq.enable_failover";
    protected static final Version version = new Version();
    private boolean daemonThreads = false;
    private boolean hasNamespace = false;
    private String raNamespaceUID = null;
    private Object nsSyncObj = new Object();
    ExceptionListener exceptionListener = null;
    protected String clientID = null;
    protected String clientIPAddress = null;
    protected ReadChannel readChannel = null;
    protected WriteChannel writeChannel = null;
    protected ProtocolHandler protocolHandler = null;
    private AuthenticationProtocolHandler authenticationHandler = null;
    protected FlowControl flowControl = null;
    protected ConnectionInitiator initiator = null;
    protected boolean reconnecting = false;
    private Object reconnectSyncObj = new Object();
    protected Hashtable producers = new Hashtable();
    protected ExceptionHandler exceptionHandler = null;
    protected InterestTable interestTable = null;
    protected ReadQTable readQTable = null;
    protected ReadQTable ackQTable = null;
    protected Hashtable requestMetaData = null;
    protected boolean isTopicConnection = false;
    protected boolean isQueueConnection = false;
    protected boolean isStopped = true;
    protected boolean isClosed = true;
    protected boolean isCloseCalled = false;
    protected boolean isSuspended = false;
    protected Vector sessionTable = null;
    protected Vector connectionConsumerTable = null;
    protected Vector tempDestTable = null;
    protected long nextSessionId = 0L;
    protected boolean sessionIdReset = false;
    protected int nextTransactionID = 0;
    protected boolean openedFromXA = false;
    protected boolean protectMode = false;
    protected int flowControlMsgSize = 100;
    protected int flowControlWaterMark = 1000;
    protected int prefetchMaxMsgCount = 100;
    protected int prefetchThresholdPercent = 50;
    protected boolean consumerFlowLimitPrefetch = true;
    protected int onMessageExRedeliveryAttempts = 1;
    protected long onMessageExRedeliveryIntervals = 500L;
    protected volatile boolean imqReconnect = false;
    protected boolean failoverEnabled = false;
    protected Hashtable licenseProps = null;
    protected boolean imqEnableSharedClientID = false;
    protected boolean imqEnableSharedSubscriptions = false;
    protected int dupsOkLimit = 10;
    protected boolean isAckLimited = false;
    protected int ackLimit = 100;
    private int tempDestSequence = 0;
    private int tempDestCounter = 0;
    protected volatile boolean connectionIsBroken = false;
    protected volatile boolean recoverInProcess = false;
    protected static long nextConnectionID = 0L;
    protected Long connectionID = null;
    protected long localID = 0L;
    protected long brokerSessionID = 0L;
    protected boolean jmqOverrideJMSMsgHeaders = false;
    protected boolean jmqOverrideJMSDeliveryMode = false;
    protected boolean jmqOverrideJMSExpiration = false;
    protected boolean jmqOverrideJMSPriority = false;
    protected boolean jmqOverrideMsgsToTempDests = false;
    protected int jmqJMSDeliveryMode = 2;
    protected long jmqJMSExpiration = 0L;
    protected int jmqJMSPriority = 4;
    protected boolean dupsOkAckOnEmptyQueue = false;
    protected long dupsOkAckTimeout = 7000L;
    protected long asyncSendCompletionWaitTimeout = 180000L;
    protected int imqSocketConnectTimeout = 0;
    protected Integer imqPortMapperSoTimeout = null;
    protected boolean allowToSetClientID = true;
    protected boolean adminSetClientID = false;
    private Object syncObj = new Object();
    private transient String userName = null;
    private transient String password = null;
    private String ackOnProduce = null;
    private String ackOnAcknowledge = null;
    private String connectionType = "NORMAL";
    private boolean adminKeyUsed = false;
    protected ConnectionMetaDataImpl connectionMetaData = null;
    private boolean debug = Debug.debug;
    Properties configuration = null;
    private boolean isDedicatedToConnectionConsumer = true;
    private volatile boolean negotiateProtocolLevel = false;
    private int brokerProtocolLevel = 0;
    private String brokerVersion = "Unknown";
    private long imqPingInterval = 30000L;
    private static long WAIT_TIME_OUT = 30000L;
    protected EventListener eventListener = null;
    protected EventHandler eventHandler = null;
    protected volatile boolean isConnectedToHABroker = false;
    protected String JMQClusterID = null;
    protected Long JMQStoreSession = null;
    protected String JMQBrokerList = null;
    protected String savedJMQBrokerList = null;
    protected String JMQStoreOwner = null;
    protected String lastContactedBrokerAddress = null;
    private boolean extendedEventNotification = false;
    private boolean _appTransactedAck = false;
    public static final String ROOT_LOGGER_NAME = "javax.jms";
    public static final String CONNECTION_LOGGER_NAME = "javax.jms.connection";
    protected static final Logger connectionLogger = Logger.getLogger("javax.jms.connection", "com.sun.messaging.jmq.jmsclient.resources.ClientResources");
    private boolean isHADisabled = Boolean.getBoolean("imq.ha.disabled");
    private volatile boolean disableReopenFromRA = false;

    public boolean isHAEnabled() {
        return !this.isHADisabled;
    }

    public boolean isDirectMode() {
        return this.protocolHandler.isDirectMode();
    }

    public ConnectionImpl(Properties configuration, String userName, String password, String type) throws JMSException {
        this.configuration = configuration;
        this.userName = userName;
        this.password = password;
        if ("ADMINKEY".equals(type)) {
            this.connectionType = "ADMIN";
            this.adminKeyUsed = true;
        } else if (type != null) {
            this.connectionType = type;
        }
        if (this.connectionType == "ADMIN") {
            this.isHADisabled = true;
        }
        this.connectionID = new Long(ConnectionImpl.getNextConnectionID());
        this.localID = this.connectionID;
        this.init();
        this.logLifeCycle("I100");
    }

    public long getLocalID() {
        return this.localID;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    protected void setBrokerSessionID(long id) {
        this.brokerSessionID = id;
    }

    protected long getBrokerSessionID() {
        return this.brokerSessionID;
    }

    public void setBrokerVersion(String brokerVersion) {
        if (this.debug) {
            Debug.println("setBrokerVersion : " + brokerVersion);
        }
        this.brokerVersion = brokerVersion;
    }

    public long generateUID() throws JMSException {
        return this.protocolHandler.generateUID();
    }

    protected int getBrokerProtocolLevel() {
        return this.brokerProtocolLevel;
    }

    protected void setBrokerProtocolLevel(int brokerProtocolLevel) {
        if (this.debug) {
            Debug.println("setBrokerProtocolLevel : " + brokerProtocolLevel);
        }
        this.brokerProtocolLevel = brokerProtocolLevel;
    }

    protected boolean checkBrokerProtocolLevel() throws JMSException {
        return this.brokerProtocolLevel >= 200;
    }

    public static void checkHostPort(String host, int port) throws JMSException {
        if (port <= 0) {
            String errorString0 = "[" + host + "," + port + "]";
            String errorString = AdministeredObject.cr.getKString("C4090", errorString0);
            JMSException jmse = new JMSException(errorString, "C4090");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    public boolean getNegotiateProtocolLevel() {
        return this.negotiateProtocolLevel;
    }

    public void setNegotiateProtocolLevel(boolean negotiateProtocolLevel) {
        if (this.debug) {
            Debug.println("setNegotiateProtocolLevel : " + negotiateProtocolLevel);
        }
        this.negotiateProtocolLevel = negotiateProtocolLevel;
    }

    protected void updateLicenseProps() throws JMSException {
        this.licenseProps = null;
        this.failoverEnabled = false;
        if (this.getBrokerProtocolLevel() > 350) {
            this.licenseProps = this.protocolHandler.getLicense();
        }
        if (this.licenseProps != null) {
            String fo = (String)this.licenseProps.get(ENABLE_FAILOVER_PROP);
            if (fo != null && "true".equalsIgnoreCase(fo)) {
                this.failoverEnabled = true;
            }
            this.checkLicense();
        }
    }

    protected void hello() throws JMSException {
        this.protocolHandler.hello(this.userName, this.password);
        this.updateLicenseProps();
    }

    protected void hello(boolean reconnect) throws JMSException {
        this.protocolHandler.hello(this.userName, this.password, this.connectionID);
        this.updateLicenseProps();
    }

    private void checkLicense() throws JMSException {
        if (this.imqReconnect && !this.failoverEnabled && this.initiator.getAddrListSize() > 1) {
            String bname = this.protocolHandler.getConnectionHandler().getBrokerHostName();
            String errorString = AdministeredObject.cr.getKString("C4097", bname);
            JMSException jmse = new JMSException(errorString, "C4097");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected boolean waitForReconnecting(Exception e) {
        boolean isReconnected = false;
        if (!this.imqReconnect) {
            return false;
        }
        if (!(e instanceof JMSException)) {
            return false;
        }
        JMSException jmse = (JMSException)e;
        String ecode = jmse.getErrorCode();
        if ("C4001".equals(ecode) || "C4000".equals(ecode)) {
            SessionImpl.yield();
            try {
                this.checkReconnecting(null);
                isReconnected = !this.isCloseCalled && !this.connectionIsBroken;
            }
            catch (Exception e2) {
                isReconnected = false;
            }
        }
        return isReconnected;
    }

    protected void checkReconnecting(ReadWritePacket pkt) throws JMSException {
        this.checkReconnecting(pkt, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkReconnecting(ReadWritePacket pkt, boolean block) throws JMSException {
        Object object = this.reconnectSyncObj;
        synchronized (object) {
            while (this.reconnecting) {
                if (!block) {
                    throw new JMSException("XXXWOULD-BLOCK");
                }
                try {
                    this.reconnectSyncObj.wait(WAIT_TIME_OUT);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!this.connectionIsBroken && !this.isCloseCalled) continue;
                return;
            }
        }
        if (pkt != null) {
            this.checkPacketType(pkt);
        }
    }

    private void checkPacketType(ReadWritePacket pkt) throws JMSException {
        boolean isAllowed = this.isAllowedToFailover(pkt);
        if (!isAllowed) {
            String msg = AdministeredObject.cr.getKString("C4001") + ", packet type = " + PacketType.getString(pkt.getPacketType());
            com.sun.messaging.jms.JMSException jmse = new com.sun.messaging.jms.JMSException(msg, "C4001");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    private boolean isAllowedToFailover(ReadWritePacket pkt) {
        long tid;
        Object sid;
        Hashtable ht = null;
        try {
            ht = pkt.getProperties();
        }
        catch (Exception e) {
            connectionLogger.log(Level.WARNING, "C4005", e);
            return false;
        }
        if (ht != null && (sid = ht.get("JMQSessionID")) != null) {
            return false;
        }
        int packetType = pkt.getPacketType();
        if (packetType == 24 || packetType == 14 || packetType == 18 || packetType == 12 || packetType == 34 || packetType == 68 || packetType == 16 || packetType == 66 || packetType == 36 || packetType == 70 || packetType == 56 || packetType == 50 || packetType == 44 || packetType == 48) {
            return false;
        }
        return packetType != 6 && packetType != 2 && packetType != 3 && packetType != 1 && packetType != 5 && packetType != 4 || (tid = pkt.getTransactionID()) <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getReconnecting() {
        Object object = this.reconnectSyncObj;
        synchronized (object) {
            return this.reconnecting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReconnecting(boolean reconnecting) {
        Object object = this.reconnectSyncObj;
        synchronized (object) {
            this.reconnecting = reconnecting;
            this.reconnectSyncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndSetReconnecting() throws JMSException {
        Object object = this.reconnectSyncObj;
        synchronized (object) {
            if (!(this.reconnecting || this.connectionIsBroken || this.isCloseCalled)) {
                this.setReconnecting(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useNamespace() {
        Object object = this.nsSyncObj;
        synchronized (object) {
            return this.hasNamespace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRANamespaceUID(String raNamespaceUID) {
        Object object = this.nsSyncObj;
        synchronized (object) {
            this.imqEnableSharedClientID = true;
            this.imqEnableSharedSubscriptions = true;
            this.raNamespaceUID = raNamespaceUID;
            this.hasNamespace = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRANamespaceUID() {
        Object object = this.nsSyncObj;
        synchronized (object) {
            return this.raNamespaceUID;
        }
    }

    private void init() throws JMSException {
        block42: {
            try {
                String pInterval;
                String dedicateToCC;
                String isLimited;
                String ackCount;
                String tmpVal;
                String dupsOk;
                long val;
                this.exceptionHandler = new ExceptionHandler();
                this.interestTable = new InterestTable();
                this.readQTable = new ReadQTable();
                this.ackQTable = new ReadQTable();
                this.requestMetaData = new Hashtable();
                this.sessionTable = new Vector();
                this.connectionConsumerTable = new Vector();
                this.tempDestTable = new Vector();
                String prop = null;
                int propval = 0;
                long lpropval = 0L;
                String cid = this.getTrimmedProperty("imqConfiguredClientID");
                if (cid != null) {
                    this.clientID = cid;
                    this.adminSetClientID = true;
                }
                if (Boolean.valueOf(prop = this.getProperty("imq.DaemonThreads", "false")).booleanValue()) {
                    this.daemonThreads = true;
                }
                if (Boolean.valueOf(prop = this.getProperty("imq.disableReopenFramRA", "false")).booleanValue()) {
                    this.disableReopenFromRA = true;
                }
                if (Boolean.valueOf(prop = this.getTrimmedProperty("imqOverrideJMSDeliveryMode")).booleanValue()) {
                    prop = this.getTrimmedProperty("imqJMSDeliveryMode");
                    if ("PERSISTENT".equals(prop)) {
                        this.jmqJMSDeliveryMode = 2;
                        this.jmqOverrideJMSDeliveryMode = true;
                    }
                    if ("NON_PERSISTENT".equals(prop)) {
                        this.jmqJMSDeliveryMode = 1;
                        this.jmqOverrideJMSDeliveryMode = true;
                    }
                }
                if (Boolean.valueOf(prop = this.getTrimmedProperty("imqOverrideJMSExpiration")).booleanValue() && (lpropval = Long.parseLong(prop = this.getTrimmedProperty("imqJMSExpiration"))) >= 0L) {
                    this.jmqJMSExpiration = lpropval;
                    this.jmqOverrideJMSExpiration = true;
                }
                if (Boolean.valueOf(prop = this.getTrimmedProperty("imqOverrideJMSPriority")).booleanValue() && (propval = Integer.parseInt(prop = this.getTrimmedProperty("imqJMSPriority"))) >= 0 && propval <= 9) {
                    this.jmqJMSPriority = propval;
                    this.jmqOverrideJMSPriority = true;
                }
                if (this.jmqOverrideJMSDeliveryMode || this.jmqOverrideJMSExpiration || this.jmqOverrideJMSPriority) {
                    this.jmqOverrideJMSMsgHeaders = true;
                }
                prop = this.getTrimmedProperty("imqOverrideJMSHeadersToTemporaryDestinations");
                this.jmqOverrideMsgsToTempDests = Boolean.valueOf(prop);
                String disableSetID = this.getProperty("imqDisableSetClientID");
                if (Boolean.valueOf(disableSetID).booleanValue()) {
                    this.setClientIDFlag();
                }
                if (Boolean.valueOf(prop = this.getProperty("imqConnectionFlowLimitEnabled")).booleanValue()) {
                    this.protectMode = true;
                }
                if ((prop = this.getTrimmedProperty("imqConnectionFlowLimit")) != null) {
                    this.flowControlWaterMark = Integer.parseInt(prop);
                }
                if ((prop = this.getTrimmedProperty("imqConnectionFlowCount")) != null) {
                    this.flowControlMsgSize = Integer.parseInt(prop);
                }
                if ((prop = this.getTrimmedProperty("imqConsumerFlowLimit")) != null) {
                    this.prefetchMaxMsgCount = Integer.parseInt(prop);
                }
                if ((prop = this.getTrimmedProperty("imqConsumerFlowThreshold")) != null) {
                    this.prefetchThresholdPercent = Integer.parseInt(prop);
                }
                prop = this.getProperty("imqConsumerFlowLimitPrefetch", "true");
                this.consumerFlowLimitPrefetch = Boolean.valueOf(prop);
                if (!this.consumerFlowLimitPrefetch) {
                    this.prefetchMaxMsgCount = 1;
                    this.prefetchThresholdPercent = 0;
                }
                if ((prop = this.getProperty("imqOnMessageExceptionRedeliveryAttempts", String.valueOf(this.onMessageExRedeliveryAttempts))) != null) {
                    int val2 = Integer.parseInt(prop);
                    if (val2 < 1) {
                        val2 = 1;
                    }
                    this.onMessageExRedeliveryAttempts = val2;
                }
                if ((prop = this.getProperty("imqOnMessageExceptionRedeliveryIntervals", String.valueOf(this.onMessageExRedeliveryIntervals))) != null) {
                    long val3 = Long.parseLong(prop);
                    if (val3 < 0L) {
                        val3 = 0L;
                    }
                    this.onMessageExRedeliveryIntervals = val3;
                }
                if ((prop = this.getTrimmedProperty("imqReconnectEnabled")) != null) {
                    this.imqReconnect = Boolean.valueOf(prop);
                }
                if ((prop = this.getTrimmedProperty("imqEnableSharedClientID")) != null) {
                    this.imqEnableSharedClientID = Boolean.valueOf(prop);
                }
                this.ackOnProduce = this.getTrimmedProperty("imqAckOnProduce");
                this.ackOnAcknowledge = this.getTrimmedProperty("imqAckOnAcknowledge");
                String valstr = this.getTrimmedProperty("imqAsyncSendCompletionWaitTimeout");
                if (valstr != null && (val = Long.parseLong(valstr)) > 0L) {
                    this.asyncSendCompletionWaitTimeout = val;
                }
                if ((dupsOk = System.getProperty("imqDupsOkLimit")) != null) {
                    this.dupsOkLimit = Integer.parseInt(dupsOk);
                }
                if ((prop = System.getProperty("imqDupsOkAckTimeout")) != null) {
                    this.dupsOkAckTimeout = Integer.parseInt(prop);
                }
                if ((prop = this.getTrimmedProperty("imqPortMapperSoTimeout")) != null) {
                    this.imqPortMapperSoTimeout = Integer.valueOf(prop);
                    if (this.imqPortMapperSoTimeout < 0) {
                        this.imqPortMapperSoTimeout = null;
                    }
                }
                if ((tmpVal = System.getProperty("imqSocketConnectTimeout")) != null) {
                    this.imqSocketConnectTimeout = Integer.parseInt(tmpVal);
                } else {
                    prop = this.getTrimmedProperty("imqSocketConnectTimeout");
                    if (prop != null) {
                        this.imqSocketConnectTimeout = Integer.parseInt(prop);
                    }
                }
                prop = System.getProperty("imqDupsOkAckOnEmptyQueue");
                if (prop != null) {
                    this.dupsOkAckOnEmptyQueue = Boolean.valueOf(prop);
                }
                if ((ackCount = System.getProperty("imqAckLimit")) != null) {
                    this.ackLimit = Integer.parseInt(ackCount);
                }
                if ((isLimited = System.getProperty("imqAckIsLimited")) != null && isLimited.equals("true")) {
                    this.isAckLimited = true;
                }
                if ((dedicateToCC = System.getProperty("imq.dedicateToConnectionConsumer")) != null && dedicateToCC.equals("false")) {
                    this.isDedicatedToConnectionConsumer = false;
                }
                if ((pInterval = this.getTrimmedProperty("imqPingInterval")) != null) {
                    int tmp = Integer.parseInt(pInterval);
                    this.imqPingInterval = tmp <= 0 ? 0L : (long)tmp * 1000L;
                }
                this.initiator = new ConnectionInitiator(this);
                this.setBrokerProtocolLevel(PacketType.getProtocolVersion());
                try {
                    this.openConnection(false);
                }
                catch (Exception e) {
                    if (this.negotiateProtocolLevel) {
                        this.openConnection(false);
                        break block42;
                    }
                    if (e instanceof JMSException) {
                        throw e;
                    }
                    ExceptionHandler.handleException(e, "C4038", true);
                }
            }
            catch (JMSException jmse) {
                throw jmse;
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e, "C4038", true);
            }
        }
    }

    private static synchronized long getNextConnectionID() {
        return nextConnectionID++;
    }

    protected Long getConnectionID() {
        return this.connectionID;
    }

    public Long _getConnectionID() {
        return this.connectionID;
    }

    protected void setConnectionID(Long id) {
        this.connectionID = id;
    }

    protected void setAuthenticationHandler(AuthenticationProtocolHandler authHdr) {
        this.authenticationHandler = authHdr;
    }

    protected AuthenticationProtocolHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTempDestSequence() {
        Object object = this.syncObj;
        synchronized (object) {
            ++this.tempDestCounter;
            return ++this.tempDestSequence;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decreaseTempDestCounter() {
        Object object = this.syncObj;
        synchronized (object) {
            --this.tempDestCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTempDestCounter() {
        Object object = this.syncObj;
        synchronized (object) {
            return this.tempDestCounter;
        }
    }

    protected void setProtectMode(boolean mode) {
        this.protectMode = mode;
    }

    protected boolean getProtectMode() {
        return this.protectMode;
    }

    protected int getDupsOkLimit() {
        return this.dupsOkLimit;
    }

    protected int getAckLimit() {
        return this.ackLimit;
    }

    protected boolean getIsAckLimited() {
        return this.isAckLimited;
    }

    protected boolean getIsDedicatedToConnectionConsumer() {
        return this.isDedicatedToConnectionConsumer && !this.connectionConsumerTable.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getNextSessionId() {
        Object object = this.syncObj;
        synchronized (object) {
            ++this.nextSessionId;
            if (this.nextSessionId == Long.MAX_VALUE) {
                this.nextSessionId = 1L;
                this.sessionIdReset = true;
            }
            if (this.sessionIdReset) {
                boolean found = false;
                while (!found) {
                    SessionQueue key = this.readQTable.get(new Long(this.nextSessionId));
                    if (key == null) {
                        found = true;
                        continue;
                    }
                    ++this.nextSessionId;
                    if (this.nextSessionId != Long.MAX_VALUE) continue;
                    this.nextSessionId = 1L;
                }
            }
            return new Long(this.nextSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextTransactionID() throws JMSException {
        Object object = this.syncObj;
        synchronized (object) {
            ++this.nextTransactionID;
            if (this.nextTransactionID == Integer.MAX_VALUE) {
                this.nextTransactionID = 1;
            }
            return this.nextTransactionID;
        }
    }

    protected void addToReadQTable(Object sid, Object readQueue) {
        this.readQTable.put(sid, readQueue);
    }

    protected void removeFromReadQTable(Object sid) {
        this.readQTable.remove(sid);
    }

    protected void addToAckQTable(Object aid, Object readQueue) {
        this.ackQTable.put(aid, readQueue);
    }

    protected void removeFromAckQTable(Object aid) {
        this.ackQTable.remove(aid);
    }

    protected void addMessageProducer(Object producerIDKey, MessageProducerImpl producer) {
        MessageProducerImpl o = this.producers.put(producerIDKey, producer);
        if (this.debug && o != null) {
            Debug.println("ERROR : Duplicate ProducerID in connection.addMessageProducer : " + producerIDKey);
        }
    }

    protected void removeMessageProducer(Object producerIDKey) {
        Object o = this.producers.remove(producerIDKey);
        if (this.debug && o == null) {
            Debug.println("ERROR : Unknown producer in connection.removeMessageProducer : " + producerIDKey);
        }
    }

    protected MessageProducerImpl findMessageProducer(Object producerIDKey) {
        return (MessageProducerImpl)this.producers.get(producerIDKey);
    }

    protected void addLocalInterest(Consumer consumer) {
    }

    protected void removeLocalInterest(Consumer consumer) {
        this.interestTable.removeInterest(consumer);
    }

    protected void addInterest(Consumer consumer) throws JMSException {
        this.addLocalInterest(consumer);
        this.writeChannel.addInterest(consumer);
    }

    protected void removeInterest(Consumer consumer) throws JMSException {
        this.writeChannel.removeInterest(consumer);
        this.removeLocalInterest(consumer);
    }

    protected void unsubscribe(String durableName) throws JMSException {
        Enumeration enum2 = this.connectionConsumerTable.elements();
        ConnectionConsumerImpl connConsumer = null;
        while (enum2.hasMoreElements()) {
            connConsumer = (ConnectionConsumerImpl)enum2.nextElement();
            if (!connConsumer.getDurable() || !connConsumer.getDurableName().equals(durableName)) continue;
            String errorString = AdministeredObject.cr.getKString("C4007", durableName);
            JMSException jmse = new JMSException(errorString, "C4007");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.writeChannel.unsubscribe(durableName);
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    protected WriteChannel getWriteChannel() {
        return this.writeChannel;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    protected boolean isAdminKeyUsed() {
        return this.adminKeyUsed;
    }

    public void _setAppTransactedAck() {
        this._appTransactedAck = true;
        this.imqReconnect = false;
    }

    protected boolean isAppTransactedAck() {
        return this._appTransactedAck;
    }

    protected Properties getConfiguration() {
        return (Properties)this.configuration.clone();
    }

    public String getProperty(String propname) {
        String propval = (String)this.configuration.get(propname);
        if (this.debug) {
            Debug.println("****** property " + propname + " : " + propval);
        }
        return propval;
    }

    public String getTrimmedProperty(String propName) {
        String prop = this.getProperty(propName);
        if (prop != null && prop.trim().length() == 0) {
            prop = null;
        }
        return prop;
    }

    public String getProperty(String propname, String propdefault) {
        String propval = this.getProperty(propname);
        if (propval == null) {
            propval = System.getProperty(propname);
        }
        return propval == null ? propdefault : propval;
    }

    public ReadChannel getReadChannel() {
        return this.readChannel;
    }

    protected void setProtocolHandler(ProtocolHandler handler) {
        this.protocolHandler = handler;
    }

    protected boolean getIsTopicConnection() {
        return this.isTopicConnection;
    }

    protected void setIsTopicConnection(boolean isTopic) {
        this.isTopicConnection = isTopic;
    }

    protected boolean getISQueueConnection() {
        return this.isQueueConnection;
    }

    protected void setIsQueueConnection(boolean isQueue) {
        this.isQueueConnection = isQueue;
    }

    protected InterestTable getInterestTable() {
        return this.interestTable;
    }

    protected void addSession(SessionImpl session) {
        this.sessionTable.addElement(session);
    }

    protected boolean removeSession(SessionImpl session) {
        return this.sessionTable.removeElement(session);
    }

    protected void addConnectionConsumer(ConnectionConsumerImpl connectionConsumer) {
        this.connectionConsumerTable.addElement(connectionConsumer);
    }

    protected void removeConnectionConsumer(ConnectionConsumerImpl connectionConsumer) {
        this.connectionConsumerTable.removeElement(connectionConsumer);
    }

    protected void addTempDest(TemporaryDestination tempDest) {
        this.tempDestTable.addElement(tempDest);
    }

    protected void removeTempDest(TemporaryDestination tempDest) {
        this.tempDestTable.removeElement(tempDest);
    }

    protected void startSessions() throws JMSException {
        Enumeration enum2 = this.sessionTable.elements();
        SessionImpl session = null;
        while (enum2.hasMoreElements()) {
            session = (SessionImpl)enum2.nextElement();
            if (this.debug) {
                Debug.println("starting session: " + session.getSessionId());
            }
            session.start();
        }
    }

    protected void stopSessions() throws JMSException {
        Enumeration enum2 = this.sessionTable.elements();
        SessionImpl session = null;
        while (enum2.hasMoreElements()) {
            session = (SessionImpl)enum2.nextElement();
            if (this.debug) {
                Debug.println("stopping session: " + session.getSessionId());
            }
            session.stop();
        }
    }

    private void startConnectionConsumers() {
        Enumeration enum2 = this.connectionConsumerTable.elements();
        ConnectionConsumerImpl connectionConsumer = null;
        while (enum2.hasMoreElements()) {
            connectionConsumer = (ConnectionConsumerImpl)enum2.nextElement();
            if (this.debug) {
                Debug.println("starting connectionConsumer: " + connectionConsumer.getReadQueueId().intValue());
            }
            connectionConsumer.start();
        }
    }

    private void stopConnectionConsumers() {
        Enumeration enum2 = this.connectionConsumerTable.elements();
        ConnectionConsumerImpl connectionConsumer = null;
        while (enum2.hasMoreElements()) {
            connectionConsumer = (ConnectionConsumerImpl)enum2.nextElement();
            if (this.debug) {
                Debug.println("stopping connectionConsumer: " + connectionConsumer.getReadQueueId().intValue());
            }
            connectionConsumer.stop();
        }
    }

    private void closeConnectionConsumers() throws JMSException {
        block3: {
            ConnectionConsumerImpl connectionConsumer = null;
            try {
                while (!this.connectionConsumerTable.isEmpty()) {
                    connectionConsumer = (ConnectionConsumerImpl)this.connectionConsumerTable.firstElement();
                    connectionConsumer.close();
                    this.connectionConsumerTable.remove(connectionConsumer);
                }
            }
            catch (Exception e) {
                if (!this.debug) break block3;
                Debug.printStackTrace(e);
            }
        }
    }

    protected synchronized void suspendMessageDelivery() throws JMSException {
        if (this.getIsSuspended()) {
            return;
        }
        if (this.debug) {
            Debug.println("sending STOP to broker ...");
        }
        this.protocolHandler.stop();
        this.isSuspended = true;
    }

    protected synchronized void resumeMessageDelivery() throws JMSException {
        if (this.debug) {
            Debug.println("sending START to broker ...");
        }
        this.protocolHandler.start();
        this.isSuspended = false;
    }

    public boolean getIsSuspended() {
        return this.isSuspended;
    }

    public boolean getIsStopped() {
        return this.isStopped;
    }

    @Override
    public String getClientID() throws JMSException {
        this.checkConnectionState();
        return this.clientID;
    }

    @Override
    public void setClientID(String clientID) throws JMSException {
        this.checkConnectionState();
        this.checkSetClientID(clientID);
        this.protocolHandler.setClientID(clientID);
        this.clientID = clientID;
        this.setClientIDFlag();
    }

    @Override
    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkConnectionState();
        return this.connectionMetaData;
    }

    @Override
    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkConnectionState();
        return this.exceptionListener;
    }

    @Override
    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkConnectionState();
        this.exceptionListener = listener;
        this.setClientIDFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws JMSException {
        this.checkConnectionState();
        if (!this.isStopped) {
            return;
        }
        this.setClientIDFlag();
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.protocolHandler.start();
            this.isStopped = false;
            this.startSessions();
            this.startConnectionConsumers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws JMSException {
        this.checkConnectionState();
        if (this.isStopped || this.isClosed) {
            return;
        }
        if (this.connectionIsBroken) {
            this.exitConnection();
            return;
        }
        this.checkPermission(false);
        this.setClientIDFlag();
        if (this.debug) {
            Debug.println("stopping readChannel ...");
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.protocolHandler.stop();
            this.stopSessions();
            this.stopConnectionConsumers();
            this.isStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        this.isCloseCalled = true;
        if (this.eventHandler != null) {
            this.eventHandler.close();
        }
        if (this.isClosed) {
            return;
        }
        if (this.connectionIsBroken || this.recoverInProcess) {
            this.exitConnection();
            return;
        }
        this.checkPermission(true);
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            block19: {
                if (this.isClosed) {
                    return;
                }
                try {
                    this.protocolHandler.incStoppedCount();
                    this.stop();
                    this.closeAllSessions();
                    this.closeConnectionConsumers();
                    this.isClosed = true;
                    this.protocolHandler.goodBye(true);
                }
                catch (JMSException e) {
                    if (this.connectionIsBroken || this.recoverInProcess || this.isClosed) {
                        this.exitConnection();
                        break block19;
                    }
                    throw e;
                }
                finally {
                    block20: {
                        try {
                            this.readChannel.close();
                            this.writeChannel.close();
                            this.protocolHandler.close();
                        }
                        catch (Exception ex) {
                            if (!this.debug) break block20;
                            Debug.printStackTrace(ex);
                        }
                    }
                    this.protocolHandler = null;
                    this.readChannel = null;
                    this.writeChannel = null;
                    this.authenticationHandler = null;
                    this.logLifeCycle("I101");
                }
            }
        }
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    protected void checkSetClientID(String cid) throws JMSException {
        JMSException jmse;
        String errorString;
        if (!this.allowToSetClientID) {
            errorString = AdministeredObject.cr.getKString("C4054");
            jmse = new IllegalStateException(errorString, "C4054");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (cid == null || cid.trim().length() == 0) {
            errorString = AdministeredObject.cr.getKString("C4053", "\"\"");
            jmse = new InvalidClientIDException(errorString, "C4053");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected void setClientIDFlag() throws JMSException {
        this.allowToSetClientID = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllSessions() {
        connectionLogger.log(Level.FINEST, "closing all sessions ...");
        Object ex = null;
        SessionImpl session = null;
        try {
            while (this.sessionTable.size() > 0) {
                session = (SessionImpl)this.sessionTable.firstElement();
                this.closeSession(session);
            }
        }
        finally {
            connectionLogger.log(Level.FINEST, "all sessions closed ...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession(SessionImpl session) {
        try {
            session.close();
        }
        catch (Exception e) {
            ExceptionHandler.rootLogger.log(Level.WARNING, e.getMessage(), e);
        }
        finally {
            this.sessionTable.remove(session);
        }
    }

    protected void closeConsumerQueues() {
        Object[] tmp = this.interestTable.toArray();
        for (int i = 0; i < tmp.length; ++i) {
            if (!(tmp[i] instanceof MessageConsumerImpl)) continue;
            ((MessageConsumerImpl)tmp[i]).receiveQueue.close();
            ((MessageConsumerImpl)tmp[i]).isClosed = true;
            connectionLogger.log(Level.FINEST, "Message consumer closed: " + tmp[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitConnection() {
        connectionLogger.log(Level.FINEST, "Starting to exit connection ...");
        if (this.isClosed) {
            return;
        }
        try {
            this.closeAllSessions();
            this.closeConsumerQueues();
            this.closeConnectionConsumers();
            this.writeChannel.close();
        }
        catch (Exception e) {
            ExceptionHandler.rootLogger.log(Level.WARNING, e.getMessage(), e);
        }
        finally {
            this.isClosed = true;
            this.setReconnecting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnectionFromRA() throws JMSException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.openedFromXA) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openConnectionFromRA(boolean mode) throws JMSException {
        if (this.connectionIsBroken || this.reconnecting) {
            return;
        }
        if (this.disableReopenFromRA) {
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            this.openConnection(mode);
        }
    }

    private void openConnection(boolean mode) throws JMSException {
        if (!this.isClosed()) {
            return;
        }
        this.connectionMetaData = new ConnectionMetaDataImpl(this);
        this.protocolHandler = new ProtocolHandler(this);
        if (this.ackOnProduce != null) {
            if (this.ackOnProduce.equals("true")) {
                this.protocolHandler.enableWriteAcknowledge(true);
            } else if (this.ackOnProduce.equals("false")) {
                this.protocolHandler.enableWriteAcknowledge(false);
            }
        }
        if (this.ackOnAcknowledge != null && this.ackOnAcknowledge.equals("false")) {
            this.protocolHandler.setAckAck(false);
        }
        this.connectionIsBroken = false;
        this.recoverInProcess = false;
        this.readChannel = new ReadChannel(this);
        this.writeChannel = new WriteChannel(this);
        if (this.debug) {
            Debug.println(this);
        }
        try {
            this.hello();
            if (this.adminSetClientID) {
                this.protocolHandler.setClientID(this.clientID);
                this.setClientIDFlag();
            }
        }
        catch (JMSException e) {
            if (!this.connectionIsBroken) {
                try {
                    this.protocolHandler.goodBye(false);
                }
                catch (JMSException e1) {
                    // empty catch block
                }
            }
            try {
                this.readChannel.close();
                this.protocolHandler.close();
            }
            catch (JMSException e2) {
                e2.setLinkedException(e);
                throw e2;
            }
            throw e;
        }
        this.isClosed = false;
        this.openedFromXA = mode;
    }

    private void checkPermission(boolean checkAsyncSend) throws JMSException {
        SessionImpl session = null;
        try {
            Enumeration enum2 = this.sessionTable.elements();
            while (enum2.hasMoreElements()) {
                session = (SessionImpl)enum2.nextElement();
                session.checkPermission();
                if (!checkAsyncSend) continue;
                session.checkPermissionForAsyncSend();
            }
        }
        catch (JMSException ie) {
            throw ie;
        }
        catch (Exception ex) {
            IllegalStateException jmse = new IllegalStateException(ex.toString());
            jmse.setLinkedException(ex);
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected void checkConnectionState() throws JMSException {
        if (this.isClosed) {
            String errorString = AdministeredObject.cr.getKString("C4062");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4062");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected boolean isBroken() {
        return this.connectionIsBroken;
    }

    protected synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized boolean _isClosed() {
        return this.isClosed();
    }

    public synchronized void _unsetClientID() throws JMSException {
        this.clientID = null;
        this.allowToSetClientID = true;
        this.protocolHandler.unsetClientID();
    }

    public synchronized void _setClientID(String cid) throws JMSException {
        this.checkConnectionState();
        this.protocolHandler.setClientID(cid);
        this.clientID = cid;
        this.allowToSetClientID = false;
    }

    @Override
    public void _setClientIDForContext(String clientID) {
        try {
            this._setClientID(clientID);
        }
        catch (IllegalStateException e) {
            throw new MQIllegalStateRuntimeException(e);
        }
        catch (InvalidClientIDException e) {
            throw new MQInvalidClientIDRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public synchronized String _getClientID() {
        return this.clientID;
    }

    public synchronized void _closeForPooling() throws JMSException {
        block4: {
            TemporaryDestination tDest = null;
            try {
                while (!this.tempDestTable.isEmpty()) {
                    tDest = (TemporaryDestination)this.tempDestTable.firstElement();
                    tDest.delete();
                    this.tempDestTable.remove(tDest);
                }
            }
            catch (Exception e) {
                if (!this.debug) break block4;
                Debug.printStackTrace(e);
            }
        }
        if (this.clientID != null) {
            this._unsetClientID();
        }
    }

    public void _setExceptionListenerFromRA(ExceptionListener listener) throws JMSException {
        this.checkConnectionState();
        this.exceptionListener = listener;
    }

    public boolean hasDaemonThreads() {
        return this.daemonThreads;
    }

    protected void setIsBroken(boolean flag) {
        this.connectionIsBroken = flag;
    }

    protected void setRecoverInProcess(boolean state) {
        this.recoverInProcess = state;
    }

    protected boolean getRecoverInProcess() {
        return this.recoverInProcess;
    }

    protected String getUserName() {
        return this.userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getClientIDOrIPAddress() {
        if (this.clientID != null) {
            return this.clientID;
        }
        if (this.clientIPAddress == null) {
            Object object = this.syncObj;
            synchronized (object) {
                try {
                    this.clientIPAddress = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception e) {
                    this.clientIPAddress = "127.0.0.1";
                }
            }
        }
        return this.clientIPAddress;
    }

    @Override
    public void dump(PrintStream ps) {
        try {
            ps.println("------ ConnectionImpl dump ------");
            ps.println("clientID: " + this.clientID);
            ps.println("host: " + this.configuration.getProperty("imqBrokerHostName"));
            ps.println("port: " + this.configuration.getProperty("imqBrokerHostPort"));
            ps.println("protectMode: " + this.protectMode);
            ps.println("Flow control waterMark: " + this.flowControlWaterMark);
            ps.println("Flow Control Message size: " + this.flowControlMsgSize);
            if (this.protocolHandler != null) {
                ps.println("Broker acknowledge mode: " + this.protocolHandler.getAckEnabled());
                ps.println("Require ack back from broker for auto/client ack: " + this.protocolHandler.getAckAck());
            }
            ps.println("dupsOkLimit: " + this.dupsOkLimit);
            ps.println("isAckLimited: " + this.isAckLimited);
            ps.println("ackLimit: " + this.ackLimit);
            ps.println("failoverEnabled: " + this.failoverEnabled);
            ps.println("imqReconnectEnabled: " + this.imqReconnect);
            ps.println("isConnectedToHaBroker: " + this.isConnectedToHABroker);
            ps.println("Connection is stopped: " + this.isStopped);
            Enumeration enum2 = this.sessionTable.elements();
            while (enum2.hasMoreElements()) {
                SessionImpl session = (SessionImpl)enum2.nextElement();
                session.dump(ps);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    protected long getPingInterval() {
        return this.imqPingInterval;
    }

    public String toString() {
        return "BrokerAddress=" + this.getLastContactedBrokerAddress() + ", ConnectionID=" + this.getConnectionID() + ", ReconnectEnabled: " + this.imqReconnect + ", IsConnectedToHABroker: " + this.isConnectedToHABroker;
    }

    public Hashtable getDebugState(boolean verbose) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("Configuration", this.configuration);
        ht.put("connectionID", String.valueOf(this.connectionID));
        ht.put("clientID", String.valueOf(this.clientID));
        ht.put("brokerProtocolLevel", String.valueOf(this.brokerProtocolLevel));
        ht.put("reconnecting", String.valueOf(this.reconnecting));
        ht.put("isTopicConnection", String.valueOf(this.isTopicConnection));
        ht.put("isQueueConnection", String.valueOf(this.isQueueConnection));
        ht.put("isStopped", String.valueOf(this.isStopped));
        ht.put("isClosed", String.valueOf(this.isClosed));
        ht.put("connectionIsBroken", String.valueOf(this.connectionIsBroken));
        ht.put("recoverInProcess", String.valueOf(this.recoverInProcess));
        ht.put("failoverEnabled", String.valueOf(this.failoverEnabled));
        ht.put("imqReconnectEnabled", String.valueOf(this.imqReconnect));
        ht.put("isConnectedToHABroker", String.valueOf(this.isConnectedToHABroker));
        if (this.JMQBrokerList != null) {
            ht.put("JMQBrokerList", this.JMQBrokerList);
        }
        if (this.JMQClusterID != null) {
            ht.put("JMQClusterID", this.JMQClusterID);
        }
        if (this.JMQStoreOwner != null) {
            ht.put("JMQStoreOwner", this.JMQStoreOwner);
        }
        if (this.JMQStoreSession != null) {
            ht.put("JMQStoreSession", String.valueOf(this.JMQStoreSession));
        }
        boolean isExpLsrSet = false;
        if (this.exceptionListener != null) {
            isExpLsrSet = true;
        }
        ht.put("IsExceptionListenerSet", String.valueOf(isExpLsrSet));
        if (this.readChannel != null) {
            ht.put("readChannnelIsClosed", String.valueOf(this.readChannel.isClosed));
            ht.put("readChannnelReceivedGoodByeReply", String.valueOf(this.readChannel.receivedGoodByeReply));
        }
        if (this.protocolHandler != null) {
            ht.put("protocolHandlerIsClosed", String.valueOf(this.protocolHandler.isClosed()));
            ht.put("UserBrokerInfo", this.protocolHandler.getUserBrokerInfo());
        }
        ht.put("FlowControl", this.flowControl.getDebugState(this));
        ht.put("# sessions", String.valueOf(this.sessionTable.size()));
        int n = 0;
        Enumeration enum2 = this.sessionTable.elements();
        while (enum2.hasMoreElements()) {
            SessionImpl session = (SessionImpl)enum2.nextElement();
            ht.put("Session[" + n + "]", session.getDebugState(verbose));
            ++n;
        }
        ht.put("# connectionConsumers", String.valueOf(this.connectionConsumerTable.size()));
        n = 0;
        enum2 = this.connectionConsumerTable.elements();
        while (enum2.hasMoreElements()) {
            ConnectionConsumerImpl connectionConsumer = (ConnectionConsumerImpl)enum2.nextElement();
            ht.put("ConnectionConsuer[" + n + "]", connectionConsumer.getDebugState(verbose));
            ++n;
        }
        return ht;
    }

    public Object TEST_GetAttribute(String name) {
        if (name.startsWith("FlowControl")) {
            return this.flowControl.TEST_GetAttribute(name, this);
        }
        return null;
    }

    public void printDebugState() {
        try {
            DebugPrinter dbp = new DebugPrinter(2);
            Hashtable debugState = this.getDebugState(false);
            dbp.setHashtable(debugState);
            dbp.println();
            dbp.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkConnectionState();
        this.setClientIDFlag();
        return new UnifiedSessionImpl(this, transacted, acknowledgeMode);
    }

    @Override
    public Session createSession(int acknowledgeMode) throws JMSException {
        this.checkConnectionState();
        this.setClientIDFlag();
        if (acknowledgeMode == 0) {
            return new UnifiedSessionImpl(this, true, acknowledgeMode);
        }
        return new UnifiedSessionImpl(this, acknowledgeMode);
    }

    @Override
    public Session createSession() throws JMSException {
        return this.createSession(false, 1);
    }

    public XASession createXASession() throws JMSException {
        this.checkConnectionState();
        this.setClientIDFlag();
        return new XASessionImpl(this, false, 0);
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(javax.jms.Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createUnifiedConnectionConsumer(destination, messageSelector, sessionPool, maxMessages, null, false);
    }

    protected QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkConnectionState();
        this.setClientIDFlag();
        return new QueueSessionImpl(this, transacted, acknowledgeMode);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createUnifiedConnectionConsumer(queue, messageSelector, sessionPool, maxMessages, null, false);
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkConnectionState();
        TopicSessionImpl ts = new TopicSessionImpl(this, transacted, acknowledgeMode);
        this.setClientIDFlag();
        return ts;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createUnifiedConnectionConsumer(topic, messageSelector, sessionPool, maxMessages, null, false);
    }

    @Override
    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createUnifiedConnectionConsumer(topic, messageSelector, sessionPool, maxMessages, subscriptionName, true);
    }

    @Override
    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createUnifiedConnectionConsumer(topic, messageSelector, sessionPool, maxMessages, subscriptionName, false, true);
    }

    @Override
    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createUnifiedConnectionConsumer(topic, messageSelector, sessionPool, maxMessages, subscriptionName, true, true);
    }

    private ConnectionConsumer createUnifiedConnectionConsumer(javax.jms.Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages, String subscriptionName, boolean durable) throws JMSException {
        return this.createUnifiedConnectionConsumer(destination, messageSelector, sessionPool, maxMessages, subscriptionName, durable, false);
    }

    private ConnectionConsumer createUnifiedConnectionConsumer(javax.jms.Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages, String subscriptionName, boolean durable, boolean share) throws JMSException {
        JMSException jmse;
        String errorString;
        this.checkConnectionState();
        if ((durable || share) && (subscriptionName == null || "".equals(subscriptionName))) {
            String ekey = "C4066";
            if (!durable) {
                ekey = "C4316";
            }
            errorString = AdministeredObject.cr.getKString(ekey, "\"\"");
            jmse = new JMSException(errorString, ekey);
            ExceptionHandler.throwJMSException(jmse);
        }
        if (maxMessages < 1) {
            String mmsg = String.valueOf(maxMessages);
            errorString = AdministeredObject.cr.getKString("C4030", mmsg);
            jmse = new JMSException(errorString, "C4030");
            ExceptionHandler.throwJMSException(jmse);
        }
        int load = 1;
        String lm = this.getProperty("imqLoadMaxToServerSession");
        if (lm != null && lm.equals("true")) {
            load = maxMessages;
        }
        this.setClientIDFlag();
        return new ConnectionConsumerImpl(this, destination, messageSelector, sessionPool, load, subscriptionName, durable, share);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventListener(EventListener eventListener) throws JMSException {
        this.checkConnectionState();
        if (eventListener == null) {
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            if (this.eventHandler == null) {
                this.eventHandler = new EventHandler(this);
            }
            this.eventListener = eventListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventListener getEventListener() {
        Object object = this.syncObj;
        synchronized (object) {
            return this.eventListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConsumerEventListener(Destination dest, EventListener listener) throws JMSException {
        if (listener == null) {
            throw new JMSException("listener is null");
        }
        this.checkConnectionState();
        Object object = this.syncObj;
        synchronized (object) {
            if (this.eventHandler == null) {
                this.eventHandler = new EventHandler(this);
            }
            this.eventHandler.addConsumerEventListener(dest, listener);
        }
        try {
            this.protocolHandler.requestConsumerInfo(dest, false);
        }
        catch (Exception ex) {
            try {
                this.eventHandler.removeConsumerEventListener(dest);
            }
            catch (Exception e) {
                // empty catch block
            }
            JMSException jmsex = new JMSException(AdministeredObject.cr.getKString("C4300", dest.getName(), ex.getMessage()));
            jmsex.setLinkedException(ex);
            throw jmsex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumerEventListener(Destination dest) throws JMSException {
        this.checkConnectionState();
        Object object = this.syncObj;
        synchronized (object) {
            if (this.eventHandler == null) {
                throw new IllegalStateException(AdministeredObject.cr.getKString("C4301"));
            }
            this.eventHandler.removeConsumerEventListener(dest);
        }
        try {
            this.protocolHandler.requestConsumerInfo(dest, true);
        }
        catch (Exception e) {
            connectionLogger.log(Level.WARNING, AdministeredObject.cr.getKString("W2004", dest.getName(), e.getMessage()), e);
        }
    }

    @Override
    public String getBrokerAddress() {
        String brokerAddr = null;
        try {
            brokerAddr = this.getProtocolHandler().getConnectionHandler().getBrokerAddress();
        }
        catch (Exception e) {
            brokerAddr = this.getLastContactedBrokerAddress();
        }
        return brokerAddr;
    }

    public boolean isConnectedToSameBroker(ConnectionImpl foreignConn) {
        boolean isSame = false;
        if (foreignConn == null) {
            return false;
        }
        String foreignAddr = foreignConn.getBrokerAddress();
        String myAddr = this.getBrokerAddress();
        if (myAddr.equals(foreignAddr)) {
            isSame = true;
        }
        return isSame;
    }

    public String getBrokerAddressList() {
        return this.JMQBrokerList;
    }

    @Override
    public boolean isConnectedToHABroker() {
        return this.isConnectedToHABroker;
    }

    public boolean getIsCloseCalled() {
        return this.isCloseCalled;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void triggerConnectionReconnectedEvent() {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionReconnectedEvent();
        } else {
            this.setReconnecting(false);
        }
        this.logLifeCycle("E301");
    }

    public void triggerConnectionReconnectFailedEvent(JMSException jmse) {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionReconnectFailedEvent(jmse, this.lastContactedBrokerAddress);
        }
        this.logLifeCycle("E401");
    }

    public void triggerConnectionClosingEvent(long timePeriod) {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionClosingEvent("E101", timePeriod);
        }
        this.logLifeCycle("E101");
    }

    public void triggerConnectionClosedEvent(String evcode, JMSException jmse) {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionClosedEvent(evcode, jmse);
        }
        this.logLifeCycle(evcode);
    }

    public void triggerConnectionExitEvent(JMSException jmse) {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionExitEvent(jmse, this.exceptionListener);
        } else if (this.exceptionListener != null) {
            this.exceptionListener.onException(jmse);
        }
    }

    public void triggerConnectionAddressListChangedEvent(String addressList) {
        if (this.eventListener != null && this.extendedEventNotification) {
            this.eventHandler.triggerConnectionAddressListChangedEvent(addressList);
        }
        this.logLifeCycle("E600");
    }

    public void triggerConsumerEvent(int infoType, String destName, int destType) {
        if (this.eventHandler != null) {
            this.eventHandler.triggerConsumerEvent(infoType, destName, destType);
        }
    }

    public void logLifeCycle(String key) {
        if (connectionLogger.isLoggable(Level.FINE)) {
            connectionLogger.log(Level.FINE, key, this);
        }
    }

    public boolean shouldUpdateAddressList() {
        boolean flag = false;
        flag = this.JMQBrokerList == null ? false : !this.JMQBrokerList.equals(this.savedJMQBrokerList);
        return flag;
    }

    public void setLastContactedBrokerAddress(String addr) {
        this.lastContactedBrokerAddress = addr;
    }

    public String getLastContactedBrokerAddress() {
        return this.lastContactedBrokerAddress;
    }

    public static Logger getConnectionLogger() {
        return connectionLogger;
    }

    public synchronized void setExtendedEventNotification(boolean flag) {
        this.extendedEventNotification = flag;
    }

    public synchronized boolean getExtendedEventNotification() {
        return this.extendedEventNotification;
    }

    public long getPingAckTimeout() {
        return this.protocolHandler.getPingAckTimeout();
    }

    public int getSocketConnectTimeout() {
        return this.imqSocketConnectTimeout;
    }

    public Integer getPortMapperSoTimeout() {
        return this.imqPortMapperSoTimeout;
    }

    public long getAsyncSendCompletionWaitTimeout() {
        return this.asyncSendCompletionWaitTimeout;
    }

    public synchronized void setEnableSharedClientID(boolean flag) {
        this.imqEnableSharedClientID = flag;
    }

    public synchronized boolean getEnableSharedClientID() {
        return this.imqEnableSharedClientID;
    }

    public synchronized void setEnableSharedSubscriptions(boolean flag) {
        this.imqEnableSharedSubscriptions = flag;
    }

    public synchronized boolean getEnableSharedSubscriptions() {
        return this.imqEnableSharedSubscriptions;
    }

    public void setConnectedToHABroker() {
        if (this.isHAEnabled()) {
            this.isConnectedToHABroker = true;
            if (!"ADMIN".equals(this.connectionType)) {
                this.imqReconnect = true;
                this.configuration.setProperty("imqReconnectEnabled", Boolean.toString(true));
                connectionLogger.fine("Connected to HA broker, auto-reconnect is enabled");
            } else {
                connectionLogger.fine("*** admin user, no auto-reconnect");
            }
        } else if (!"ADMIN".equals(this.connectionType)) {
            String info = AdministeredObject.cr.getKString("I112", this.getLastContactedBrokerAddress());
            connectionLogger.log(Level.WARNING, info);
        }
    }
}

