/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol.tcp;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MQAddress;
import com.sun.messaging.jmq.jmsclient.PortMapperClient;
import com.sun.messaging.jmq.jmsclient.protocol.SocketConnectionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import javax.jms.JMSException;

public class TCPConnectionHandler
extends SocketConnectionHandler {
    private static int connectionCount = 0;
    private int counter = 0;
    private Socket socket = null;
    private int socketConnectTimeout = 0;
    private String host = null;
    private int baseport = 0;
    private int directport = 0;
    private int port = 0;
    public static boolean imqCheckHostIsReachable = false;
    public static int imqIsReachableTimeout = 30000;

    TCPConnectionHandler(Object conn) throws JMSException {
        ConnectionImpl connection = (ConnectionImpl)conn;
        this.directport = 0;
        this.host = connection.getProperty("imqBrokerHostName");
        this.baseport = Integer.parseInt(connection.getProperty("imqBrokerHostPort"));
        this.directport = Integer.parseInt(connection.getProperty("imqBrokerServicePort"));
        String namedservice = connection.getProperty("imqBrokerServiceName");
        this.socketConnectTimeout = connection.getSocketConnectTimeout();
        if (this.directport == 0) {
            PortMapperClient pmc = new PortMapperClient(connection);
            this.port = namedservice != null && !"".equals(namedservice) ? pmc.getPortForService("tcp", namedservice) : pmc.getPortForProtocol("tcp");
        } else {
            this.port = this.directport;
        }
        ConnectionImpl.checkHostPort(this.host, this.port);
        try {
            connection.setLastContactedBrokerAddress(this.getBrokerAddress());
            this.socket = this.makeSocket(this.host, this.port);
            this.counter = ++connectionCount;
        }
        catch (Exception e) {
            connection.getExceptionHandler();
            ExceptionHandler.handleConnectException(e, this.host, this.port);
        }
    }

    TCPConnectionHandler(MQAddress addr, ConnectionImpl conn) throws JMSException {
        ConnectionImpl connection = conn;
        this.port = 0;
        this.host = addr.getHostName();
        this.directport = 0;
        if (addr.isServicePortFinal()) {
            this.directport = addr.getPort();
        }
        String namedservice = addr.getServiceName();
        this.socketConnectTimeout = connection.getSocketConnectTimeout();
        if (this.directport == 0) {
            PortMapperClient pmc = new PortMapperClient(addr, connection);
            this.baseport = pmc.getHostPort();
            this.port = namedservice != null && !"".equals(namedservice) ? pmc.getPortForService("tcp", namedservice) : pmc.getPortForProtocol("tcp");
        } else {
            this.port = this.directport;
        }
        conn.setLastContactedBrokerAddress(this.getBrokerAddress());
        ConnectionImpl.checkHostPort(this.host, this.port);
        try {
            this.socket = this.makeSocket(this.host, this.port);
            this.counter = ++connectionCount;
        }
        catch (Exception e) {
            connection.getExceptionHandler();
            ExceptionHandler.handleConnectException(e, this.host, this.port);
        }
    }

    private Socket makeSocket(String host, int port) throws Exception {
        if (Debug.debug) {
            Debug.println("in TCPConnectionHandler.makeSocket()");
        }
        boolean tcpNoDelay = true;
        String prop = System.getProperty("imqTcpNoDelay", "true");
        if (prop.equals("false")) {
            tcpNoDelay = false;
        }
        this.checkIsReachable(host, port);
        Socket socket = this.makeSocketWithTimeout(host, port, this.socketConnectTimeout);
        socket.setTcpNoDelay(tcpNoDelay);
        return socket;
    }

    private void checkIsReachable(String host, int port) throws IOException {
        if (imqCheckHostIsReachable) {
            ConnectionImpl.getConnectionLogger().fine("checking network is reachable");
            InetAddress iaddr = InetAddress.getByName(host);
            boolean isReachable = iaddr.isReachable(imqIsReachableTimeout);
            if (!isReachable) {
                ConnectionImpl.getConnectionLogger().fine("network is not reachable, host=" + host);
                throw new IOException("Network is unreachable. Host= " + host);
            }
            ConnectionImpl.getConnectionLogger().fine("network is reachable, host=" + host);
        }
    }

    private Socket makeSocketWithTimeout(String host, int port, int timeout) throws IOException {
        Socket socket = null;
        if (timeout > 0) {
            ConnectionImpl.getConnectionLogger().fine("connecting with timeout=" + timeout);
            socket = new Socket();
            InetSocketAddress socketAddr = new InetSocketAddress(host, port);
            socket.connect(socketAddr, timeout);
            socket.setSoTimeout(0);
        } else {
            ConnectionImpl.getConnectionLogger().fine("connecting with no timeout ...");
            socket = new Socket(host, port);
        }
        ConnectionImpl.getConnectionLogger().fine("socket connected., host=" + host + ", port=" + port);
        return socket;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public int getLocalPort() throws IOException {
        return this.socket.getLocalPort();
    }

    @Override
    protected void closeSocket() throws IOException {
        this.socket.close();
    }

    @Override
    public String getBrokerHostName() {
        return this.host;
    }

    @Override
    public String getBrokerAddress() {
        if (this.directport == 0) {
            return this.host + ":" + this.baseport + "(" + this.port + ")";
        }
        return this.host + ":" + this.directport;
    }

    public int getSocketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    public String toString() {
        String info = null;
        try {
            info = "TCPConnectionHandler: " + this.counter + "-" + this.getLocalPort();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return info;
    }

    static {
        try {
            imqCheckHostIsReachable = Boolean.getBoolean("imqCheckHostIsReachable");
            String tmp = System.getProperty("imqIsReachableTimeout", "30000");
            imqIsReachableTimeout = Integer.parseInt(tmp);
        }
        catch (Exception ex) {
            ConnectionImpl.getConnectionLogger().log(Level.WARNING, ex.toString(), ex);
        }
    }
}

