/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;

public class GlobalProperties
implements ConfigListener {
    private static final Object lock = GlobalProperties.class;
    private static GlobalProperties globals = null;
    private final int AUTOCREATE_TOPIC_NDX = 0;
    private final int AUTOCREATE_QUEUE_NDX = 1;
    private final int REDELIVER_NDX = 2;
    private final int TRANSACTION_DEBUG_NDX = 3;
    public final String[] property_names = new String[]{"imq.autocreate.topic", "imq.autocreate.queue", "imq.redelivered.optimization", "imq.transaction.debug"};
    public boolean AUTOCREATE_TOPIC = false;
    public boolean AUTOCREATE_QUEUE = false;
    public boolean REDELIVER_OPTIMIZATION = true;
    public boolean TRANSACTION_DEBUG = false;

    private GlobalProperties() {
        BrokerConfig config = Globals.getConfig();
        for (int i = 0; i < this.property_names.length; ++i) {
            this.updateProperty(this.property_names[i]);
            config.addListener(this.property_names[i], this);
        }
    }

    public void updateProperty(String propname) {
        BrokerConfig config = Globals.getConfig();
        if (propname.equals(this.property_names[0])) {
            this.AUTOCREATE_TOPIC = config.getBooleanProperty(propname);
        } else if (propname.equals(this.property_names[1])) {
            this.AUTOCREATE_QUEUE = config.getBooleanProperty(propname);
        } else if (propname.equals(this.property_names[2])) {
            this.REDELIVER_OPTIMIZATION = config.getBooleanProperty(propname, true);
        } else if (propname.equals(this.property_names[3])) {
            this.TRANSACTION_DEBUG = config.getBooleanProperty(propname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalProperties getGlobalProperties() {
        if (globals == null) {
            Object object = lock;
            synchronized (object) {
                if (globals == null) {
                    globals = new GlobalProperties();
                }
            }
        }
        return globals;
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
    }

    @Override
    public boolean update(String name, String value) {
        this.updateProperty(name);
        return true;
    }
}

