/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.audit.impl;

import com.sun.messaging.jmq.jmsserver.audit.api.MQAuditService;
import com.sun.messaging.jmq.jmsserver.audit.api.MQAuditSession;
import com.sun.messaging.jmq.jmsserver.audit.impl.MQAuditSessionImpl;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.audit.impl.MQAuditManager")
@PerLookup
public class MQAuditManager
extends MQAuditSessionImpl {
    private MQAuditSession logAuditSession = null;
    private MQAuditSession bsmAuditSession = null;

    public MQAuditManager() {
        if (!MQAuditService.AUDIT_LOGGING_LICENSED) {
            return;
        }
        if (MQAuditService.logAuditEnabled()) {
            try {
                this.logAuditSession = MQAuditService.getAuditSession("log");
                this.auditOn = this.logAuditSession.isAuditOn();
            }
            catch (BrokerException e) {
                this.logger.log(32, "Failed to get audit session to log audit records");
            }
        }
        if (MQAuditService.isBSMAudit()) {
            try {
                this.bsmAuditSession = MQAuditService.getAuditSession("bsm");
                this.auditOn = this.auditOn || this.bsmAuditSession.isAuditOn();
            }
            catch (BrokerException e) {
                this.logger.log(32, "Failed to get audit session to log BSM audit records");
            }
        }
    }

    @Override
    public void setInstance(String name, String host, int port) {
        super.setInstance(name, host, port);
        if (this.logAuditSession != null) {
            this.logAuditSession.setInstance(name, host, port);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.setInstance(name, host, port);
        }
    }

    @Override
    public void authentication(String user, String host, boolean success) {
        if (this.logAuditSession != null) {
            this.logAuditSession.authentication(user, host, success);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.authentication(user, host, success);
        }
    }

    @Override
    public void brokerOperation(String user, String host, String op) {
        if (this.logAuditSession != null) {
            this.logAuditSession.brokerOperation(user, host, op);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.brokerOperation(user, host, op);
        }
    }

    @Override
    public void connectionAuth(String user, String host, String type, String name, boolean success) {
        if (this.logAuditSession != null) {
            this.logAuditSession.connectionAuth(user, host, type, name, success);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.connectionAuth(user, host, type, name, success);
        }
    }

    @Override
    public void destinationAuth(String user, String host, String type, String name, String op, boolean success) {
        if (this.logAuditSession != null) {
            this.logAuditSession.destinationAuth(user, host, type, name, op, success);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.destinationAuth(user, host, type, name, op, success);
        }
    }

    @Override
    public void storeOperation(String user, String host, String op) {
        if (this.logAuditSession != null) {
            this.logAuditSession.storeOperation(user, host, op);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.storeOperation(user, host, op);
        }
    }

    @Override
    public void destinationOperation(String user, String host, String op, String type, String name) {
        if (this.logAuditSession != null) {
            this.logAuditSession.destinationOperation(user, host, op, type, name);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.destinationOperation(user, host, op, type, name);
        }
    }

    @Override
    public void durableSubscriberOperation(String user, String host, String op, String name, String clientID) {
        if (this.logAuditSession != null) {
            this.logAuditSession.durableSubscriberOperation(user, host, op, name, clientID);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.durableSubscriberOperation(user, host, op, name, clientID);
        }
    }
}

