/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.manager;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterReason;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;

public class ClusteredBrokerImpl
implements ClusteredBroker {
    protected Logger logger = Globals.getLogger();
    protected BrokerResources br = Globals.getBrokerResources();
    String brokerName = null;
    MQAddress address = null;
    transient String instanceName = null;
    boolean local = false;
    boolean configed = false;
    Integer status = new Integer(0);
    BrokerState state = BrokerState.INITIALIZING;
    Integer version = new Integer(0);
    UID brokerSessionUID = null;
    boolean isgen = false;
    protected ClusterManagerImpl parent = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredBrokerImpl(ClusterManagerImpl parent, MQAddress url, boolean local, UID id) {
        this.parent = parent;
        this.local = local;
        this.address = url;
        this.brokerSessionUID = id;
        ClusteredBrokerImpl clusteredBrokerImpl = this;
        synchronized (clusteredBrokerImpl) {
            if (local) {
                this.brokerName = Globals.getBrokerID();
                this.instanceName = Globals.getConfigName();
            }
            if (this.brokerName == null) {
                this.isgen = true;
                ++parent.brokerindx;
                this.brokerName = "broker" + parent.brokerindx;
            }
        }
    }

    private ClusteredBrokerImpl() {
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ClusteredBroker)) {
            return false;
        }
        return this.getBrokerName().equals(((ClusteredBroker)o).getBrokerName());
    }

    @Override
    public int hashCode() {
        return this.getBrokerName().hashCode();
    }

    public String toString() {
        if (!this.local) {
            return this.brokerName + "(" + this.address + ")";
        }
        return this.brokerName + "* (" + this.address + ")";
    }

    @Override
    public String getBrokerName() {
        return this.brokerName;
    }

    @Override
    public MQAddress getBrokerURL() {
        return this.address;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public void setInstanceName(String instName) {
        this.instanceName = instName;
    }

    @Override
    public void setBrokerURL(MQAddress address) throws Exception {
        MQAddress oldaddress = this.address;
        this.address = address;
        this.parent.brokerChanged(ClusterReason.ADDRESS_CHANGED, this.getBrokerName(), oldaddress, this.address, null, null);
    }

    @Override
    public boolean isLocalBroker() {
        return this.local;
    }

    @Override
    public synchronized int getStatus() {
        return this.status;
    }

    @Override
    public synchronized int getVersion() {
        return this.version == null ? 0 : this.version;
    }

    @Override
    public synchronized void setVersion(int version) throws Exception {
        Integer oldversion = this.version;
        this.version = new Integer(version);
        this.parent.brokerChanged(ClusterReason.VERSION_CHANGED, this.getBrokerName(), oldversion, this.version, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(int newstatus, Object userData) {
        Integer oldstatus = null;
        UID uid = null;
        if (BrokerStatus.getBrokerIsDown(newstatus)) {
            newstatus = BrokerStatus.setBrokerLinkIsDown(newstatus);
        } else if (BrokerStatus.getBrokerLinkIsDown(newstatus)) {
            newstatus = BrokerStatus.setBrokerIsDown(newstatus);
        } else if (BrokerStatus.getBrokerLinkIsUp(newstatus)) {
            newstatus = BrokerStatus.setBrokerIsUp(newstatus);
        } else if (BrokerStatus.getBrokerIsUp(newstatus)) {
            newstatus = BrokerStatus.setBrokerLinkIsUp(newstatus);
        }
        ClusteredBrokerImpl clusteredBrokerImpl = this;
        synchronized (clusteredBrokerImpl) {
            if (this.status == newstatus) {
                return;
            }
            oldstatus = this.status;
            this.status = new Integer(newstatus);
            uid = this.getBrokerSessionUID();
        }
        this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), oldstatus, this.status, uid, userData);
        try {
            if (BrokerStatus.getBrokerIsUp(newstatus)) {
                this.setState(BrokerState.OPERATING);
            }
            if (BrokerStatus.getBrokerIsDown(newstatus)) {
                this.setState(BrokerState.SHUTDOWN_COMPLETE);
            }
        }
        catch (Exception ex) {
            this.logger.logStack(4, "Error setting state ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBrokerIsUp(boolean up, UID brokerSession, Object userData) {
        UID uid = brokerSession;
        Integer oldstatus = null;
        Integer newstatus = null;
        ClusteredBrokerImpl clusteredBrokerImpl = this;
        synchronized (clusteredBrokerImpl) {
            if (!up && !uid.equals(this.getBrokerSessionUID())) {
                this.logger.log(8, this.br.getKString("B1337", "[BrokerSession:" + uid + "]", this.toString()));
                oldstatus = new Integer(16);
                newstatus = BrokerStatus.setBrokerIsDown(oldstatus);
            } else {
                oldstatus = this.status;
                int newStatus = 0;
                newStatus = up ? BrokerStatus.setBrokerIsUp(this.status) : BrokerStatus.setBrokerIsDown(this.status);
                this.status = new Integer(newStatus);
                uid = this.getBrokerSessionUID();
                newstatus = this.status;
            }
        }
        this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), oldstatus, newstatus, uid, userData);
        try {
            if (up) {
                this.setState(BrokerState.OPERATING);
            } else {
                this.setState(BrokerState.SHUTDOWN_COMPLETE);
            }
        }
        catch (Exception ex) {
            this.logger.logStack(4, "Error setting state ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBrokerLinkUp(boolean up, Object userData) {
        Integer oldstatus = null;
        UID uid = null;
        ClusteredBrokerImpl clusteredBrokerImpl = this;
        synchronized (clusteredBrokerImpl) {
            oldstatus = this.status;
            uid = this.getBrokerSessionUID();
            int newStatus = 0;
            newStatus = up ? BrokerStatus.setBrokerLinkIsUp(BrokerStatus.setBrokerIsUp(this.status)) : BrokerStatus.setBrokerLinkIsDown(BrokerStatus.setBrokerIsDown(this.status));
            this.status = new Integer(newStatus);
        }
        this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), oldstatus, this.status, uid, userData);
        try {
            if (up) {
                this.setState(BrokerState.OPERATING);
            } else {
                this.setState(BrokerState.SHUTDOWN_COMPLETE);
            }
        }
        catch (Exception ex) {
            this.logger.logStack(4, "Error setting state ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBrokerInDoubt(boolean up, Object userData) {
        UID uid = (UID)userData;
        Integer oldstatus = null;
        Integer newstatus = null;
        ClusteredBrokerImpl clusteredBrokerImpl = this;
        synchronized (clusteredBrokerImpl) {
            if (up && !uid.equals(this.getBrokerSessionUID())) {
                this.logger.log(8, this.br.getKString("B1336", "[BrokerSession:" + uid + "]", this.toString()));
                oldstatus = new Integer(257);
                newstatus = BrokerStatus.setBrokerInDoubt(oldstatus);
            } else {
                oldstatus = this.status;
                int newStatus = 0;
                uid = this.getBrokerSessionUID();
                newStatus = up ? BrokerStatus.setBrokerInDoubt(this.status) : BrokerStatus.setBrokerNotInDoubt(this.status);
                newstatus = this.status = new Integer(newStatus);
            }
        }
        this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), oldstatus, newstatus, uid, userData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ClusteredBrokerImpl clusteredBrokerImpl = this;
        synchronized (clusteredBrokerImpl) {
            this.status = new Integer(BrokerStatus.setBrokerIsDown(this.status));
        }
        if (!this.isConfigBroker()) {
            this.parent.removeFromAllBrokers(this.getBrokerName());
        }
        this.parent.brokerChanged(ClusterReason.REMOVED, this.getBrokerName(), this, null, this.getBrokerSessionUID(), null);
    }

    @Override
    public BrokerState getState() {
        return this.state;
    }

    @Override
    public void setState(BrokerState state) throws IllegalAccessException, IllegalStateException, IllegalArgumentException {
        BrokerState oldState = this.state;
        this.state = state;
        this.parent.brokerChanged(ClusterReason.STATE_CHANGED, this.getBrokerName(), oldState, this.state, null, null);
    }

    @Override
    public boolean isConfigBroker() {
        return this.configed;
    }

    public void setConfigBroker(boolean config) {
        this.configed = config;
    }

    @Override
    public synchronized UID getBrokerSessionUID() {
        return this.brokerSessionUID;
    }

    @Override
    public synchronized void setBrokerSessionUID(UID session) {
        this.brokerSessionUID = session;
    }

    @Override
    public boolean isBrokerIDGenerated() {
        return this.isgen;
    }

    @Override
    public String getNodeName() throws BrokerException {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".getNodeName()");
    }
}

