/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.util.HashMap;
import java.util.Hashtable;

public class SelectorFilter
implements Filter {
    private static boolean DEBUG = false;
    Selector selector = null;
    String selectorstr = null;

    public SelectorFilter(String selectorstr) throws SelectorFormatException {
        this.selectorstr = selectorstr;
        this.selector = Selector.compile(selectorstr);
    }

    public SelectorFilter(String selectorstr, Selector sel) {
        this.selectorstr = selectorstr;
        this.selector = sel;
    }

    @Override
    public synchronized boolean matches(Object o) {
        if (this.selector == null) {
            return false;
        }
        if (o instanceof PacketReference) {
            PacketReference ref = (PacketReference)o;
            Hashtable props = null;
            HashMap headers = null;
            try {
                if (this.selector.usesProperties()) {
                    props = ref.getProperties();
                }
                if (this.selector.usesFields()) {
                    headers = ref.getHeaders();
                }
            }
            catch (ClassNotFoundException ex) {
                assert (false) : ref;
                throw new RuntimeException("error with properties", ex);
            }
            try {
                boolean match = this.selector.match(props, headers);
                if (DEBUG && match) {
                    Globals.getLogger().log(4, "Match " + o + "against " + this.selector + " got " + match);
                }
                return match;
            }
            catch (SelectorFormatException ex) {
                Globals.getLogger().log(8, "Bad selector format, can not match against  " + this.selector, ex);
                return false;
            }
        }
        assert (false) : " weird ";
        return false;
    }

    public String toString() {
        return "SelectorFilter[" + this.selector + "]" + this.hashCode();
    }
}

