/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.cluster.api.RemoteTransactionAckEntry;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransaction;
import com.sun.messaging.jmq.jmsserver.data.ToTxnLogConverter;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TxnConverter;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.TxnLoggingStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.ArrayList;

class RemoteTxnConverter
extends TxnConverter {
    RemoteTxnConverter(TransactionList transactionList, TxnLoggingStore store) {
        super(transactionList, store);
    }

    @Override
    String getPrefix() {
        return Thread.currentThread() + " ToTxnLogConverter.RemoteTxnConverter.";
    }

    void convert(TransactionInformation txnInfo) throws BrokerException {
        int state;
        if (ToTxnLogConverter.DEBUG) {
            logger.log(4, this.getPrefix() + " convert " + txnInfo);
        }
        if ((state = txnInfo.getState().getState()) != 5) {
            String msg = this.getPrefix() + " convert: unknown state  " + state + " for " + txnInfo;
            logger.log(32, msg);
        }
        TransactionUID txid = txnInfo.getTID();
        TransactionState newState = new TransactionState(txnInfo.getState());
        RemoteTransactionAckEntry[] rtaes = this.transactionList.getRecoveryRemoteTransactionAcks(txid);
        if (rtaes != null) {
            ArrayList<TransactionAcknowledgement> al = new ArrayList<TransactionAcknowledgement>();
            for (int i = 0; i < rtaes.length; ++i) {
                RemoteTransactionAckEntry rtae = rtaes[i];
                TransactionAcknowledgement[] txnAcks = rtae.getAcks();
                for (int j = 0; j < txnAcks.length; ++j) {
                    al.add(txnAcks[j]);
                }
            }
            TransactionAcknowledgement[] txnAcks = al.toArray(new TransactionAcknowledgement[0]);
            DestinationUID[] destIds = new DestinationUID[txnAcks.length];
            for (int i = 0; i < txnAcks.length; ++i) {
                SysMessageID sid = txnAcks[i].getSysMessageID();
                PacketReference p = DestinationList.get((PartitionedStore)((Object)this.store), sid);
                DestinationUID destID = null;
                if (p != null) {
                    destID = p.getDestinationUID();
                } else {
                    logger.log(16, "Could not find packet for " + sid);
                }
                destIds[i] = destID;
            }
            TransactionBroker txnBroker = this.transactionList.getRemoteTransactionHomeBroker(txid);
            BrokerAddress txnHomeBroker = txnBroker.getBrokerAddress();
            RemoteTransaction remoteTxn = new RemoteTransaction(txid, newState, txnAcks, destIds, txnHomeBroker);
            this.store.logTxn(remoteTxn);
        } else {
            logger.log(32, "Could not find RemoteTransactionAckEntry for " + txid);
        }
    }
}

