/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Hashtable;

public class VerifyTransactionHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        Hashtable<String, Object> hash;
        Packet pkt;
        block28: {
            block27: {
                int status = 200;
                String reason = null;
                TransactionList[] tls = DestinationList.getTransactionList(con.getPartitionedStore());
                TransactionList translist = tls[0];
                assert (msg.getPacketType() == 78);
                pkt = new Packet(con.useDirectBuffers());
                pkt.setConsumerID(msg.getConsumerID());
                pkt.setPacketType(79);
                hash = new Hashtable<String, Object>();
                Hashtable props = null;
                TransactionUID tuid = null;
                JMQXid xid = null;
                try {
                    long tid;
                    props = msg.getProperties();
                    Long ttid = (Long)props.get("JMQTransactionID");
                    if (ttid == null) {
                        throw new BrokerException("Bad/Missing transaction id");
                    }
                    ByteBuffer body = msg.getMessageBodyByteBuffer();
                    if (body != null) {
                        JMQByteBufferInputStream bbis = new JMQByteBufferInputStream(body);
                        try {
                            xid = JMQXid.read(new DataInputStream(bbis));
                        }
                        catch (IOException e) {
                            this.logger.log(32, "B3100", "Could not decode xid from packet " + PacketType.getString(msg.getPacketType()) + ":" + e);
                            BrokerException bex = new BrokerException(e.getMessage(), 400);
                            bex.initCause(e);
                            throw bex;
                        }
                    }
                    if ((tid = ttid.longValue()) != 0L) {
                        tuid = new TransactionUID(tid);
                    } else if (xid != null) {
                        tuid = translist.xidToUID(xid);
                        if (tuid == null) {
                            String emsg = Globals.getBrokerResources().getKString("B2195", "" + xid, PacketType.getString(msg.getPacketType()));
                            this.logger.log(16, emsg);
                            throw new BrokerException("Unknown XID " + xid, 404);
                        }
                    } else {
                        this.logger.log(32, "B3100", "No transaction ID in " + PacketType.getString(msg.getPacketType()));
                        throw new BrokerException("No transaction ID", 400);
                    }
                    TransactionState ts = translist.retrieveState(tuid, true);
                    if (ts == null) {
                        status = 410;
                    } else {
                        int realstate = ts.getState();
                        if (realstate != 5) {
                            throw new BrokerException("Transaction " + tuid + " is not PREPARED " + ts, 410);
                        }
                        Hashtable m = translist.getTransactionMap(tuid, true);
                        if (m != null) {
                            try {
                                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                                ObjectOutputStream oos = new ObjectOutputStream(bos);
                                oos.writeObject(m);
                                oos.flush();
                                bos.flush();
                                pkt.setMessageBody(bos.toByteArray());
                                bos.close();
                            }
                            catch (Exception ex) {
                                this.logger.log(16, "B3100", (Object)" sending back broker data", (Throwable)ex);
                            }
                        }
                    }
                }
                catch (BrokerException ex) {
                    reason = ex.getMessage();
                    status = ex.getStatusCode();
                    if (status != 410 && status != 404) {
                        this.logger.logStack(8, "B3100", "unknown status", (Throwable)ex);
                    } else {
                        this.logger.log(4, "Transaction " + tuid + " not found", ex);
                    }
                }
                catch (Throwable ex) {
                    this.logger.logStack(8, "B3100", "exception processing verify transaction ", ex);
                    reason = ex.toString();
                    status = 500;
                }
                if (status == 410) {
                    status = 404;
                }
                hash.put("JMQStatus", new Integer(status));
                if (reason != null) {
                    hash.put("JMQReason", reason);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                if (IMQBasicConnection.getDumpPacket()) break block27;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                if (!IMQBasicConnection.getDumpOutPacket()) break block28;
            }
            hash.put("JMQReqID", msg.getSysMessageID().toString());
        }
        pkt.setProperties(hash);
        con.sendControlMessage(pkt);
        return true;
    }
}

