/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.net.IPAddress;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class GetConsumersHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetConsumersHandler.getDEBUG();

    public GetConsumersHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        String errMsg;
        Vector<HashMap> v;
        int status;
        Packet reply;
        block8: {
            if (DEBUG) {
                this.logger.log(4, this.getClass().getName() + ": " + cmd_props);
            }
            String destination = (String)cmd_props.get("JMQDestination");
            Integer destType = (Integer)cmd_props.get("JMQDestType");
            reply = new Packet(con.useDirectBuffers());
            reply.setPacketType(5);
            status = 200;
            v = new Vector<HashMap>();
            errMsg = null;
            if (destination == null || destType == null) {
                errMsg = "Destination name and type not specified";
                this.logger.log(32, errMsg);
                status = 500;
            }
            if (destination != null) {
                try {
                    Destination[] ds = DestinationList.getDestination(null, destination, DestType.isQueue(destType));
                    Destination d = ds[0];
                    if (d != null) {
                        Iterator cons = d.getConsumers();
                        while (cons.hasNext()) {
                            Consumer oneCon = (Consumer)cons.next();
                            HashMap h = GetConsumersHandler.constructConsumerInfo(oneCon.getConsumerUID(), d);
                            v.add(h);
                        }
                    } else {
                        errMsg = this.rb.getString("B4017", destination);
                        status = 404;
                    }
                }
                catch (Exception ex) {
                    this.logger.log(32, "Internal Error ", ex);
                    status = 500;
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
        }
        GetConsumersHandler.setProperties(reply, 19, status, errMsg);
        this.setBodyObject(reply, v);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }

    public static HashMap constructConsumerInfo(ConsumerUID cid, Destination d) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("AcknowledgeMode", GetConsumersHandler.getAcknowledgeMode(cid));
        h.put("ClientID", GetConsumersHandler.getClientID(cid));
        h.put("ConnectionID", GetConsumersHandler.getConnectionID(cid));
        h.put("ConsumerID", Long.toString(cid.longValue()));
        h.put("DestinationName", d.getDestinationName());
        h.put("DestinationType", d.isQueue() ? new Integer(1) : new Integer(2));
        h.put("Durable", GetConsumersHandler.getDurable(cid));
        h.put("DurableActive", GetConsumersHandler.getDurableActive(cid));
        h.put("DurableName", GetConsumersHandler.getDurableName(cid));
        h.put("FlowPaused", GetConsumersHandler.getFlowPaused(cid));
        h.put("Host", GetConsumersHandler.getHost(cid));
        h.put("LastAckTime", GetConsumersHandler.getLastAckTime(cid));
        h.put("NumMsgs", GetConsumersHandler.getNumMsgs(cid));
        h.put("NumMsgsPendingAcks", GetConsumersHandler.getNumMsgsPendingAcks(cid));
        h.put("Selector", GetConsumersHandler.getSelector(cid));
        h.put("ServiceName", GetConsumersHandler.getServiceName(cid));
        h.put("User", GetConsumersHandler.getUser(cid));
        return h;
    }

    public static int toExternalAckMode(int internalAckMode) {
        switch (internalAckMode) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
            case 32768: {
                return 32768;
            }
        }
        return -1;
    }

    private static Integer getAcknowledgeMode(ConsumerUID cid) {
        return new Integer(GetConsumersHandler.toExternalAckMode(cid.getAckType()));
    }

    private static String getClientID(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        return con.getClientID();
    }

    private static String getConnectionID(ConsumerUID cid) {
        ConnectionUID cxnId = GetConsumersHandler.getConnectionUID(cid);
        if (cxnId == null) {
            return null;
        }
        return Long.toString(cxnId.longValue());
    }

    public static boolean isDurable(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con != null) {
            return con.isDurableSubscriber();
        }
        return false;
    }

    private static Boolean getDurable(ConsumerUID cid) {
        return new Boolean(GetConsumersHandler.isDurable(cid));
    }

    public static boolean isDurableActive(ConsumerUID cid) {
        if (!GetConsumersHandler.isDurable(cid)) {
            return false;
        }
        Consumer con = Consumer.getConsumer(cid);
        if (con != null) {
            return con.isActive();
        }
        return false;
    }

    public static ConnectionUID getConnectionUID(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        ConnectionUID cxnId = null;
        if (GetConsumersHandler.isDurable(cid) && !GetConsumersHandler.isDurableActive(cid)) {
            return null;
        }
        if (con != null) {
            cxnId = con.getConnectionUID();
        }
        return cxnId;
    }

    private static Boolean getDurableActive(ConsumerUID cid) {
        if (!GetConsumersHandler.getDurable(cid).booleanValue()) {
            return null;
        }
        return new Boolean(GetConsumersHandler.isDurableActive(cid));
    }

    private static String getDurableName(ConsumerUID cid) {
        if (!GetConsumersHandler.getDurable(cid).booleanValue()) {
            return null;
        }
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        if (con instanceof Subscription) {
            return ((Subscription)con).getDurableName();
        }
        Subscription sub = con.getSubscription();
        if (sub != null) {
            return sub.getDurableName();
        }
        return null;
    }

    private static Boolean getFlowPaused(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        return new Boolean(con.getIsFlowPaused());
    }

    public static ConnectionInfo getConnectionInfo(long id) {
        ConnectionManager cm = Globals.getConnectionManager();
        ConnectionInfo cxnInfo = null;
        IMQConnection cxn = null;
        cxn = (IMQConnection)cm.getConnection(new ConnectionUID(id));
        if (cxn == null) {
            return null;
        }
        cxnInfo = cxn.getConnectionInfo();
        return cxnInfo;
    }

    private static String getHost(ConsumerUID cid) {
        ConnectionUID cxnId = GetConsumersHandler.getConnectionUID(cid);
        if (cxnId == null) {
            return null;
        }
        ConnectionInfo cxnInfo = GetConsumersHandler.getConnectionInfo(cxnId.longValue());
        if (cxnInfo == null) {
            return null;
        }
        String host = null;
        if (cxnInfo.remoteIP != null) {
            host = String.valueOf(IPAddress.rawIPToString(cxnInfo.remoteIP, true, true));
        }
        return host;
    }

    private static Long getLastAckTime(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        return new Long(con.getLastAckTime());
    }

    private static Long getNumMsgs(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        return new Long(con.totalMsgsDelivered());
    }

    private static Long getNumMsgsPendingAcks(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        return new Long(con.numPendingAcks());
    }

    private static String getSelector(ConsumerUID cid) {
        Consumer con = Consumer.getConsumer(cid);
        if (con == null) {
            return null;
        }
        return con.getSelectorStr();
    }

    public static String getServiceOfConnection(long id) {
        ConnectionInfo cxnInfo = GetConsumersHandler.getConnectionInfo(id);
        if (cxnInfo == null) {
            return null;
        }
        return cxnInfo.service;
    }

    private static String getServiceName(ConsumerUID cid) {
        ConnectionUID cxnId = GetConsumersHandler.getConnectionUID(cid);
        if (cxnId == null) {
            return null;
        }
        String serviceName = GetConsumersHandler.getServiceOfConnection(cxnId.longValue());
        return serviceName;
    }

    private static String getUser(ConsumerUID cid) {
        ConnectionUID cxnId = GetConsumersHandler.getConnectionUID(cid);
        if (cxnId == null) {
            return null;
        }
        ConnectionInfo cxnInfo = GetConsumersHandler.getConnectionInfo(cxnId.longValue());
        if (cxnInfo == null) {
            return null;
        }
        return cxnInfo.user;
    }
}

