/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.MetricManager;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.MetricCounters;
import java.util.Hashtable;

public class GetMetricsHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetMetricsHandler.getDEBUG();

    public GetMetricsHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + cmd_props);
        }
        int status = 200;
        String errMsg = null;
        String service = (String)cmd_props.get("JMQServiceName");
        String destination = (String)cmd_props.get("JMQDestination");
        Integer type = (Integer)cmd_props.get("JMQDestType");
        Cloneable replyobj = null;
        String msgtype = null;
        if (destination != null) {
            try {
                Destination[] ds = DestinationList.getDestination(null, destination, DestType.isQueue(type == null ? 0 : type));
                Destination d = ds[0];
                if (d == null) {
                    status = 404;
                    int mytype = type == null ? 0 : type;
                    errMsg = this.rb.getString("B3128", this.getDestinationType(mytype), destination);
                } else {
                    replyobj = d.getMetrics();
                }
            }
            catch (Exception ex) {
                int mytype = type == null ? 0 : type;
                errMsg = this.rb.getString("B3128", this.getDestinationType(mytype), destination);
                status = 500;
                this.logger.log(32, "B3100", (Object)(this.getClass().getName() + ": failed to get destination (" + DestType.toString(mytype) + ":" + destination + ")"), (Throwable)ex);
            }
            msgtype = "DESTINATION";
        } else {
            ServiceManager sm = Globals.getServiceManager();
            MetricManager mm = Globals.getMetricManager();
            MetricCounters mc = null;
            if (service != null && sm.getServiceType(service) == -1) {
                status = 404;
                errMsg = this.rb.getString("B4057", service);
            } else {
                mc = mm.getMetricCounters(service);
                if (service != null) {
                    msgtype = "SERVICE";
                }
                replyobj = mc;
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        Hashtable<String, String> pr = new Hashtable<String, String>();
        if (msgtype != null) {
            pr.put("JMQBodyType", msgtype);
        }
        GetMetricsHandler.setProperties(reply, 53, status, errMsg, pr);
        if (replyobj != null) {
            this.setBodyObject(reply, replyobj);
        }
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

