/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ServiceUtil;
import com.sun.messaging.jmq.jmsserver.service.MetricManager;
import com.sun.messaging.jmq.util.MetricCounters;
import com.sun.messaging.jms.management.server.MQObjectName;
import com.sun.messaging.jms.management.server.ServiceNotification;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class ServiceManagerMonitor
extends MQMBeanReadOnly {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;
    private static String[] svcNotificationTypes;
    private static MBeanNotificationInfo[] notifs;

    public Long getMsgBytesIn() {
        MetricCounters mc = this.getMetricsForAllServices();
        return new Long(mc.messageBytesIn);
    }

    public Long getMsgBytesOut() {
        MetricCounters mc = this.getMetricsForAllServices();
        return new Long(mc.messageBytesOut);
    }

    public Integer getNumActiveThreads() {
        MetricCounters mc = this.getMetricsForAllServices();
        return new Integer(mc.threadsActive);
    }

    public Long getNumMsgsIn() {
        MetricCounters mc = this.getMetricsForAllServices();
        return new Long(mc.messagesIn);
    }

    public Long getNumMsgsOut() {
        MetricCounters mc = this.getMetricsForAllServices();
        return new Long(mc.messagesOut);
    }

    public Long getNumPktsIn() {
        MetricCounters mc = this.getMetricsForAllServices();
        return new Long(mc.packetsIn);
    }

    public Long getNumPktsOut() {
        MetricCounters mc = this.getMetricsForAllServices();
        return new Long(mc.packetsOut);
    }

    public Integer getNumServices() {
        List l = ServiceUtil.getVisibleServiceNames();
        return new Integer(l.size());
    }

    public Long getPktBytesIn() {
        MetricCounters mc = this.getMetricsForAllServices();
        return new Long(mc.packetBytesIn);
    }

    public Long getPktBytesOut() {
        MetricCounters mc = this.getMetricsForAllServices();
        return new Long(mc.packetBytesOut);
    }

    public ObjectName[] getServices() throws MBeanException {
        List l = ServiceUtil.getVisibleServiceNames();
        if (l.size() == 0) {
            return null;
        }
        ObjectName[] oNames = new ObjectName[l.size()];
        Iterator iter = l.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String service = (String)iter.next();
            try {
                ObjectName o = MQObjectName.createServiceMonitor(service);
                oNames[i++] = o;
            }
            catch (Exception e) {
                this.handleOperationException("getServices", e);
            }
        }
        return oNames;
    }

    @Override
    public String getMBeanName() {
        return "ServiceManagerMonitor";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1239");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyServicePause(String name) {
        ServiceNotification sn = new ServiceNotification("mq.service.pause", this, this.sequenceNumber++);
        sn.setServiceName(name);
        this.sendNotification(sn);
    }

    public void notifyServiceResume(String name) {
        ServiceNotification sn = new ServiceNotification("mq.service.resume", this, this.sequenceNumber++);
        sn.setServiceName(name);
        this.sendNotification(sn);
    }

    private MetricCounters getMetricsForAllServices() {
        MetricManager mm = Globals.getMetricManager();
        MetricCounters mc = null;
        mc = mm.getMetricCounters(null);
        return mc;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[10];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("MsgBytesIn", Long.class.getName(), mbr.getString("MB1225"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("MsgBytesOut", Long.class.getName(), mbr.getString("MB1226"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("NumActiveThreads", Integer.class.getName(), mbr.getString("MB1227"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("NumMsgsIn", Long.class.getName(), mbr.getString("MB1228"), true, false, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("NumMsgsOut", Long.class.getName(), mbr.getString("MB1229"), true, false, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("NumPktsIn", Long.class.getName(), mbr.getString("MB1230"), true, false, false);
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("NumPktsOut", Long.class.getName(), mbr.getString("MB1231"), true, false, false);
        mBeanAttributeInfoArray[7] = new MBeanAttributeInfo("NumServices", Integer.class.getName(), mbr.getString("MB1232"), true, false, false);
        mBeanAttributeInfoArray[8] = new MBeanAttributeInfo("PktBytesIn", Long.class.getName(), mbr.getString("MB1233"), true, false, false);
        mBeanAttributeInfoArray[9] = new MBeanAttributeInfo("PktBytesOut", Long.class.getName(), mbr.getString("MB1234"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[1];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getServices", mbr.getString("MB1238"), null, ObjectName[].class.getName(), 0);
        ops = mBeanOperationInfoArray;
        svcNotificationTypes = new String[]{"mq.service.pause", "mq.service.resume"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(svcNotificationTypes, ServiceNotification.class.getName(), mbr.getString("MB1220"));
        notifs = mBeanNotificationInfoArray;
    }
}

